/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.gui.LeftRight;
import fi.dy.masa.malilib.util.FileNameUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.time.DurationFormat;
import java.io.File;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1074;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2535;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_642;
import org.jetbrains.annotations.NotNull;

public class StringUtils {
    @Nullable
    public static class_2960 identifier(String fullPath) {
        try {
            return class_2960.method_60654((String)fullPath);
        }
        catch (Exception e) {
            MaLiLib.LOGGER.error("Exception while trying to create a ResourceLocation: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    public static class_2960 identifier(String nameSpace, String path) {
        try {
            return class_2960.method_60655((String)nameSpace, (String)path);
        }
        catch (Exception e) {
            MaLiLib.LOGGER.error("Exception while trying to create a ResourceLocation: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static String getModVersionString(String modId) {
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            if (!container.getMetadata().getId().equals(modId)) continue;
            return container.getMetadata().getVersion().getFriendlyString();
        }
        return "?";
    }

    public static String stripExtensionIfMatches(String str, String extension) {
        if (str.endsWith(extension) && str.length() > extension.length()) {
            return str.substring(0, str.length() - extension.length());
        }
        return str;
    }

    public static int getColor(String colorStr, int defaultColor) {
        Pattern pattern = Pattern.compile("(?:0x|#)([a-fA-F0-9]{1,8})");
        Matcher matcher = pattern.matcher(colorStr);
        if (matcher.matches()) {
            try {
                return (int)Long.parseLong(matcher.group(1), 16);
            }
            catch (NumberFormatException e) {
                return defaultColor;
            }
        }
        try {
            return Integer.parseInt(colorStr, 10);
        }
        catch (NumberFormatException e) {
            return defaultColor;
        }
    }

    public static String splitCamelCase(String str) {
        if (((String)(str = ((String)str).replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " "))).length() > 1 && ((String)str).charAt(0) > 'Z') {
            str = ((String)str).substring(0, 1).toUpperCase(Locale.ROOT) + ((String)str).substring(1);
        }
        return str;
    }

    public static boolean containsOrderedCharacters(String needle, String haystack) {
        int needleLength = needle.length();
        int startIndex = 0;
        for (int i = 0; i < needleLength; ++i) {
            startIndex = haystack.indexOf(needle.charAt(i), startIndex);
            if (startIndex == -1) {
                return false;
            }
            ++startIndex;
        }
        return true;
    }

    public static void sendOpenFileChatMessage(class_1657 sender, String messageKey, File file) {
        class_5250 name = class_2561.method_43470((String)file.getName()).method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, file.getAbsolutePath())));
        sender.method_7353((class_2561)class_2561.method_43469((String)messageKey, (Object[])new Object[]{name}), false);
    }

    public static void sendOpenFileChatMessage(class_1657 sender, String messageKey, Path file) {
        class_5250 name = class_2561.method_43470((String)file.getFileName().toString()).method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, file.toAbsolutePath().toString())));
        sender.method_7353((class_2561)class_2561.method_43469((String)messageKey, (Object[])new Object[]{name}), false);
    }

    public static int getMaxStringRenderWidth(String ... strings) {
        return StringUtils.getMaxStringRenderWidth(Arrays.asList(strings));
    }

    public static int getMaxStringRenderWidth(List<String> lines) {
        return StringUtils.getMaxStringRenderWidth(lines, (String l) -> l);
    }

    public static int getMaxStringRenderWidth(Function<String, String> translator, String ... strings) {
        return StringUtils.getMaxStringRenderWidth(Arrays.asList(strings), translator);
    }

    public static int getMaxStringRenderWidth(List<String> lines, Function<String, String> translator) {
        int width = 0;
        for (String line : lines) {
            width = Math.max(width, StringUtils.getStringWidth(translator.apply(line)));
        }
        return width;
    }

    public static <T> int getMaxStringRenderWidthOfObjects(List<T> list, Function<T, String> translator) {
        int width = 0;
        for (T item : list) {
            width = Math.max(width, StringUtils.getStringWidth(translator.apply(item)));
        }
        return width;
    }

    public static void addTranslatedLines(List<String> linesOut, String translationKey) {
        String[] parts = StringUtils.translate(translationKey, new Object[0]).split("\\\\n|\\n");
        Collections.addAll(linesOut, parts);
    }

    public static void splitTextToLines(List<String> linesOut, String textIn, int maxLineLength) {
        String[] lines = textIn.split("\\\\n|\\n");
        String activeColor = null;
        for (String line : lines) {
            String[] parts = line.split(" ");
            StringBuilder sb = new StringBuilder(256);
            int spaceWidth = StringUtils.getStringWidth(" ");
            int lineWidth = 0;
            for (String str : parts) {
                int width = StringUtils.getStringWidth(str);
                if (lineWidth + width + spaceWidth > maxLineLength) {
                    if (lineWidth > 0) {
                        linesOut.add(sb.toString());
                        sb = new StringBuilder(256);
                        lineWidth = 0;
                    }
                    if (width > maxLineLength) {
                        int chars = str.length();
                        for (int i = 0; i < chars; ++i) {
                            String c = str.substring(i, i + 1);
                            if (c.equals("\u00a7") && i < chars - 1) {
                                activeColor = str.substring(i, i + 2);
                                sb.append(activeColor);
                                ++i;
                                continue;
                            }
                            if ((lineWidth += StringUtils.getStringWidth(c)) > maxLineLength) {
                                linesOut.add(sb.toString());
                                sb = new StringBuilder(256);
                                lineWidth = 0;
                                if (activeColor != null) {
                                    sb.append(activeColor);
                                }
                            }
                            sb.append(c);
                        }
                        linesOut.add(sb.toString());
                        sb = new StringBuilder(256);
                        lineWidth = 0;
                    }
                }
                if (lineWidth > 0) {
                    sb.append(" ");
                }
                if (width > maxLineLength) continue;
                sb.append(str);
                lineWidth += width + spaceWidth;
            }
            linesOut.add(sb.toString());
        }
    }

    public static String getClampedDisplayStringStrlen(List<String> list, int maxWidth, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(prefix);
        int width = prefix.length() + suffix.length();
        int size = list.size();
        if (size > 0) {
            for (int i = 0; i < size && width < maxWidth; ++i) {
                String str;
                int len;
                int end;
                if (i > 0) {
                    sb.append(", ");
                    width += 2;
                }
                if ((end = Math.min(len = (str = list.get(i)).length(), maxWidth - width)) < len) {
                    end = Math.max(0, Math.min(len, maxWidth - width - 3));
                    if (end >= 1) {
                        sb.append(str.substring(0, end));
                    }
                    sb.append("...");
                    width += end + 3;
                    continue;
                }
                sb.append(str);
                width += len;
            }
        } else {
            sb.append("<empty>");
        }
        sb.append(suffix);
        return sb.toString();
    }

    public static String getDisplayStringForList(List<String> list, int maxWidth, String quote, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(prefix);
        String entrySep = ", ";
        String dots = " ...";
        int listSize = list.size();
        int widthQuotes = StringUtils.getStringWidth(quote) * 2;
        int widthSep = StringUtils.getStringWidth(entrySep);
        int widthDots = StringUtils.getStringWidth(dots);
        int widthNextMin = widthSep + widthDots;
        int width = StringUtils.getStringWidth(prefix) + StringUtils.getStringWidth(suffix);
        if (listSize > 0) {
            int len;
            for (int listIndex = 0; listIndex < listSize && width < maxWidth; width += len, ++listIndex) {
                int widthNext;
                if (listIndex > 0) {
                    sb.append(entrySep);
                    width += widthSep;
                }
                String str = list.get(listIndex);
                len = StringUtils.getStringWidth(str) + widthQuotes;
                int n = widthNext = listIndex < listSize - 1 ? widthNextMin : 0;
                if (width + len + widthNext <= maxWidth) {
                    sb.append(quote).append(str).append(quote);
                    continue;
                }
                if (width + StringUtils.getStringWidth(str.substring(0, 1)) + widthDots <= maxWidth) {
                    String c;
                    int charWidth;
                    sb.append(quote);
                    width += widthQuotes;
                    for (int i = 0; i < str.length() && width + (charWidth = StringUtils.getStringWidth(c = str.substring(i, i + 1))) + widthDots <= maxWidth; ++i) {
                        sb.append(c);
                        width += charWidth;
                    }
                    sb.append(quote);
                }
                sb.append(dots);
                break;
            }
        } else {
            sb.append("<empty>");
        }
        sb.append(suffix);
        return sb.toString();
    }

    public static String getClampedDisplayStringRenderlen(List<String> list, int maxWidth, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(prefix);
        String entrySep = ", ";
        String dots = " ...";
        int listSize = list.size();
        int widthSep = StringUtils.getStringWidth(entrySep);
        int widthDots = StringUtils.getStringWidth(dots);
        int width = StringUtils.getStringWidth(prefix) + StringUtils.getStringWidth(suffix);
        if (listSize > 0) {
            int len;
            for (int listIndex = 0; listIndex < listSize && width < maxWidth; width += len, ++listIndex) {
                String c;
                int charWidth;
                String str;
                if (listIndex > 0) {
                    sb.append(entrySep);
                    width += widthSep;
                }
                if (width + (len = StringUtils.getStringWidth(str = list.get(listIndex))) <= maxWidth) {
                    sb.append(str);
                    continue;
                }
                for (int i = 0; i < str.length() && width + (charWidth = StringUtils.getStringWidth(c = str.substring(i, i + 1))) + widthDots <= maxWidth; ++i) {
                    sb.append(c);
                    width += charWidth;
                }
                sb.append(dots);
                width += widthDots;
                break;
            }
        } else {
            sb.append("<empty>");
        }
        sb.append(suffix);
        return sb.toString();
    }

    public static String clampTextToRenderLength(String text, int maxWidth, LeftRight side, String indicator) {
        String chr;
        int charWidth;
        if (StringUtils.getStringWidth(text) <= maxWidth) {
            return text;
        }
        StringBuilder sb = new StringBuilder(128);
        int indicatorWidth = StringUtils.getStringWidth(indicator);
        int stringLen = text.length();
        int usedWidth = indicatorWidth;
        int index = 0;
        int lastIndex = stringLen - 1;
        int indexIncrement = 1;
        if (side == LeftRight.LEFT) {
            index = stringLen - 1;
            lastIndex = 0;
            indexIncrement = -1;
        }
        while (usedWidth < maxWidth && usedWidth + (charWidth = StringUtils.getStringWidth(chr = text.substring(index, index + 1))) <= maxWidth) {
            sb.append(chr);
            usedWidth += charWidth;
            if (index == lastIndex) break;
            index += indexIncrement;
        }
        if (side == LeftRight.LEFT) {
            return indicator + String.valueOf(sb.reverse());
        }
        sb.append(indicator);
        return sb.toString();
    }

    @Nullable
    public static String getWorldOrServerNameOrDefault(String defaultStr) {
        String name = StringUtils.getWorldOrServerName();
        return name != null ? name : defaultStr;
    }

    @Nullable
    public static String getWorldOrServerName() {
        class_310 mc = class_310.method_1551();
        if (mc.method_1496()) {
            class_1132 server = mc.method_1576();
            if (server != null) {
                String name = server.method_27728().method_150();
                return FileNameUtils.generateSafeFileName(name);
            }
        } else {
            class_642 server;
            if (mc.method_1558() != null && mc.method_1558().method_52811()) {
                class_2535 connection;
                if (MaLiLibConfigs.Generic.REALMS_COMMON_CONFIG.getBooleanValue()) {
                    return "realms";
                }
                class_634 handler = mc.method_1562();
                class_2535 class_25352 = connection = handler != null ? handler.method_48296() : null;
                if (connection != null) {
                    return "realms_" + StringUtils.stringifyAddress(connection.method_10755());
                }
            }
            if ((server = mc.method_1558()) != null) {
                return server.field_3761.replace(':', '_');
            }
            return "multiplayer_fallback";
        }
        return null;
    }

    public static String getStorageFileName(boolean globalData, String prefix, String suffix, String defaultName) {
        Object name = StringUtils.getWorldOrServerName();
        if (name != null) {
            if (globalData) {
                return prefix + (String)name + suffix;
            }
            class_638 world = class_310.method_1551().field_1687;
            if (world != null) {
                return prefix + (String)name + "_dim_" + WorldUtils.getDimensionId((class_1937)world) + suffix;
            }
        } else {
            name = prefix + defaultName + suffix;
        }
        return FileNameUtils.generateSafeFileName((String)name) + suffix;
    }

    public static String stringifyAddress(SocketAddress address) {
        String str = address.toString();
        if (str.contains("/")) {
            str = str.substring(str.indexOf(47) + 1);
        }
        return str.replace(':', '_');
    }

    public static String getPrettyFileSizeText(long fileSize, int decimalPlaces) {
        String[] units = new String[]{"B", "KiB", "MiB", "GiB", "TiB"};
        String unitStr = "";
        double size = fileSize;
        String[] stringArray = units;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String unit;
            unitStr = unit = stringArray[i];
            if (size < 1024.0) break;
            size /= 1024.0;
        }
        String fmt = "%." + decimalPlaces + "f %s";
        return String.format(fmt, size, unitStr);
    }

    public static List<String> translateAndLineSplit(String translationKey, Object ... args) {
        String translated = StringUtils.translate(translationKey, args);
        return Arrays.asList(translated.split("\\\\n|\\n"));
    }

    public static void translateAndLineSplit(Consumer<String> lineConsumer, String translationKey, Object ... args) {
        String translated = StringUtils.translate(translationKey, args);
        for (String line : translated.split("\\\\n|\\n")) {
            lineConsumer.accept(line);
        }
    }

    @Nullable
    public static String getTranslatedOrFallback(String key, @Nullable String fallback) {
        String translated = StringUtils.translate(key, new Object[0]);
        if (!key.equals(translated)) {
            return translated;
        }
        return fallback;
    }

    public static class_2561 getTranslatedAsTextOrFallback(String key, @Nullable String fallback) {
        String result = StringUtils.getTranslatedOrFallback(key, fallback);
        if (result == null) {
            return class_2561.method_43473();
        }
        return class_2561.method_30163((String)result);
    }

    public static String translate(String translationKey, Object ... args) {
        try {
            if (MaLiLibConfigs.Debug.PRINT_TRANSLATION_KEYS.getBooleanValue() && StringUtils.hasTranslation(translationKey)) {
                MaLiLib.LOGGER.info("Translation key: {}", (Object)translationKey);
            }
            return class_1074.method_4662((String)translationKey, (Object[])args);
        }
        catch (Exception e) {
            return translationKey;
        }
    }

    public static class_2561 translateAsText(String translationKey, Object ... args) {
        return class_2561.method_30163((String)StringUtils.translate(translationKey, args));
    }

    public static class_5250 translateable(String translationKey) {
        return class_2561.method_43471((String)translationKey);
    }

    public static class_5250 translateable(String translationKey, Object ... args) {
        return class_2561.method_43469((String)translationKey, (Object[])args);
    }

    public static boolean hasTranslation(String translationKey) {
        return class_1074.method_4663((String)translationKey);
    }

    public static String prettifyRawTranslationPath(@NotNull String translationPath) {
        return Arrays.stream(translationPath.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    public static int getFontHeight() {
        Objects.requireNonNull(class_310.method_1551().field_1772);
        return 9;
    }

    public static int getStringWidth(String text) {
        return class_310.method_1551().field_1772.method_1727(text);
    }

    public static void drawString(int x, int y, int color, String text, class_332 drawContext) {
        drawContext.method_51433(class_310.method_1551().field_1772, text, x, y, color, false);
    }

    public static String getDurationString(long durationMs) {
        return DurationFormat.PRETTY.format(durationMs);
    }
}

