/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.interfaces.IDataSyncer;
import fi.dy.masa.malilib.interfaces.IInventoryOverlayHandler;
import fi.dy.masa.malilib.mixin.entity.IMixinAbstractHorseEntity;
import fi.dy.masa.malilib.mixin.entity.IMixinPiglinEntity;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.test.TestDataSyncer;
import fi.dy.masa.malilib.test.TestRayTraceUtils;
import fi.dy.masa.malilib.test.TestRenderHandler;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_3695;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4836;
import net.minecraft.class_7225;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class TestInventoryOverlayHandler
implements IInventoryOverlayHandler {
    private static final TestInventoryOverlayHandler INSTANCE = new TestInventoryOverlayHandler();
    IDataSyncer syncer;
    InventoryOverlay.Context context;
    InventoryOverlay.Refresher refresher;

    public static TestInventoryOverlayHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public String getModId() {
        return "malilib";
    }

    @Override
    public IDataSyncer getDataSyncer() {
        if (this.syncer == null) {
            this.syncer = TestDataSyncer.getInstance();
        }
        return this.syncer;
    }

    @Override
    public void setDataSyncer(IDataSyncer syncer) {
        this.syncer = syncer;
    }

    @Override
    public InventoryOverlay.Refresher getRefreshHandler() {
        if (this.refresher == null) {
            this.refresher = new Refresher();
        }
        return this.refresher;
    }

    @Override
    public boolean isEmpty() {
        return this.context == null;
    }

    @Override
    @Nullable
    public InventoryOverlay.Context getRenderContextNullable() {
        return this.context;
    }

    @Override
    @Nullable
    public InventoryOverlay.Context getRenderContext(class_332 drawContext, class_3695 profiler, class_310 mc) {
        profiler.method_15396(this.getClass().getName() + "_inventory_overlay");
        this.getTargetInventory(mc);
        if (!this.isEmpty()) {
            if (MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY_OG.getBooleanValue()) {
                TestRenderHandler.renderInventoryOverlayOG(this.getRenderContextNullable(), drawContext, mc);
            } else {
                this.renderInventoryOverlay(this.getRenderContextNullable(), drawContext, mc, true, true);
            }
        }
        profiler.method_15407();
        return this.getRenderContextNullable();
    }

    @Override
    @Nullable
    public InventoryOverlay.Context getTargetInventory(class_310 mc) {
        class_1657 serverPlayer;
        class_1937 world = WorldUtils.getBestWorld(mc);
        class_1297 cameraEntity = EntityUtils.getCameraEntity();
        this.context = null;
        if (mc.field_1724 == null || world == null) {
            return null;
        }
        if (cameraEntity == mc.field_1724 && world instanceof class_3218 && (serverPlayer = world.method_18470(mc.field_1724.method_5667())) != null) {
            cameraEntity = serverPlayer;
        }
        if (cameraEntity == null) {
            return null;
        }
        class_239 trace = TestRayTraceUtils.getRayTraceFromEntity(world, cameraEntity, false);
        class_2487 nbt = new class_2487();
        if (trace == null) {
            return null;
        }
        if (trace.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = ((class_3965)trace).method_17777();
            class_2680 state = world.method_8320(pos);
            class_2248 blockTmp = state.method_26204();
            class_2586 be = null;
            if (blockTmp instanceof class_2343) {
                if (world instanceof class_3218) {
                    be = world.method_8500(pos).method_8321(pos);
                    if (be != null) {
                        nbt = be.method_38242((class_7225.class_7874)world.method_30349());
                    }
                } else {
                    Pair<class_2586, class_2487> pair = this.getDataSyncer().requestBlockEntity(world, pos);
                    if (pair != null) {
                        nbt = (class_2487)pair.getRight();
                    }
                }
                return this.getTargetInventoryFromBlock(world, pos, be, nbt);
            }
            return null;
        }
        if (trace.method_17783() == class_239.class_240.field_1331) {
            class_1297 entity = ((class_3966)trace).method_17782();
            if (world instanceof class_3218) {
                if (entity.method_5786(nbt)) {
                    return this.getTargetInventoryFromEntity(world.method_8469(entity.method_5628()), nbt);
                }
            } else {
                Pair<class_1297, class_2487> pair = this.getDataSyncer().requestEntity(world, entity.method_5628());
                if (pair != null) {
                    return this.getTargetInventoryFromEntity(world.method_8469(((class_1297)pair.getLeft()).method_5628()), (class_2487)pair.getRight());
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public InventoryOverlay.Context getTargetInventoryFromBlock(class_1937 world, class_2338 pos, @Nullable class_2586 be, class_2487 nbt) {
        class_1263 inv;
        if (be != null) {
            if (nbt.method_33133()) {
                nbt = be.method_38242((class_7225.class_7874)world.method_30349());
            }
            inv = InventoryUtils.getInventory(world, pos);
        } else {
            Pair<class_2586, class_2487> pair;
            if (nbt.method_33133() && (pair = this.getDataSyncer().requestBlockEntity(world, pos)) != null) {
                nbt = (class_2487)pair.getRight();
            }
            inv = this.getDataSyncer().getBlockInventory(world, pos, false);
        }
        if (nbt != null && !nbt.method_33133()) {
            class_1263 inv2 = InventoryUtils.getNbtInventory(nbt, inv != null ? inv.method_5439() : -1, (class_7225.class_7874)world.method_30349());
            if (inv == null) {
                inv = inv2;
            }
        }
        MaLiLib.LOGGER.warn("getTarget():3: pos [{}], inv [{}], be [{}], nbt [{}]", (Object)pos.method_23854(), (Object)(inv != null ? 1 : 0), (Object)(be != null ? 1 : 0), (Object)(nbt != null ? nbt.method_10558("id") : new class_2487()));
        if (inv == null || nbt == null) {
            return null;
        }
        this.context = new InventoryOverlay.Context(InventoryOverlay.getBestInventoryType(inv, nbt), inv, be != null ? be : world.method_8321(pos), null, nbt, this.getRefreshHandler());
        return this.context;
    }

    @Override
    @Nullable
    public InventoryOverlay.Context getTargetInventoryFromEntity(class_1297 entity, class_2487 nbt) {
        class_1263 inv = null;
        class_1309 entityLivingBase = null;
        if (entity instanceof class_1309) {
            entityLivingBase = (class_1309)entity;
        }
        if (entity instanceof class_1263) {
            inv = (class_1263)entity;
        } else if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            inv = new class_1277((class_1799[])player.method_31548().field_7547.toArray((Object[])new class_1799[36]));
        } else if (entity instanceof class_1646) {
            inv = ((class_1646)entity).method_35199();
        } else if (entity instanceof class_1496) {
            inv = ((IMixinAbstractHorseEntity)entity).malilib_getHorseInventory();
        } else if (entity instanceof class_4836) {
            inv = ((IMixinPiglinEntity)entity).malilib_getInventory();
        }
        if (!nbt.method_33133()) {
            class_1263 inv2;
            MaLiLib.LOGGER.warn("getTargetInventoryFromEntity(): rawNbt: [{}]", (Object)nbt.toString());
            if (inv != null && nbt.method_10545("Items") && nbt.method_10554("Items", 10).size() > 1) {
                inv2 = entity instanceof class_1496 ? InventoryUtils.getNbtInventoryHorseFix(nbt, -1, (class_7225.class_7874)entity.method_56673()) : InventoryUtils.getNbtInventory(nbt, -1, (class_7225.class_7874)entity.method_56673());
                inv = null;
            } else if (inv != null && nbt.method_10545("SaddleItem")) {
                inv2 = InventoryUtils.getNbtInventoryHorseFix(nbt, -1, (class_7225.class_7874)entity.method_56673());
                inv = null;
            } else if (inv != null && inv.method_5439() == 8 && nbt.method_10545("Inventory") && !nbt.method_10554("Inventory", 10).isEmpty()) {
                inv2 = InventoryUtils.getNbtInventory(nbt, 8, (class_7225.class_7874)entity.method_56673());
                inv = null;
            } else {
                inv2 = InventoryUtils.getNbtInventory(nbt, inv != null ? inv.method_5439() : -1, (class_7225.class_7874)entity.method_56673());
                if (inv2 != null) {
                    inv = null;
                }
            }
            MaLiLib.LOGGER.error("getTargetInventoryFromEntity(): inv.size [{}], inv2.size [{}]", inv != null ? Integer.valueOf(inv.method_5439()) : "null", inv2 != null ? Integer.valueOf(inv2.method_5439()) : "null");
            if (inv2 != null) {
                inv = inv2;
            }
        }
        if (inv == null && entityLivingBase == null) {
            return null;
        }
        this.context = new InventoryOverlay.Context(inv != null ? InventoryOverlay.getBestInventoryType(inv, nbt) : InventoryOverlay.getInventoryType(nbt), inv, null, entityLivingBase, nbt, this.getRefreshHandler());
        return this.context;
    }

    public static class Refresher
    implements InventoryOverlay.Refresher {
        @Override
        public InventoryOverlay.Context onContextRefresh(InventoryOverlay.Context data, class_1937 world) {
            if (data.be() != null) {
                TestInventoryOverlayHandler.getInstance().requestBlockEntityAt(world, data.be().method_11016());
                data = TestInventoryOverlayHandler.getInstance().getTargetInventoryFromBlock(data.be().method_10997(), data.be().method_11016(), data.be(), data.nbt());
            } else if (data.entity() != null) {
                TestInventoryOverlayHandler.getInstance().getDataSyncer().requestEntity(world, data.entity().method_5628());
                data = TestInventoryOverlayHandler.getInstance().getTargetInventoryFromEntity((class_1297)data.entity(), data.nbt());
            }
            return data;
        }
    }
}

