/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodQuadBuilder;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.RenderDataPointUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.coreapi.util.MathUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ColumnBox {
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final byte SKYLIGHT_EMPTY = -1;
    private static final byte SKYLIGHT_COVERED = -2;
    private static final ThreadLocal<byte[]> THREAD_LOCAL_SKY_LIGHT_ARRAY = ThreadLocal.withInitial(() -> {
        byte[] array = new byte[4096];
        Arrays.fill(array, (byte)-1);
        return array;
    });

    public static void addBoxQuadsToBuilder(LodQuadBuilder builder, IDhClientLevel clientLevel, short xSize, short ySize, short zSize, short minX, short minY, short minZ, int color, byte irisBlockMaterialId, byte skyLight, byte blockLight, long topData, long bottomData, ColumnArrayView[] adjData, boolean[] isAdjDataSameDetailLevel) {
        boolean skipBottom;
        boolean skipTop;
        short maxX = (short)(minX + xSize);
        short maxY = (short)(minY + ySize);
        short maxZ = (short)(minZ + zSize);
        byte skyLightTop = skyLight;
        byte skyLightBot = RenderDataPointUtil.doesDataPointExist(bottomData) ? RenderDataPointUtil.getLightSky(bottomData) : (byte)0;
        boolean isTransparent = ColorUtil.getAlpha(color) < 255 && LodRenderer.transparencyEnabled;
        boolean overVoid = !RenderDataPointUtil.doesDataPointExist(bottomData);
        boolean isTopTransparent = RenderDataPointUtil.getAlpha(topData) < 255 && LodRenderer.transparencyEnabled;
        boolean isBottomTransparent = RenderDataPointUtil.getAlpha(bottomData) < 255 && LodRenderer.transparencyEnabled;
        int caveCullingMaxY = Integer.MIN_VALUE;
        if (Config.Client.Advanced.Graphics.Culling.enableCaveCulling.get().booleanValue()) {
            caveCullingMaxY = Config.Client.Advanced.Graphics.Culling.caveCullingHeight.get() - clientLevel.getMinY();
        }
        if (!RenderDataPointUtil.doesDataPointExist(bottomData)) {
            color = ColorUtil.setAlpha(color, 255);
        }
        if (LodRenderer.transparencyEnabled && LodRenderer.fakeOceanFloor) {
            if (!isTransparent && isTopTransparent && RenderDataPointUtil.doesDataPointExist(topData)) {
                skyLightTop = (byte)MathUtil.clamp(0, 15 - (RenderDataPointUtil.getYMax(topData) - minY), 15);
                ySize = (short)(RenderDataPointUtil.getYMax(topData) - minY - 1);
            } else if (isTransparent && !isBottomTransparent && RenderDataPointUtil.doesDataPointExist(bottomData)) {
                minY = (short)(minY + ySize - 1);
                ySize = 1;
            }
            maxY = (short)(minY + ySize);
        }
        boolean bl = skipTop = RenderDataPointUtil.doesDataPointExist(topData) && RenderDataPointUtil.getYMin(topData) == maxY && !isTopTransparent;
        if (!skipTop) {
            builder.addQuadUp(minX, maxY, minZ, xSize, zSize, ColorUtil.applyShade(color, MC.getShade(EDhDirection.UP)), irisBlockMaterialId, skyLightTop, blockLight);
        }
        boolean bl2 = skipBottom = RenderDataPointUtil.doesDataPointExist(bottomData) && RenderDataPointUtil.getYMax(bottomData) == minY && !isBottomTransparent;
        if (!skipBottom) {
            builder.addQuadDown(minX, minY, minZ, xSize, zSize, ColorUtil.applyShade(color, MC.getShade(EDhDirection.DOWN)), irisBlockMaterialId, skyLightBot, blockLight);
        }
        ColumnArrayView adjCol = adjData[EDhDirection.NORTH.ordinal() - 2];
        boolean adjSameDetailLevel = isAdjDataSameDetailLevel[EDhDirection.NORTH.ordinal() - 2];
        if (adjCol == null) {
            if (!isTransparent || overVoid) {
                builder.addQuadAdj(EDhDirection.NORTH, minX, minY, minZ, xSize, ySize, color, irisBlockMaterialId, (byte)15, blockLight);
            }
        } else {
            ColumnBox.makeAdjVerticalQuad(builder, adjCol, adjSameDetailLevel, caveCullingMaxY, EDhDirection.NORTH, minX, minY, minZ, xSize, ySize, color, irisBlockMaterialId, blockLight);
        }
        adjCol = adjData[EDhDirection.SOUTH.ordinal() - 2];
        adjSameDetailLevel = isAdjDataSameDetailLevel[EDhDirection.SOUTH.ordinal() - 2];
        if (adjCol == null) {
            if (!isTransparent || overVoid) {
                builder.addQuadAdj(EDhDirection.SOUTH, minX, minY, maxZ, xSize, ySize, color, irisBlockMaterialId, (byte)15, blockLight);
            }
        } else {
            ColumnBox.makeAdjVerticalQuad(builder, adjCol, adjSameDetailLevel, caveCullingMaxY, EDhDirection.SOUTH, minX, minY, maxZ, xSize, ySize, color, irisBlockMaterialId, blockLight);
        }
        adjCol = adjData[EDhDirection.WEST.ordinal() - 2];
        adjSameDetailLevel = isAdjDataSameDetailLevel[EDhDirection.WEST.ordinal() - 2];
        if (adjCol == null) {
            if (!isTransparent || overVoid) {
                builder.addQuadAdj(EDhDirection.WEST, minX, minY, minZ, zSize, ySize, color, irisBlockMaterialId, (byte)15, blockLight);
            }
        } else {
            ColumnBox.makeAdjVerticalQuad(builder, adjCol, adjSameDetailLevel, caveCullingMaxY, EDhDirection.WEST, minX, minY, minZ, zSize, ySize, color, irisBlockMaterialId, blockLight);
        }
        adjCol = adjData[EDhDirection.EAST.ordinal() - 2];
        adjSameDetailLevel = isAdjDataSameDetailLevel[EDhDirection.EAST.ordinal() - 2];
        if (adjCol == null) {
            if (!isTransparent || overVoid) {
                builder.addQuadAdj(EDhDirection.EAST, maxX, minY, minZ, zSize, ySize, color, irisBlockMaterialId, (byte)15, blockLight);
            }
        } else {
            ColumnBox.makeAdjVerticalQuad(builder, adjCol, adjSameDetailLevel, caveCullingMaxY, EDhDirection.EAST, maxX, minY, minZ, zSize, ySize, color, irisBlockMaterialId, blockLight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeAdjVerticalQuad(LodQuadBuilder builder, @NotNull ColumnArrayView adjColumnView, boolean adjacentIsSameDetailLevel, int caveCullingMaxY, EDhDirection direction, short x, short yMin, short z, short horizontalWidth, short ySize, int color, byte irisBlockMaterialId, byte blockLight) {
        color = ColorUtil.applyShade(color, MC.getShade(direction));
        if (adjColumnView.size == 0 || RenderDataPointUtil.isVoid(adjColumnView.get(0))) {
            builder.addQuadAdj(direction, x, (short)yMin, z, horizontalWidth, ySize, color, irisBlockMaterialId, (byte)15, blockLight);
            return;
        }
        short yMax = (short)(yMin + ySize);
        byte[] skyLightAtInputPos = THREAD_LOCAL_SKY_LIGHT_ARRAY.get();
        try {
            Arrays.fill(skyLightAtInputPos, yMin, (int)yMax, (byte)15);
            int adjCount = adjColumnView.size();
            for (int adjIndex = 0; adjIndex < adjCount; ++adjIndex) {
                byte skyLightAtPos;
                int i;
                int adjSkyLight;
                boolean adjTransparent;
                long adjPoint = adjColumnView.get(adjIndex);
                int adjMinY = RenderDataPointUtil.getYMin(adjPoint);
                int adjMaxY = RenderDataPointUtil.getYMax(adjPoint);
                if (!RenderDataPointUtil.doesDataPointExist(adjPoint) || RenderDataPointUtil.isVoid(adjPoint) || yMax <= adjMinY) continue;
                long adjAbovePoint = adjIndex != 0 ? adjColumnView.get(adjIndex - 1) : 0L;
                long adjBelowPoint = adjIndex + 1 < adjCount ? adjColumnView.get(adjIndex + 1) : 0L;
                boolean adjOverVoid = !RenderDataPointUtil.doesDataPointExist(adjBelowPoint);
                boolean bl = adjTransparent = !adjOverVoid && RenderDataPointUtil.getAlpha(adjPoint) < 255 && LodRenderer.transparencyEnabled;
                if (!adjTransparent) {
                    adjSkyLight = RenderDataPointUtil.getLightSky(adjPoint);
                    for (i = adjMinY; i < adjMaxY; ++i) {
                        skyLightAtPos = skyLightAtInputPos[i];
                        boolean adjacentCoversThis = !adjacentIsSameDetailLevel && RenderDataPointUtil.getYMax(adjPoint) >= caveCullingMaxY && (x == 0 && direction == EDhDirection.WEST || z == 0 && direction == EDhDirection.NORTH || x == 256 && direction == EDhDirection.EAST || z == 256 && direction == EDhDirection.SOUTH);
                        int newSkyLightAtPos = adjacentCoversThis ? adjSkyLight : -2;
                        skyLightAtInputPos[i] = (byte)Math.min(newSkyLightAtPos, skyLightAtPos);
                    }
                } else {
                    byte belowSkyLight = RenderDataPointUtil.getLightSky(adjBelowPoint);
                    for (i = adjMinY; i < adjMaxY; ++i) {
                        skyLightAtPos = skyLightAtInputPos[i];
                        skyLightAtInputPos[i] = (byte)Math.min(belowSkyLight, skyLightAtPos);
                    }
                }
                adjSkyLight = RenderDataPointUtil.getLightSky(adjPoint);
                short adjAboveMinY = RenderDataPointUtil.getYMin(adjAbovePoint);
                for (int i2 = adjMaxY; i2 < adjAboveMinY; ++i2) {
                    byte skyLightAtPos2 = skyLightAtInputPos[i2];
                    skyLightAtInputPos[i2] = (byte)Math.min(adjSkyLight, skyLightAtPos2);
                }
            }
            boolean inputTransparent = ColorUtil.getAlpha(color) < 255 && LodRenderer.transparencyEnabled;
            byte lastSkyLight = skyLightAtInputPos[yMin];
            int quadBottomY = yMin;
            int quadTopY = -1;
            for (int i = yMin; i < yMax; ++i) {
                byte skyLight = skyLightAtInputPos[i];
                if (skyLight != lastSkyLight) {
                    ColumnBox.tryAddVerticalFaceWithSkyLightToBuilder(builder, direction, x, z, horizontalWidth, color, irisBlockMaterialId, blockLight, lastSkyLight, inputTransparent, quadTopY, quadBottomY);
                    lastSkyLight = skyLight;
                    quadBottomY = i;
                }
                quadTopY = i + 1;
            }
            if (quadTopY != -1) {
                ColumnBox.tryAddVerticalFaceWithSkyLightToBuilder(builder, direction, x, z, horizontalWidth, color, irisBlockMaterialId, blockLight, lastSkyLight, inputTransparent, quadTopY, quadBottomY);
            }
        }
        finally {
            Arrays.fill(skyLightAtInputPos, yMin, (int)yMax, (byte)-1);
        }
    }

    private static void tryAddVerticalFaceWithSkyLightToBuilder(LodQuadBuilder builder, EDhDirection direction, short x, short z, short horizontalWidth, int color, byte irisBlockMaterialId, byte blockLight, byte lastSkyLight, boolean inputTransparent, int quadTopY, int quadBottomY) {
        short height;
        if (!(lastSkyLight < 0 || inputTransparent && lastSkyLight != 15 || (height = (short)(quadTopY - quadBottomY)) <= 0)) {
            builder.addQuadAdj(direction, x, (short)quadBottomY, z, horizontalWidth, height, color, irisBlockMaterialId, lastSkyLight, blockLight);
        }
    }
}

