/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.render;

import com.mojang.blaze3d.systems.RenderSystem;
import mod.crend.autohud.AutoHud;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.render.AutoHudRenderer;
import net.minecraft.class_332;

public interface AutoHudRenderLayer {
    public static final AutoHudRenderLayer DO_MOVE = new DoMove();
    public static final AutoHudRenderLayer DO_FADE = new DoFade();
    public static final AutoHudRenderLayer DO_REVERSE_TRANSLATION = new DoReverseTranslation();
    public static final AutoHudRenderLayer DO_GLOBAL_TRANSLATION = new DoGlobalTranslation();
    public static final AutoHudRenderLayer MOVE_MODE = new MoveMode();
    public static final AutoHudRenderLayer FADE_MODE = new FadeMode();
    public static final AutoHudRenderLayer FADE_MODE_WITH_REVERSE_TRANSLATION = new FadeModeWithReverseTranslation();

    default public boolean shouldApply() {
        return true;
    }

    public void doPreRender(Component var1, class_332 var2, float var3);

    default public void preRender(Component component, class_332 context, float minAlpha) {
        if (this.shouldApply()) {
            this.doPreRender(component, context, minAlpha);
        }
    }

    default public void preRender(Component component, class_332 context) {
        this.preRender(component, context, (float)component.config.maximumFade());
    }

    public void doPostRender(Component var1, class_332 var2);

    default public void postRender(Component component, class_332 context) {
        if (this.shouldApply()) {
            this.doPostRender(component, context);
        }
    }

    default public void wrap(Component component, class_332 context, Runnable original) {
        this.wrap(component, context, (float)component.config.maximumFade(), original);
    }

    default public void wrap(Component component, class_332 context, float minAlpha, Runnable original) {
        this.preRender(component, context, minAlpha);
        original.run();
        this.postRender(component, context);
    }

    public static class DoMove
    implements AutoHudRenderLayer {
        @Override
        public boolean shouldApply() {
            return AutoHud.config.animationMove() || !AutoHud.config.animationFade();
        }

        @Override
        public void doPreRender(Component component, class_332 context, float ignored) {
            AutoHudRenderer.active.add(component);
            context.method_51448().method_22903();
            if (component.isHidden()) {
                context.method_51448().method_22904(component.getOffsetX(AutoHudRenderer.tickDelta), component.getOffsetY(AutoHudRenderer.tickDelta), 0.0);
            }
        }

        @Override
        public void doPostRender(Component component, class_332 context) {
            AutoHudRenderer.active.remove(component);
            context.method_51448().method_22909();
        }
    }

    public static class DoFade
    implements AutoHudRenderLayer {
        @Override
        public boolean shouldApply() {
            return AutoHud.config.animationFade();
        }

        @Override
        public void doPreRender(Component component, class_332 context, float minAlpha) {
            AutoHudRenderer.alpha = Math.max(component.getAlpha(AutoHudRenderer.tickDelta), minAlpha);
            RenderSystem.enableBlend();
            float[] color = RenderSystem.getShaderColor();
            RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)(color[3] * AutoHudRenderer.alpha));
        }

        @Override
        public void doPostRender(Component component, class_332 context) {
            context.method_51452();
            AutoHudRenderer.alpha = 1.0f;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)AutoHudRenderer.alpha);
        }
    }

    public static class DoReverseTranslation
    implements AutoHudRenderLayer {
        @Override
        public boolean shouldApply() {
            return AutoHud.config.animationMove();
        }

        @Override
        public void doPreRender(Component component, class_332 context, float minAlpha) {
            context.method_51448().method_22903();
            if (component.isHidden()) {
                context.method_51448().method_22904(-component.getOffsetX(AutoHudRenderer.tickDelta), -component.getOffsetY(AutoHudRenderer.tickDelta), 0.0);
            }
        }

        @Override
        public void doPostRender(Component component, class_332 context) {
            context.method_51448().method_22909();
        }
    }

    public static class DoGlobalTranslation
    implements AutoHudRenderLayer {
        @Override
        public boolean shouldApply() {
            return AutoHudRenderer.globalOffsetX != 0.0f || AutoHudRenderer.globalOffsetY != 0.0f;
        }

        @Override
        public void doPreRender(Component component, class_332 context, float minAlpha) {
            context.method_51448().method_22903();
            context.method_51448().method_46416(AutoHudRenderer.globalOffsetX, AutoHudRenderer.globalOffsetY, 0.0f);
        }

        @Override
        public void doPostRender(Component component, class_332 context) {
            context.method_51448().method_22909();
        }
    }

    public static class MoveMode
    implements AutoHudRenderLayer {
        @Override
        public void doPreRender(Component component, class_332 context, float minAlpha) {
            DO_FADE.preRender(component, context, minAlpha);
            DO_MOVE.preRender(component, context, minAlpha);
        }

        @Override
        public void doPostRender(Component component, class_332 context) {
            DO_MOVE.postRender(component, context);
            DO_FADE.postRender(component, context);
        }
    }

    public static class FadeMode
    implements AutoHudRenderLayer {
        @Override
        public void doPreRender(Component component, class_332 context, float minAlpha) {
            DO_FADE.preRender(component, context, minAlpha);
        }

        @Override
        public void doPostRender(Component component, class_332 context) {
            DO_FADE.postRender(component, context);
        }
    }

    public static class FadeModeWithReverseTranslation
    implements AutoHudRenderLayer {
        @Override
        public void doPreRender(Component component, class_332 context, float minAlpha) {
            DO_FADE.preRender(component, context, minAlpha);
            DO_REVERSE_TRANSLATION.preRender(component, context, minAlpha);
            DO_GLOBAL_TRANSLATION.preRender(component, context, minAlpha);
        }

        @Override
        public void doPostRender(Component component, class_332 context) {
            DO_GLOBAL_TRANSLATION.postRender(component, context);
            DO_REVERSE_TRANSLATION.postRender(component, context);
            DO_FADE.postRender(component, context);
        }
    }
}

