/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mod.crend.autohud.AutoHud;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.component.Components;
import mod.crend.libbamboo.type.ItemOrTag;
import net.minecraft.class_10124;
import net.minecraft.class_10132;
import net.minecraft.class_10134;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_9334;

public class State {
    Map<class_6880<class_1291>, class_1293> previousStatusEffects;

    public State(class_746 player) {
        this.initStates(player);
        this.previousStatusEffects = new HashMap<class_6880<class_1291>, class_1293>();
    }

    public void initStates(class_746 player) {
        Component.getComponents().forEach(component -> component.initState(player));
        Components.ChatIndicator.hideNow();
        AutoHud.apis.forEach(api -> api.initState(player));
    }

    static boolean shouldShowCrosshair() {
        class_310 client = class_310.method_1551();
        if (client.field_1765 != null && client.field_1765.method_17783() != class_239.class_240.field_1333) {
            return true;
        }
        if (client.field_1724 != null) {
            for (ItemOrTag itemOrTag : AutoHud.config.crosshairAlwaysVisible()) {
                if (!itemOrTag.matches(client.field_1724.method_6047().method_7909()) && !itemOrTag.matches(client.field_1724.method_6079().method_7909())) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isFood(class_1799 itemStack) {
        return itemStack.method_57826(class_9334.field_53964);
    }

    private static boolean isHealEffect(class_1293 effect) {
        return effect.method_5579() == class_1294.field_5924 || effect.method_5579() == class_1294.field_5915 || effect.method_5579() == class_1294.field_5914 || effect.method_5579() == class_1294.field_5898;
    }

    static boolean canHeal() {
        block4: {
            class_1799 itemStack;
            block3: {
                itemStack = class_310.method_1551().field_1724.method_6047();
                if (!State.isFood(itemStack)) break block3;
                List consumeEffects = ((class_10124)itemStack.method_57824(class_9334.field_53964)).comp_3089();
                for (class_10134 consumeEffect : consumeEffects) {
                    if (!(consumeEffect instanceof class_10132)) continue;
                    class_10132 effect = (class_10132)consumeEffect;
                    for (class_1293 statusEffect : effect.comp_3094()) {
                        if (!State.isHealEffect(statusEffect)) continue;
                        return true;
                    }
                }
                break block4;
            }
            if (!(itemStack.method_7909() instanceof class_1812)) break block4;
            class_1842 potion = (class_1842)((class_1844)itemStack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274)).comp_2378().orElse(class_1847.field_8991).comp_349();
            for (class_1293 effect : potion.method_8049()) {
                if (!State.isHealEffect(effect)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean revealHotbarOnDurability(class_1799 itemStack) {
        if (itemStack.method_7963() && (double)itemStack.method_7919() >= (double)(100 - AutoHud.config.getHotbarDurabilityPercentage()) / 100.0 * (double)itemStack.method_7936() && itemStack.method_7936() - itemStack.method_7919() < AutoHud.config.getHotbarDurabilityTotal()) {
            Components.Hotbar.revealCombined();
            Components.Tooltip.revealCombined();
            return true;
        }
        return false;
    }

    public void tick(class_746 player) {
        if (player == null) {
            return;
        }
        Component.tickAll();
        if (AutoHud.config.isHotbarOnLowDurability() && !this.revealHotbarOnDurability(player.method_6047())) {
            this.revealHotbarOnDurability(player.method_6079());
        }
        if (AutoHud.config.revealExperienceTextWithHotbar()) {
            Components.ExperienceLevel.synchronizeFrom(Components.ExperienceBar, Components.Hotbar);
        }
        if (AutoHud.config.statusEffects().active()) {
            if (AutoHud.config.statusEffects().onChange()) {
                HashMap<class_6880<class_1291>, class_1293> newStatusEffects = new HashMap<class_6880<class_1291>, class_1293>();
                Map effects = player.method_6088();
                for (class_6880 effect : effects.keySet()) {
                    class_1293 effectInstance = (class_1293)effects.get(effect);
                    if (!effectInstance.method_5592() && !AutoHud.config.showHiddenStatusEffects()) continue;
                    if (effectInstance.method_5584() < 5) {
                        Component.get((class_6880<class_1291>)effect).hide();
                    } else if (!this.previousStatusEffects.containsKey(effect)) {
                        Component.get((class_6880<class_1291>)effect).revealFromHidden();
                    } else if (!AutoHud.config.hidePersistentStatusEffects() || !this.previousStatusEffects.get(effect).equals((Object)effectInstance)) {
                        Component.get((class_6880<class_1291>)effect).reveal();
                    }
                    newStatusEffects.put((class_6880<class_1291>)effect, new class_1293(effectInstance));
                }
                this.previousStatusEffects = newStatusEffects;
            }
        } else {
            Component.getStatusEffectComponents().forEach(Component::reveal);
            if (AutoHud.config.hidePersistentStatusEffects()) {
                HashMap<class_6880<class_1291>, class_1293> newStatusEffects = new HashMap<class_6880<class_1291>, class_1293>();
                Map effects = player.method_6088();
                for (class_6880 effect : effects.keySet()) {
                    class_1293 effectInstance = (class_1293)effects.get(effect);
                    if (!effectInstance.method_5592()) continue;
                    if (this.previousStatusEffects.containsKey(effect) && this.previousStatusEffects.get(effect).equals((Object)effectInstance)) {
                        Component.get((class_6880<class_1291>)effect).hideNow();
                    }
                    newStatusEffects.put((class_6880<class_1291>)effect, new class_1293(effectInstance));
                }
                this.previousStatusEffects = newStatusEffects;
            }
        }
        AutoHud.apis.forEach(api -> api.tickState(player));
    }
}

