/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities;

import foundationgames.enhancedblockentities.EBESetup;
import foundationgames.enhancedblockentities.EnhancedBlockEntityRegistry;
import foundationgames.enhancedblockentities.ReloadType;
import foundationgames.enhancedblockentities.client.model.ModelIdentifiers;
import foundationgames.enhancedblockentities.client.model.item.EBEIsChristmasProperty;
import foundationgames.enhancedblockentities.client.render.SignRenderManager;
import foundationgames.enhancedblockentities.client.resource.template.TemplateLoader;
import foundationgames.enhancedblockentities.config.EBEConfig;
import foundationgames.enhancedblockentities.util.EBEUtil;
import foundationgames.enhancedblockentities.util.ResourceUtil;
import foundationgames.enhancedblockentities.util.WorldUtil;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_10459;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class EnhancedBlockEntities
implements ClientModInitializer {
    public static final String ID = "enhancedblockentities";
    public static final String NAMESPACE = "ebe";
    public static final Logger LOG = LogManager.getLogger((String)"Enhanced Block Entities");
    public static final EBEConfig CONFIG = new EBEConfig();
    public static final TemplateLoader TEMPLATE_LOADER = new TemplateLoader();
    public static final String API_V1 = "ebe_v1";

    public void onInitializeClient() {
        FabricLoader.getInstance().getModContainer(ID).ifPresent(mod -> {
            List roots = mod.getRootPaths();
            if (roots.size() > 0) {
                TEMPLATE_LOADER.setRoot(((Path)roots.get(0)).resolve("templates"));
            }
        });
        List ebeCompatInitializers = FabricLoader.getInstance().getEntrypointContainers(API_V1, Consumer.class);
        for (EntrypointContainer init : ebeCompatInitializers) {
            ((Consumer)init.getEntrypoint()).accept(EnhancedBlockEntities::load);
        }
        class_10459.field_55372.method_65325((Object)EBEUtil.id("ebe_is_christmas"), EBEIsChristmasProperty.CODEC);
        WorldRenderEvents.END.register(SignRenderManager::endFrame);
        ClientTickEvents.END_WORLD_TICK.register((Object)WorldUtil.EVENT_LISTENER);
        ModelIdentifiers.init();
        EBESetup.setupResourceProviders();
        EnhancedBlockEntities.load();
    }

    public static void reload(ReloadType type) {
        EnhancedBlockEntities.load();
        if (type == ReloadType.WORLD) {
            class_310.method_1551().field_1769.method_3279();
        } else if (type == ReloadType.RESOURCES) {
            class_310.method_1551().method_1521();
        }
    }

    public static void load() {
        CONFIG.load();
        EnhancedBlockEntityRegistry.clear();
        ResourceUtil.resetBasePack();
        ResourceUtil.resetTopLevelPack();
        if (EnhancedBlockEntities.CONFIG.renderEnhancedChests) {
            EBESetup.setupChests();
            EBESetup.setupRRPChests();
        }
        if (EnhancedBlockEntities.CONFIG.renderEnhancedSigns) {
            EBESetup.setupSigns();
            EBESetup.setupRRPSigns();
        }
        if (EnhancedBlockEntities.CONFIG.renderEnhancedBells) {
            EBESetup.setupBells();
            EBESetup.setupRRPBells();
        }
        if (EnhancedBlockEntities.CONFIG.renderEnhancedBeds) {
            EBESetup.setupBeds();
            EBESetup.setupRRPBeds();
        }
        if (EnhancedBlockEntities.CONFIG.renderEnhancedShulkerBoxes) {
            EBESetup.setupShulkerBoxes();
            EBESetup.setupRRPShulkerBoxes();
        }
        if (EnhancedBlockEntities.CONFIG.renderEnhancedDecoratedPots) {
            EBESetup.setupDecoratedPots();
            EBESetup.setupRRPDecoratedPots();
        }
    }
}

