/*
 * Decompiled with CFR 0.152.
 */
package io.github.a5b84.helditeminfo.mixin;

import io.github.a5b84.helditeminfo.Appenders;
import io.github.a5b84.helditeminfo.ContainerContentAppender;
import io.github.a5b84.helditeminfo.HeldItemInfo;
import io.github.a5b84.helditeminfo.TooltipAppender;
import io.github.a5b84.helditeminfo.TooltipBuilder;
import io.github.a5b84.helditeminfo.TooltipLine;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
public abstract class InGameHudMixin {
    @Shadow
    @Final
    private class_310 field_2035;
    @Shadow
    private int field_2040;
    @Shadow
    private class_1799 field_2031;
    @Unique
    private List<TooltipLine> tooltip = Collections.emptyList();
    @Unique
    private int y;
    @Unique
    private class_1799 stackBeforeTick;
    @Unique
    private int maxWidth = -1;

    @Inject(method={"renderHeldItemTooltip"}, at={@At(value="INVOKE", target="net/minecraft/client/font/TextRenderer.getWidth(Lnet/minecraft/text/StringVisitable;)I")})
    public void onBeforeRenderHeldItemTooltip(class_332 context, CallbackInfo ci) {
        this.y = context.method_51443() - 50 - 9 - (int)(((float)HeldItemInfo.config.lineHeight() - HeldItemInfo.config.offsetPerExtraLine()) * (float)(this.tooltip.size() - 1)) - HeldItemInfo.config.verticalOffset();
        if (!this.field_2035.field_1761.method_2908()) {
            this.y += 14;
        }
        if (HeldItemInfo.config.showName() && this.tooltip.size() > 1) {
            this.y -= HeldItemInfo.config.itemNameSpacing();
        }
    }

    @Redirect(method={"renderHeldItemTooltip"}, at=@At(value="INVOKE", target="net/minecraft/client/gui/DrawContext.drawTextWithBackground(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;IIII)I"))
    private int drawTextProxy(class_332 context, class_327 textRenderer, class_2561 text, int _x, int _y, int width, int color) {
        int backgroundColor = this.field_2035.field_1690.method_19344(0);
        if ((backgroundColor & 0xFF000000) != 0) {
            if (this.maxWidth < 0) {
                for (TooltipLine line : this.tooltip) {
                    if (line.width <= this.maxWidth) continue;
                    this.maxWidth = line.width;
                }
            }
            int scaledWidth = context.method_51421();
            int height = HeldItemInfo.config.lineHeight() * this.tooltip.size();
            if (HeldItemInfo.config.showName() && this.tooltip.size() > 1) {
                height += HeldItemInfo.config.itemNameSpacing();
            }
            context.method_25294((scaledWidth - this.maxWidth) / 2 - 2, this.y - 2, (scaledWidth + this.maxWidth) / 2 + 2, this.y + height + 2, backgroundColor);
        }
        int lineHeight = HeldItemInfo.config.lineHeight();
        int i = 0;
        for (TooltipLine line : this.tooltip) {
            int x = (context.method_51421() - line.width) / 2;
            context.method_27535(textRenderer, line.text, x, this.y, color);
            this.y += lineHeight;
            if (i == 0 && HeldItemInfo.config.showName()) {
                this.y += HeldItemInfo.config.itemNameSpacing();
            }
            ++i;
        }
        return 0;
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    public void onBeforeTick(CallbackInfo ci) {
        this.stackBeforeTick = this.field_2031;
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    public void onAfterTick(CallbackInfo ci) {
        if (this.field_2035.field_1724 == null || this.field_2031 == this.stackBeforeTick) {
            return;
        }
        if (this.field_2031.method_7960()) {
            this.tooltip = Collections.emptyList();
        } else {
            List<class_2561> newInfo = this.buildTooltip(this.field_2031);
            if (!TooltipLine.areEquivalent(this.tooltip, newInfo)) {
                this.tooltip = TooltipLine.from(newInfo);
                this.maxWidth = -1;
                this.field_2040 = (int)(20.0f * (HeldItemInfo.config.baseFadeDuration() + HeldItemInfo.config.fadeDurationPerExtraLine() * (float)(this.tooltip.size() - 1)));
            }
        }
    }

    @Unique
    private List<class_2561> buildTooltip(class_1799 stack) {
        if (stack.method_7960()) {
            return Collections.emptyList();
        }
        class_1792.class_9635 tooltipContext = class_1792.class_9635.method_59528((class_1937)this.field_2035.field_1687);
        TooltipBuilder builder = new TooltipBuilder(stack, tooltipContext, HeldItemInfo.config.maxLines());
        if (HeldItemInfo.config.showName()) {
            class_5250 stackName = class_2561.method_43473().method_10852(stack.method_7964()).method_27692(stack.method_7932().method_58413());
            if (stack.method_57826(class_9334.field_49631)) {
                stackName.method_27692(class_124.field_1056);
            }
            builder.append((class_2561)stackName);
        }
        if (!HeldItemInfo.config.respectHideFlags() || !stack.method_57826(class_9334.field_50074)) {
            TooltipAppender appender;
            class_1747 blockItem;
            class_2248 class_22482;
            TooltipAppender appender2;
            class_1792 item = stack.method_7909();
            if (item instanceof TooltipAppender && (appender2 = (TooltipAppender)item).heldItemInfo_shouldAppendTooltip()) {
                appender2.heldItemInfo_appendTooltip(builder);
            }
            if (item instanceof class_1747 && (class_22482 = (blockItem = (class_1747)item).method_7711()) instanceof TooltipAppender && (appender = (TooltipAppender)class_22482).heldItemInfo_shouldAppendTooltip()) {
                appender.heldItemInfo_appendTooltip(builder);
            }
            if (HeldItemInfo.config.showMusicDiscDescription()) {
                Appenders.appendMusicDiscDescription(builder);
            }
            if (HeldItemInfo.config.showEnchantments()) {
                Appenders.appendEnchantments(builder);
            }
            if (HeldItemInfo.config.showContainerContent()) {
                ContainerContentAppender.appendContainerContent(builder);
            }
            if (HeldItemInfo.config.showLore()) {
                Appenders.appendLore(builder);
            }
            if (HeldItemInfo.config.showUnbreakable()) {
                Appenders.appendUnbreakable(builder);
            }
            if (HeldItemInfo.config.showPotionEffects()) {
                Appenders.appendOminousBottleAmplifier(builder);
            }
        }
        return builder.build();
    }
}

