/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1959;

public class ModConfig {
    public static final Path CONFIG_FILE = Path.of("config", new String[0]).resolve("particlerain.json");
    public static ModConfig CONFIG = new ModConfig();
    public static ModConfig DEFAULT = new ModConfig();
    public PerformanceOptions perf = new PerformanceOptions();
    public EffectOptions effect = new EffectOptions();
    public SoundOptions sound = new SoundOptions();
    public CompatibilityOptions compat = new CompatibilityOptions();
    public SpawnOptions spawn = new SpawnOptions();
    public RainOptions rain = new RainOptions();
    public SnowOptions snow = new SnowOptions();
    public DustOptions dust = new DustOptions();
    public ShrubOptions shrub = new ShrubOptions();
    public RippleOptions ripple = new RippleOptions();
    public FogOptions fog = new FogOptions();
    public GroundFogOptions groundFog = new GroundFogOptions();
    public PuddleOptions puddle = new PuddleOptions();
    static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void loadConfig() {
        File file = CONFIG_FILE.toFile();
        if (file.exists()) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                CONFIG = (ModConfig)GSON.fromJson((Reader)fileReader, ModConfig.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Particle Rain config failed to load: ", e);
            }
        }
        if (CONFIG == null) {
            CONFIG = new ModConfig();
        }
    }

    public static void saveConfig() {
        File file = CONFIG_FILE.toFile();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            GSON.toJson((Object)CONFIG, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class PerformanceOptions {
        public int maxParticleAmount = 1500;
        public int particleDensity = 100;
        public int particleStormDensity = 200;
        public int particleRadius = 25;
        public int fogParticleRadius = 90;
    }

    public static class EffectOptions {
        public boolean doRainParticles = true;
        public boolean doSplashParticles = true;
        public boolean doSmokeParticles = true;
        public boolean doRippleParticles = true;
        public boolean doStreakParticles = true;
        public boolean doSnowParticles = true;
        public boolean doDustParticles = true;
        public boolean doShrubParticles = true;
        public boolean doFogParticles = false;
        public boolean doGroundFogParticles = true;
        public boolean doPuddles = true;
    }

    public static class SoundOptions {
        public boolean doRainSounds = true;
        public boolean doSnowSounds = true;
        public boolean doSandSounds = true;
    }

    public static class CompatibilityOptions {
        public boolean renderVanillaWeather = false;
        public boolean tickVanillaWeather = false;
        public boolean alwaysRaining = false;
        @ReloadsResources
        public boolean biomeTint = true;
        @Percentage
        public float tintMix = 0.5f;
        public boolean yLevelWindAdjustment = true;
        public boolean syncRegistry = true;
    }

    public static class SpawnOptions {
        public boolean doOverrideWeather = false;
        public class_1959.class_1963 overrideWeather = class_1959.class_1963.field_9383;
        public boolean useHeightmapTemp = true;
        public boolean canSpawnAboveClouds = true;
        public int cloudHeight = 191;
        public transient URI openWiki = URI.create("https://minecraft.wiki/w/Block_tags_(Java_Edition)#camel_sand_step_sound_blocks");
        public List<String> dustyBlockTags = new ArrayList<String>(Collections.singleton("minecraft:camel_sand_step_sound_blocks"));
    }

    @OverrideName(newName="ParticleOptions")
    public static class RainOptions {
        @Percentage
        public float density = 1.0f;
        public float gravity = 1.0f;
        public float windStrength = 0.3f;
        public float stormWindStrength = 0.7f;
        @Percentage
        public float opacity = 1.0f;
        public float size = 2.0f;
        public int impactEffectAmount = 5;
    }

    @OverrideName(newName="ParticleOptions")
    public static class SnowOptions {
        @Percentage
        public float density = 0.4f;
        public float gravity = 0.05f;
        public float rotationAmount = 0.02f;
        public float stormRotationAmount = 0.05f;
        public float windStrength = 1.0f;
        public float stormWindStrength = 3.0f;
        public float size = 2.0f;
    }

    @OverrideName(newName="ParticleOptions")
    public static class DustOptions {
        @Percentage
        public float density = 0.8f;
        public float gravity = 0.2f;
        public float windStrength = 0.2f;
        public float stormWindStrength = 0.3f;
        public float size = 2.0f;
        public boolean spawnOnGround = true;
    }

    @OverrideName(newName="ParticleOptions")
    public static class ShrubOptions {
        @Percentage
        public float density = 0.02f;
        public float gravity = 0.2f;
        public float rotationAmount = 0.2f;
        public float windStrength = 0.2f;
        public float stormWindStrength = 0.3f;
        public float bounciness = 0.2f;
    }

    @OverrideName(newName="ParticleOptions")
    public static class RippleOptions {
        @ReloadsResources
        public int resolution = 16;
        @ReloadsResources
        public boolean useResourcepackResolution = true;
    }

    @OverrideName(newName="ParticleOptions")
    public static class FogOptions {
        @Percentage
        public float density = 0.2f;
        public float gravity = 0.2f;
        public float size = 0.5f;
    }

    @OverrideName(newName="ParticleOptions")
    public static class GroundFogOptions {
        public int density = 20;
        public int maxSpawnHeight = 64;
        public int minSpawnHeight = 60;
        public float size = 8.0f;
    }

    public static class PuddleOptions {
        public int updateDelay = 100;
        public int updateStep = 5;
        public int rainLevel = 90;
        public int stormLevel = 130;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ReloadsResources {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface OverrideName {
        public String newName();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Percentage {
    }
}

