/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.base;

import io.wispforest.owo.Owo;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.parsing.ConfigureHotReloadScreen;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIModelLoader;
import io.wispforest.owo.ui.util.UIErrorToast;
import java.nio.file.Path;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseUIModelScreen<R extends ParentComponent>
extends BaseOwoScreen<R> {
    protected final UIModel model;
    protected final Class<R> rootComponentClass;
    @Nullable
    protected final class_2960 modelId;

    protected BaseUIModelScreen(Class<R> rootComponentClass, DataSource source) {
        class_2960 class_29602;
        UIModel providedModel = source.get();
        if (providedModel == null) {
            source.reportError();
            this.invalid = true;
        }
        this.rootComponentClass = rootComponentClass;
        this.model = providedModel;
        if (source instanceof DataSource.AssetDataSource) {
            DataSource.AssetDataSource assetSource = (DataSource.AssetDataSource)source;
            class_29602 = assetSource.assetPath();
        } else {
            class_29602 = null;
        }
        this.modelId = class_29602;
    }

    protected BaseUIModelScreen(Class<R> rootComponentClass, class_2960 modelId) {
        this(rootComponentClass, DataSource.asset(modelId));
    }

    @Override
    @NotNull
    protected OwoUIAdapter<R> createAdapter() {
        return this.model.createAdapter(this.rootComponentClass, this);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (Owo.DEBUG && this.modelId != null && keyCode == 294 && (modifiers & 2) != 0) {
            this.field_22787.method_1507((class_437)new ConfigureHotReloadScreen(this.modelId, this));
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public static interface DataSource {
        @Nullable
        public UIModel get();

        public void reportError();

        @Deprecated
        public static DataSource file(final String filePath) {
            return new DataSource(){

                @Override
                @Nullable
                public UIModel get() {
                    if (!Owo.DEBUG) {
                        throw new IllegalStateException("Debug UI data source must not be used in production");
                    }
                    return UIModel.load(Path.of(filePath, new String[0]));
                }

                @Override
                public void reportError() {
                    UIErrorToast.report("Could not load UI model from file " + filePath);
                }
            };
        }

        public static DataSource asset(class_2960 assetPath) {
            return new AssetDataSource(assetPath);
        }

        public record AssetDataSource(class_2960 assetPath) implements DataSource
        {
            @Override
            @Nullable
            public UIModel get() {
                return UIModelLoader.get(this.assetPath);
            }

            @Override
            public void reportError() {
                UIErrorToast.report("No UI model with id " + String.valueOf(this.assetPath) + " was found");
            }
        }
    }
}

