/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.endec;

import com.mojang.datafixers.util.Either;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SelfDescribedDeserializer;
import io.wispforest.endec.SelfDescribedSerializer;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.StructEndec;

public final class StructEitherEndec<L, R>
implements StructEndec<Either<L, R>> {
    private final StructEndec<L> leftEndec;
    private final StructEndec<R> rightEndec;
    private final boolean exclusive;

    public StructEitherEndec(StructEndec<L> leftEndec, StructEndec<R> rightEndec, boolean exclusive) {
        this.leftEndec = leftEndec;
        this.rightEndec = rightEndec;
        this.exclusive = exclusive;
    }

    public void encodeStruct(SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, Either<L, R> either) {
        if (serializer instanceof SelfDescribedSerializer) {
            either.ifLeft(left -> this.leftEndec.encodeStruct(ctx, serializer, struct, left)).ifRight(right -> this.rightEndec.encodeStruct(ctx, serializer, struct, right));
        } else {
            struct.field("is_left", ctx, Endec.BOOLEAN, (Object)either.left().isPresent());
            either.ifLeft(left -> this.leftEndec.encodeStruct(ctx, serializer, struct, left)).ifRight(right -> this.rightEndec.encodeStruct(ctx, serializer, struct, right));
        }
    }

    public Either<L, R> decodeStruct(SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) {
        boolean selfDescribing = deserializer instanceof SelfDescribedDeserializer;
        if (selfDescribing) {
            Either leftResult = null;
            try {
                leftResult = Either.left((Object)deserializer.tryRead(deserializer1 -> this.leftEndec.decodeStruct(ctx, deserializer1, struct)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.exclusive && leftResult != null) {
                return leftResult;
            }
            Either rightResult = null;
            try {
                rightResult = Either.right((Object)deserializer.tryRead(deserializer1 -> this.rightEndec.decodeStruct(ctx, deserializer1, struct)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.exclusive && leftResult != null && rightResult != null) {
                throw new IllegalStateException("Both alternatives read successfully, can not pick the correct one; first: " + String.valueOf(leftResult) + " second: " + String.valueOf(rightResult));
            }
            if (leftResult != null) {
                return leftResult;
            }
            if (rightResult != null) {
                return rightResult;
            }
            throw new IllegalStateException("Neither alternative read successfully");
        }
        Boolean isLeft = (Boolean)struct.field("is_left", ctx, Endec.BOOLEAN);
        return isLeft != false ? Either.left((Object)this.leftEndec.decodeStruct(ctx, deserializer, struct)) : Either.right((Object)this.rightEndec.decodeStruct(ctx, deserializer, struct));
    }
}

