/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.util;

import dev.tr7zw.itemswapper.ItemSwapperSharedMod;
import dev.tr7zw.itemswapper.api.AvailableSlot;
import dev.tr7zw.itemswapper.api.client.ItemSwapperClientAPI;
import dev.tr7zw.itemswapper.api.client.NameProvider;
import dev.tr7zw.itemswapper.manager.ClientProviderManager;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemEntry;
import dev.tr7zw.itemswapper.util.InventoryUtil;
import dev.tr7zw.itemswapper.util.NMSHelper;
import dev.tr7zw.itemswapper.util.NetworkUtil;
import dev.tr7zw.itemswapper.util.ShulkerHelper;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public final class ItemUtil {
    private static final class_310 minecraft = class_310.method_1551();
    private static final ClientProviderManager providerManager = ItemSwapperSharedMod.instance.getClientProviderManager();
    private static final ItemSwapperClientAPI clientAPI = ItemSwapperClientAPI.getInstance();

    private ItemUtil() {
    }

    public static int inventorySlotToHudSlot(int slot) {
        if (slot < 9) {
            return 36 + slot;
        }
        return slot;
    }

    public static boolean inArray(class_1792[] items, class_1792 item) {
        for (class_1792 i : items) {
            if (i != item) continue;
            return true;
        }
        return false;
    }

    public static ItemEntry[] toDefault(class_1792[] items) {
        ItemEntry[] entries = new ItemEntry[items.length];
        for (int i = 0; i < items.length; ++i) {
            entries[i] = new ItemEntry(items[i], null);
        }
        return entries;
    }

    @NotNull
    public static class_1792[] itemstackToSingleItem(class_1792[] items) {
        int lastItem = 0;
        for (int x = 0; x < items.length; ++x) {
            if (items[x] == class_1802.field_8162) continue;
            lastItem = x;
        }
        items = Arrays.copyOf(items, lastItem + 1);
        return items;
    }

    public static class_2561 getDisplayname(class_1799 item) {
        if (NMSHelper.hasCustomName(item)) {
            return item.method_7964().method_27661();
        }
        NameProvider provider = ItemSwapperSharedMod.instance.getClientProviderManager().getNameProvider(item);
        if (provider != null) {
            return provider.getDisplayName(item).method_27661();
        }
        return item.method_7964().method_27661();
    }

    public static boolean grabItem(class_1792 item, boolean ignoreHotbar) {
        List<AvailableSlot> slots = providerManager.findSlotsMatchingItem(item, false, ignoreHotbar);
        for (AvailableSlot slot : slots) {
            ItemSwapperClientAPI.OnSwap event = ItemUtil.clientAPI.prepareItemSwapEvent.callEvent(new ItemSwapperClientAPI.OnSwap(slot, new AtomicBoolean()));
            if (event.canceled().get()) {
                return false;
            }
            if (slot.inventory() == -1) {
                int hudSlot = ItemUtil.inventorySlotToHudSlot(slot.slot());
                ItemUtil.minecraft.field_1761.method_2906(ItemUtil.minecraft.field_1724.field_7498.field_7763, hudSlot, InventoryUtil.getSelectedId(ItemUtil.minecraft.field_1724.method_31548()), class_1713.field_7791, (class_1657)ItemUtil.minecraft.field_1724);
            } else {
                if (ShulkerHelper.isShulker(InventoryUtil.getSelected(ItemUtil.minecraft.field_1724.method_31548()).method_7909())) continue;
                NetworkUtil.swapItem(slot.inventory(), slot.slot());
            }
            ItemUtil.clientAPI.itemSwapSentEvent.callEvent(new ItemSwapperClientAPI.SwapSent(slot));
            return true;
        }
        return false;
    }
}

