/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.modmenu.screen.yacl.simple;

import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.ValueFormatter;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.lopymine.patpat.modmenu.screen.yacl.simple.SimpleContent;
import net.lopymine.patpat.utils.ModMenuUtils;
import net.minecraft.class_2561;

public class SimpleOptionsCollector {
    private final String groupId;

    private SimpleOptionsCollector(String groupId) {
        this.groupId = groupId;
    }

    public static SimpleOptionsCollector createBuilder(String groupId) {
        return new SimpleOptionsCollector(groupId);
    }

    public Option<Boolean> getBooleanOption(String optionId, boolean defValue, Supplier<Boolean> getter, Consumer<Boolean> setter, ValueFormatter<Boolean> formatter, SimpleContent content) {
        return this.getOption(optionId, defValue, getter, setter, content).controller(o -> BooleanControllerBuilder.create((Option)o).coloured(true).formatValue(formatter)).build();
    }

    public Option<Float> getFloatOptionAsSlider(String optionId, float min, float max, float step, float defValue, Supplier<Float> getter, Consumer<Float> setter, SimpleContent content) {
        return this.getOption(optionId, Float.valueOf(defValue), getter, setter, content).controller(o -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)o).range((Number)Float.valueOf(min), (Number)Float.valueOf(max))).step((Number)Float.valueOf(step))).build();
    }

    public Option<Boolean> getBooleanOption(String optionId, boolean defValue, Supplier<Boolean> getter, Consumer<Boolean> setter, ValueFormatter<Boolean> formatter) {
        return this.getOption(optionId, defValue, getter, setter, SimpleContent.NONE).controller(o -> BooleanControllerBuilder.create((Option)o).coloured(true).formatValue(formatter)).build();
    }

    public Option<Float> getFloatOptionAsSlider(String optionId, float min, float max, float step, float defValue, Supplier<Float> getter, Consumer<Float> setter) {
        return this.getOption(optionId, Float.valueOf(defValue), getter, setter, SimpleContent.NONE).controller(o -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)o).range((Number)Float.valueOf(min), (Number)Float.valueOf(max))).step((Number)Float.valueOf(step))).build();
    }

    private <C> Option.Builder<C> getOption(String optionId, C defValue, Supplier<C> getter, Consumer<C> setter, SimpleContent content) {
        String optionKey = ModMenuUtils.getOptionKey(this.groupId, optionId);
        String optionDescription = ModMenuUtils.getDescriptionKey(optionKey);
        OptionDescription.Builder descriptionBuilder = OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)optionDescription)});
        if (content == SimpleContent.IMAGE) {
            descriptionBuilder.image(ModMenuUtils.getContentId(content, optionId), 400, 400);
        }
        if (content == SimpleContent.WEBP) {
            descriptionBuilder.webpImage(ModMenuUtils.getContentId(content, optionId));
        }
        return Option.createBuilder().name((class_2561)class_2561.method_43471((String)optionKey)).description(descriptionBuilder.build()).binding(defValue, getter, setter);
    }

    public Option<?>[] collect(Option<?> ... options) {
        return options;
    }

    public <T> Option<T> getIf(Option<T> option, BooleanSupplier condition) {
        if (condition.getAsBoolean()) {
            return option;
        }
        return null;
    }
}

