/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.modmenu.screen.clothconfig;

import java.util.function.Function;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.SubCategoryListEntry;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.config.client.PatPatClientConfig;
import net.lopymine.patpat.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_437;

public class ClothConfigConfigurationScreen {
    public static final Function<Boolean, class_2561> ENABLED_OR_DISABLE_FORMATTER = state -> TextUtils.text("modmenu.formatter.enable_or_disable." + state, new Object[0]).method_10862(class_2583.field_24360.method_27706(Boolean.TRUE.equals(state) ? class_124.field_1060 : class_124.field_1061));

    private ClothConfigConfigurationScreen() {
        throw new IllegalStateException("Screen class");
    }

    public static class_437 createScreen(class_437 parent) {
        PatPatClientConfig config = PatPatClient.getConfig();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)TextUtils.text("modmenu.title", new Object[0]));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory general = builder.getOrCreateCategory((class_2561)TextUtils.text("modmenu.title", new Object[0]));
        general.addEntry((AbstractConfigListEntry)ClothConfigConfigurationScreen.getMainGroup(entryBuilder, config));
        general.addEntry((AbstractConfigListEntry)ClothConfigConfigurationScreen.getResourcePackGroup(entryBuilder, config));
        general.addEntry((AbstractConfigListEntry)ClothConfigConfigurationScreen.getSoundGroup(entryBuilder, config));
        general.addEntry((AbstractConfigListEntry)ClothConfigConfigurationScreen.getVisualGroup(entryBuilder, config));
        general.addEntry((AbstractConfigListEntry)ClothConfigConfigurationScreen.getServerGroup(entryBuilder, config));
        builder.setSavingRunnable(config::save);
        return builder.build();
    }

    private static SubCategoryListEntry getMainGroup(ConfigEntryBuilder entryBuilder, PatPatClientConfig config) {
        SubCategoryBuilder subcategory = entryBuilder.startSubCategory((class_2561)TextUtils.text("modmenu.main", new Object[0]));
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)TextUtils.text("modmenu.main.option.enable_mod", new Object[0]), config.isModEnabled()).setTooltip(new class_2561[]{TextUtils.text("modmenu.main.option.enable_mod.description", new Object[0])}).setYesNoTextSupplier(ENABLED_OR_DISABLE_FORMATTER).setDefaultValue(PatPatClientConfig.DEFAULT.isModEnabled()).setSaveConsumer(config::setModEnabled).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)TextUtils.text("modmenu.main.option.debug_log_enabled", new Object[0]), config.isDebugLogEnabled()).setTooltip(new class_2561[]{TextUtils.text("modmenu.main.option.debug_log_enabled.description", new Object[0])}).setYesNoTextSupplier(ENABLED_OR_DISABLE_FORMATTER).setDefaultValue(PatPatClientConfig.DEFAULT.isDebugLogEnabled()).setSaveConsumer(config::setDebugLogEnabled).build());
        subcategory.setExpanded(true);
        return subcategory.build();
    }

    private static SubCategoryListEntry getResourcePackGroup(ConfigEntryBuilder entryBuilder, PatPatClientConfig config) {
        SubCategoryBuilder subcategory = entryBuilder.startSubCategory((class_2561)TextUtils.text("modmenu.resource_packs", new Object[0]));
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)TextUtils.text("modmenu.resource_packs.option.skip_outdated_animations_enabled", new Object[0]), config.isSkipOldAnimationsEnabled()).setTooltip(new class_2561[]{TextUtils.text("modmenu.resource_packs.option.skip_outdated_animations_enabled.description", new Object[0])}).setYesNoTextSupplier(ENABLED_OR_DISABLE_FORMATTER).setDefaultValue(PatPatClientConfig.DEFAULT.isSkipOldAnimationsEnabled()).setSaveConsumer(config::setSkipOldAnimationsEnabled).build());
        subcategory.setExpanded(true);
        return subcategory.build();
    }

    private static SubCategoryListEntry getSoundGroup(ConfigEntryBuilder entryBuilder, PatPatClientConfig config) {
        SubCategoryBuilder subcategory = entryBuilder.startSubCategory((class_2561)TextUtils.text("modmenu.sound", new Object[0]));
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)TextUtils.text("modmenu.sound.option.enable_sounds", new Object[0]), config.isSoundsEnabled()).setTooltip(new class_2561[]{TextUtils.text("modmenu.sound.option.enable_sounds.description", new Object[0])}).setYesNoTextSupplier(ENABLED_OR_DISABLE_FORMATTER).setDefaultValue(PatPatClientConfig.DEFAULT.isSoundsEnabled()).setSaveConsumer(config::setSoundsEnabled).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)TextUtils.text("modmenu.sound.option.sounds_volume", new Object[0]), config.getSoundsVolume()).setTooltip(new class_2561[]{TextUtils.text("modmenu.sound.option.sounds_volume.description", new Object[0])}).setDefaultValue(PatPatClientConfig.DEFAULT.getSoundsVolume()).setMin(0.0f).setMax(1.0f).setSaveConsumer(value -> config.setSoundsVolume((float)Math.round(value.floatValue() * 100.0f) / 100.0f)).build());
        subcategory.setExpanded(true);
        return subcategory.build();
    }

    private static SubCategoryListEntry getVisualGroup(ConfigEntryBuilder entryBuilder, PatPatClientConfig config) {
        SubCategoryBuilder subcategory = entryBuilder.startSubCategory((class_2561)TextUtils.text("modmenu.visual", new Object[0]));
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)TextUtils.text("modmenu.visual.option.hiding_nickname_enabled", new Object[0]), config.isNicknameHidingEnabled()).setTooltip(new class_2561[]{TextUtils.text("modmenu.visual.option.hiding_nickname_enabled.description", new Object[0])}).setYesNoTextSupplier(ENABLED_OR_DISABLE_FORMATTER).setDefaultValue(PatPatClientConfig.DEFAULT.isNicknameHidingEnabled()).setSaveConsumer(config::setNicknameHidingEnabled).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)TextUtils.text("modmenu.visual.option.swing_hand_enabled", new Object[0]), config.isSwingHandEnabled()).setTooltip(new class_2561[]{TextUtils.text("modmenu.visual.option.swing_hand_enabled.description", new Object[0])}).setYesNoTextSupplier(ENABLED_OR_DISABLE_FORMATTER).setDefaultValue(PatPatClientConfig.DEFAULT.isSwingHandEnabled()).setSaveConsumer(config::setSwingHandEnabled).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)TextUtils.text("modmenu.visual.option.hand_offset_x", new Object[0]), config.getAnimationOffsetX()).setTooltip(new class_2561[]{TextUtils.text("modmenu.visual.option.hand_offset_x.description", new Object[0])}).setDefaultValue(PatPatClientConfig.DEFAULT.getAnimationOffsetX()).setMin(-5.0f).setMax(5.0f).setSaveConsumer(value -> config.setAnimationOffsetX((float)Math.round(value.floatValue() * 100.0f) / 100.0f)).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)TextUtils.text("modmenu.visual.option.hand_offset_y", new Object[0]), config.getAnimationOffsetY()).setTooltip(new class_2561[]{TextUtils.text("modmenu.visual.option.hand_offset_y.description", new Object[0])}).setDefaultValue(PatPatClientConfig.DEFAULT.getAnimationOffsetY()).setMin(-5.0f).setMax(5.0f).setSaveConsumer(value -> config.setAnimationOffsetY((float)Math.round(value.floatValue() * 100.0f) / 100.0f)).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)TextUtils.text("modmenu.visual.option.hand_offset_z", new Object[0]), config.getAnimationOffsetZ()).setTooltip(new class_2561[]{TextUtils.text("modmenu.visual.option.hand_offset_z.description", new Object[0])}).setDefaultValue(PatPatClientConfig.DEFAULT.getAnimationOffsetZ()).setMin(-5.0f).setMax(5.0f).setSaveConsumer(value -> config.setAnimationOffsetZ((float)Math.round(value.floatValue() * 100.0f) / 100.0f)).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)TextUtils.text("modmenu.visual.option.camera_shacking", new Object[0]), config.isCameraShackingEnabled()).setTooltip(new class_2561[]{TextUtils.text("modmenu.visual.option.camera_shacking.description", new Object[0])}).setYesNoTextSupplier(ENABLED_OR_DISABLE_FORMATTER).setDefaultValue(PatPatClientConfig.DEFAULT.isCameraShackingEnabled()).setSaveConsumer(config::setCameraShackingEnabled).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)TextUtils.text("modmenu.visual.option.pat_weight", new Object[0]), config.getPatWeight()).setTooltip(new class_2561[]{TextUtils.text("modmenu.visual.option.pat_weight.description", new Object[0])}).setDefaultValue(PatPatClientConfig.DEFAULT.getPatWeight()).setMin(0.0f).setMax(1.0f).setSaveConsumer(value -> config.setPatWeight((float)Math.round(value.floatValue() * 100.0f) / 100.0f)).build());
        subcategory.setExpanded(true);
        return subcategory.build();
    }

    private static SubCategoryListEntry getServerGroup(ConfigEntryBuilder entryBuilder, PatPatClientConfig config) {
        SubCategoryBuilder subcategory = entryBuilder.startSubCategory((class_2561)TextUtils.text("modmenu.server", new Object[0]));
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)TextUtils.text("modmenu.server.option.pat_me_enabled", new Object[0]), config.isPatMeEnabled()).setTooltip(new class_2561[]{TextUtils.text("modmenu.server.option.pat_me_enabled.description", new Object[0])}).setYesNoTextSupplier(ENABLED_OR_DISABLE_FORMATTER).setDefaultValue(PatPatClientConfig.DEFAULT.isPatMeEnabled()).setSaveConsumer(config::setPatMeEnabled).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)TextUtils.text("modmenu.server.option.bypass_server_resource_pack_priority_enabled", new Object[0]), config.isBypassServerResourcePackEnabled()).setTooltip(new class_2561[]{TextUtils.text("modmenu.server.option.bypass_server_resource_pack_priority_enabled.description", new Object[0])}).setYesNoTextSupplier(ENABLED_OR_DISABLE_FORMATTER).setDefaultValue(PatPatClientConfig.DEFAULT.isBypassServerResourcePackEnabled()).setSaveConsumer(config::setBypassServerResourcePackEnabled).build());
        subcategory.setExpanded(true);
        return subcategory.build();
    }
}

