/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.config.client.PatPatClientConfig;
import net.lopymine.patpat.config.resourcepack.CustomAnimationSettingsConfig;
import net.lopymine.patpat.config.resourcepack.FrameConfig;
import net.lopymine.patpat.entity.PatEntity;
import net.lopymine.patpat.manager.client.PatPatClientManager;
import net.lopymine.patpat.utils.mixin.EntityRenderStateWithParent;
import net.minecraft.class_10017;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_9064;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_897.class})
public class EntityRendererMixin {
    @Shadow
    @Final
    protected class_898 field_4676;

    @Inject(at={@At(value="HEAD", target="Lnet/minecraft/client/render/entity/EntityRenderer;renderLabelIfPresent(Lnet/minecraft/client/render/entity/state/EntityRenderState;Lnet/minecraft/text/Text;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V")}, method={"render"}, cancellable=true)
    private void render(class_10017 state, class_4587 matrices, class_4597 provider, int light, CallbackInfo ci) {
        PatPatClientConfig config = PatPatClient.getConfig();
        if (!config.isModEnabled()) {
            return;
        }
        EntityRenderStateWithParent stateWithParent = (EntityRenderStateWithParent)state;
        class_1297 entity = stateWithParent.patPat$getEntity();
        float tickDelta = stateWithParent.patPat$getTickDelta();
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)entity;
        PatEntity patEntity = PatPatClientManager.getPatEntity(livingEntity);
        if (patEntity == null) {
            return;
        }
        class_243 vec3d = entity.method_56072().method_55675(class_9064.field_47745, 0, entity.method_5705(tickDelta));
        float nameLabelHeight = vec3d != null ? (float)vec3d.field_1351 + 0.5f : 0.0f;
        boolean numberToMirrorTexture = true;
        CustomAnimationSettingsConfig animation = patEntity.getAnimation();
        FrameConfig frameConfig = animation.getFrameConfig();
        RenderSystem.enableBlend();
        matrices.method_22903();
        matrices.method_46416(0.0f, nameLabelHeight - 0.55f - frameConfig.offsetY() - config.getAnimationOffsetY(), 0.0f);
        matrices.method_22907(this.field_4676.method_24197());
        matrices.method_22905(0.85f * (float)numberToMirrorTexture, -0.85f, 0.85f);
        int frameWidth = animation.getTextureWidth() / frameConfig.totalFrames();
        int frameHeight = animation.getTextureHeight();
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        if (frameHeight > frameWidth) {
            scaleX = (float)frameWidth / (float)frameHeight;
        } else if (frameHeight < frameWidth) {
            scaleY = (float)frameHeight / (float)frameWidth;
        }
        float x1 = -((scaleX *= frameConfig.scaleX()) / 2.0f) + frameConfig.offsetX() + config.getAnimationOffsetX();
        float x2 = x1 + scaleX;
        float y1 = -((scaleY *= frameConfig.scaleY()) / 2.0f);
        float y2 = y1 + scaleY;
        float z = -(frameConfig.offsetZ() + config.getAnimationOffsetZ());
        float framePercent = 1.0f / (float)frameConfig.totalFrames();
        float u1 = (float)patEntity.getCurrentFrame() * framePercent;
        float u2 = u1 + framePercent;
        float v1 = 0.0f;
        float v2 = 1.0f;
        class_4587.class_4665 peek = matrices.method_23760();
        Matrix4f matrix4f = peek.method_23761();
        class_4588 buffer = provider.getBuffer(class_1921.method_23580((class_2960)animation.getTexture()));
        buffer.method_22918(matrix4f, x1, y1, z).method_1336(255, 255, 255, 255).method_22913(u1, v1).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        buffer.method_22918(matrix4f, x1, y2, z).method_1336(255, 255, 255, 255).method_22913(u1, v2).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        buffer.method_22918(matrix4f, x2, y2, z).method_1336(255, 255, 255, 255).method_22913(u2, v2).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        buffer.method_22918(matrix4f, x2, y1, z).method_1336(255, 255, 255, 255).method_22913(u2, v1).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        matrices.method_22909();
        RenderSystem.disableBlend();
        if (config.isNicknameHidingEnabled()) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getAndUpdateRenderState"})
    private void getAndUpdateRenderState(class_1297 entity, float tickDelta, CallbackInfoReturnable<class_10017> cir) {
        ((EntityRenderStateWithParent)cir.getReturnValue()).patPat$setTickDelta(tickDelta);
        ((EntityRenderStateWithParent)cir.getReturnValue()).patPat$setEntity(entity);
    }
}

