/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.manager.server;

import com.mojang.authlib.GameProfile;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.lopymine.patpat.PatPat;
import net.lopymine.patpat.config.resourcepack.ListMode;
import net.lopymine.patpat.config.server.PatPatServerConfig;
import net.lopymine.patpat.packet.PatEntityC2SPacket;
import net.lopymine.patpat.packet.PatEntityForReplayModS2CPacket;
import net.lopymine.patpat.packet.PatEntityS2CPacket;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1923;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class PatPatServerPacketManager {
    private PatPatServerPacketManager() {
        throw new IllegalStateException("Manager class");
    }

    public static void register() {
        PayloadTypeRegistry.playC2S().register(PatEntityC2SPacket.TYPE, PatEntityC2SPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(PatEntityS2CPacket.TYPE, PatEntityS2CPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(PatEntityForReplayModS2CPacket.TYPE, PatEntityForReplayModS2CPacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(PatEntityC2SPacket.TYPE, (packet, context) -> {
            class_3222 sender = context.player();
            PatPatServerConfig config = PatPat.getConfig();
            GameProfile senderProfile = sender.method_7334();
            if (config.getListMode() == ListMode.WHITELIST && !config.getList().containsKey(senderProfile.getId()) || config.getListMode() == ListMode.BLACKLIST && config.getList().containsKey(senderProfile.getId())) {
                return;
            }
            class_3218 serverWorld = (class_3218)sender.method_37908();
            class_1297 entity = serverWorld.method_14190(packet.getPattedEntityUuid());
            if (!(entity instanceof class_1309)) {
                return;
            }
            if (entity.method_5767()) {
                PatPat.LOGGER.warn("Received packet from client, {} patted {}, but patted entity is invisible! This shouldn't happens because it should checks at client-side!", sender.method_5477(), entity.method_5477());
                return;
            }
            class_1923 chunkPos = entity.method_31476();
            for (class_3222 player : PlayerLookup.tracking((class_3218)serverWorld, (class_1923)chunkPos)) {
                if (player.equals((Object)sender)) continue;
                ServerPlayNetworking.send((class_3222)player, (class_8710)new PatEntityS2CPacket(packet.getPattedEntityUuid(), senderProfile.getId()));
            }
        });
    }
}

