/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.manager.client;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.config.resourcepack.CustomAnimationSettingsConfig;
import net.lopymine.patpat.config.resourcepack.PlayerConfig;
import net.lopymine.patpat.entity.PatEntity;
import net.minecraft.class_1309;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatPatClientManager {
    private static final Map<UUID, PatEntity> PAT_ENTITIES = new HashMap<UUID, PatEntity>();

    private PatPatClientManager() {
        throw new IllegalStateException("Manager class");
    }

    @Nullable
    public static PatEntity getPatEntity(@NotNull class_1309 entity) {
        return PAT_ENTITIES.get(entity.method_5667());
    }

    public static void tickEntities() {
        PAT_ENTITIES.forEach((uuid, patEntity) -> patEntity.tick());
    }

    public static void removePatEntity(@NotNull class_1309 entity) {
        PAT_ENTITIES.remove(entity.method_5667());
    }

    public static void removePatEntity(@NotNull PatEntity patEntity) {
        class_1309 entity = patEntity.getEntity();
        if (entity != null) {
            PatPatClientManager.removePatEntity(entity);
        }
    }

    public static PatEntity pat(@NotNull class_1309 entity, @NotNull PlayerConfig whoPatted) {
        PatPatClient.LOGGER.debug("{} patted {}", whoPatted.getName(), entity.method_5477());
        UUID uuid = entity.method_5667();
        PatEntity patEntity = PAT_ENTITIES.get(uuid);
        if (patEntity == null) {
            patEntity = new PatEntity(entity, whoPatted);
            PAT_ENTITIES.put(uuid, patEntity);
        } else {
            patEntity.resetAnimation();
        }
        return patEntity;
    }

    public static boolean expired(PatEntity patEntity, float tickDelta) {
        CustomAnimationSettingsConfig animationConfig = patEntity.getAnimation();
        int duration = animationConfig.getDuration();
        return patEntity.getProgress(tickDelta) > (float)duration;
    }

    public static float getAnimationProgress(PatEntity patEntity, float tickDelta) {
        CustomAnimationSettingsConfig animationConfig = patEntity.getAnimation();
        int duration = animationConfig.getDuration();
        float animationProgress = patEntity.getProgress(tickDelta) / (float)duration;
        animationProgress = (float)(1.0 - Math.pow(1.0f - animationProgress, 2.0));
        int totalFrames = animationConfig.getFrameConfig().totalFrames();
        int frame = class_3532.method_15340((int)((int)Math.floor((float)totalFrames * animationProgress)), (int)0, (int)(totalFrames - 1));
        patEntity.setCurrentFrame(frame);
        float range = PatPatClient.getConfig().getPatWeight() / patEntity.getEntity().method_17682();
        return (float)((double)(1.0f - range) + (double)range * (1.0 - Math.sin((double)animationProgress * Math.PI)));
    }

    public static void reloadPatEntities() {
        PAT_ENTITIES.clear();
    }
}

