/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.config.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.lopymine.patpat.PatPat;
import net.lopymine.patpat.config.resourcepack.ListMode;
import net.lopymine.patpat.manager.PatPatConfigManager;
import net.lopymine.patpat.utils.VersionedThings;
import org.jetbrains.annotations.NotNull;

public class PatPatServerConfig {
    public static final Codec<PatPatServerConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ListMode.CODEC.fieldOf("listMode").forGetter(PatPatServerConfig::getListMode), (App)Codec.unboundedMap(VersionedThings.UUID_CODEC, (Codec)Codec.STRING).fieldOf("list").forGetter(PatPatServerConfig::getList)).apply((Applicative)instance, PatPatServerConfig::new));
    private static final File CONFIG_FILE = PatPatConfigManager.CONFIG_PATH.resolve("patpat.json5").toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<UUID, String> list;
    private ListMode listMode;

    private PatPatServerConfig() {
        this.listMode = ListMode.DISABLED;
        this.list = new HashMap<UUID, String>();
    }

    public PatPatServerConfig(ListMode listMode, Map<UUID, String> list) {
        this.listMode = listMode;
        this.list = new HashMap<UUID, String>(list);
    }

    public static PatPatServerConfig getInstance() {
        return PatPatServerConfig.read();
    }

    @NotNull
    private static PatPatServerConfig create() {
        PatPatServerConfig config = new PatPatServerConfig();
        try (FileWriter writer = new FileWriter(CONFIG_FILE, StandardCharsets.UTF_8);){
            String json = GSON.toJson((JsonElement)CODEC.encode((Object)config, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).getOrThrow());
            writer.write(json);
        }
        catch (Exception e) {
            PatPat.LOGGER.error("Failed to create config", e);
        }
        return config;
    }

    private static PatPatServerConfig read() {
        PatPatServerConfig patPatServerConfig;
        if (!CONFIG_FILE.exists()) {
            return PatPatServerConfig.create();
        }
        FileReader reader = new FileReader(CONFIG_FILE, StandardCharsets.UTF_8);
        try {
            patPatServerConfig = (PatPatServerConfig)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).getOrThrow()).getFirst();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                PatPat.LOGGER.error("Failed to read config", e);
                return PatPatServerConfig.create();
            }
        }
        reader.close();
        return patPatServerConfig;
    }

    public void save() {
        CompletableFuture.runAsync(() -> {
            try (FileWriter writer = new FileWriter(CONFIG_FILE, StandardCharsets.UTF_8);){
                String json = GSON.toJson((JsonElement)CODEC.encode((Object)this, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).getOrThrow());
                writer.write(json);
            }
            catch (Exception e) {
                PatPat.LOGGER.error("Failed to save config", e);
            }
        });
    }

    public Map<UUID, String> getList() {
        return this.list;
    }

    public ListMode getListMode() {
        return this.listMode;
    }

    public void setListMode(ListMode listMode) {
        this.listMode = listMode;
    }
}

