/*
 * Decompiled with CFR 0.152.
 */
package com.chailotl.particular;

import com.chailotl.particular.Particles;
import com.chailotl.particular.ParticularConfig;
import com.chailotl.particular.compat.RegionsUnexplored;
import com.chailotl.particular.compat.Traverse;
import com.chailotl.particular.compat.WilderWild;
import com.chailotl.particular.mixin.AccessorBiome;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5819;
import net.minecraft.class_703;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
implements ClientModInitializer {
    public static final String MOD_ID = "particular";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"particular");
    public static final ParticularConfig CONFIG = ParticularConfig.createAndLoad();
    public static class_2960 currentDimension;
    public static ConcurrentHashMap<class_2338, Integer> cascades;
    private static float fireflyFrequency;
    private static Map<class_2248, LeafData> leavesData;

    public void onInitializeClient() {
        LOGGER.info("I am quite particular about the effects I choose to add :3");
        leavesData.put(class_2246.field_10503, new LeafData((class_2394)Particles.OAK_LEAF));
        leavesData.put(class_2246.field_10539, new LeafData((class_2394)Particles.BIRCH_LEAF, new Color(-8345771)));
        leavesData.put(class_2246.field_9988, new LeafData((class_2394)Particles.SPRUCE_LEAF, new Color(-10380959)));
        leavesData.put(class_2246.field_10335, new LeafData((class_2394)Particles.JUNGLE_LEAF));
        leavesData.put(class_2246.field_10098, new LeafData((class_2394)Particles.ACACIA_LEAF));
        leavesData.put(class_2246.field_10035, new LeafData((class_2394)Particles.DARK_OAK_LEAF));
        leavesData.put(class_2246.field_28673, new LeafData((class_2394)Particles.AZALEA_LEAF, Color.white));
        leavesData.put(class_2246.field_28674, new LeafData((class_2394)Particles.AZALEA_LEAF, Color.white));
        leavesData.put(class_2246.field_37551, new LeafData((class_2394)Particles.MANGROVE_LEAF));
        leavesData.put(class_2246.field_42731, new LeafData(null));
        leavesData.put(class_2246.field_54714, new LeafData(null));
        Particles.register();
        if (FabricLoader.getInstance().isModLoaded("traverse")) {
            Traverse.addLeaves();
        }
        if (FabricLoader.getInstance().isModLoaded("regions_unexplored")) {
            RegionsUnexplored.addLeaves();
        }
        if (FabricLoader.getInstance().isModLoaded("wilderwild")) {
            WilderWild.addLeaves();
        }
        ClientChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            if (!CONFIG.cascades()) {
                return;
            }
            class_2960 newDimension = world.method_8597().comp_655();
            if (newDimension != currentDimension) {
                currentDimension = newDimension;
                cascades.clear();
            }
            chunk.method_51525(state -> state.method_26227().method_39360((class_3611)class_3612.field_15910), (pos, state) -> Main.updateCascade((class_1937)world, pos, state.method_26227()));
        });
        ClientChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> {
            if (!CONFIG.cascades()) {
                return;
            }
            cascades.forEach((pos, strength) -> {
                if (world.method_22350(pos).method_12004().equals((Object)chunk.method_12004())) {
                    cascades.remove(pos);
                }
            });
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> cascades.clear());
        ClientTickEvents.START_WORLD_TICK.register(world -> {
            class_5819 random = world.field_9229;
            if (world.method_8532() == (long)Main.CONFIG.fireflySettings.startTime()) {
                fireflyFrequency = Main.CONFIG.fireflySettings.dailyRandom().get(random.method_43048(Main.CONFIG.fireflySettings.dailyRandom().size())).floatValue();
            }
            if (!CONFIG.cascades()) {
                return;
            }
            cascades.forEach((pos, strength) -> {
                float height = world.method_8316(pos.method_10084()).method_20785();
                double x = pos.method_10263();
                double y = (double)pos.method_10264() + random.method_43058() * (double)height + 1.0;
                double z = pos.method_10260();
                if (random.method_43056()) {
                    x += random.method_43058();
                    z += (double)random.method_39332(0, 1);
                } else {
                    x += (double)random.method_39332(0, 1);
                    z += random.method_43058();
                }
                class_703 cascade = class_310.method_1551().field_1713.method_3056((class_2394)Particles.CASCADE, x, y, z, 0.0, 0.0, 0.0);
                if (cascade != null) {
                    float size = (float)strength.intValue() / 4.0f * height;
                    cascade.method_3087(1.0f - (1.0f - size) / 2.0f);
                }
            });
        });
    }

    public static void registerLeafData(class_2248 block, LeafData leafData) {
        leavesData.put(block, leafData);
    }

    public static void registerLeafData(class_2960 id, LeafData leafData) {
        class_7923.field_41175.method_17966(id).ifPresent(block -> leavesData.put((class_2248)block, leafData));
    }

    public static LeafData getLeafData(class_2248 block) {
        return leavesData.getOrDefault(block, new LeafData((class_2394)Particles.OAK_LEAF));
    }

    public static void updateCascade(class_1937 world, class_2338 pos, class_3610 state) {
        if (state.method_39360((class_3611)class_3612.field_15910) && world.method_8316(pos.method_10084()).method_39360((class_3611)class_3612.field_15909) && world.method_8316(pos.method_10074()).method_39360((class_3611)class_3612.field_15910)) {
            int strength = 0;
            if (world.method_8316(pos.method_10095()).method_39360((class_3611)class_3612.field_15910)) {
                ++strength;
            }
            if (world.method_8316(pos.method_10078()).method_39360((class_3611)class_3612.field_15910)) {
                ++strength;
            }
            if (world.method_8316(pos.method_10072()).method_39360((class_3611)class_3612.field_15910)) {
                ++strength;
            }
            if (world.method_8316(pos.method_10067()).method_39360((class_3611)class_3612.field_15910)) {
                ++strength;
            }
            if (strength > 0) {
                if (!(world.method_8320(pos.method_10084().method_10095()).method_26215() || world.method_8320(pos.method_10084().method_10078()).method_26215() || world.method_8320(pos.method_10084().method_10072()).method_26215() || world.method_8320(pos.method_10084().method_10067()).method_26215())) {
                    return;
                }
                if (cascades.contains(pos = new class_2338(pos.method_10263(), pos.method_10264(), pos.method_10260()))) {
                    cascades.replace(pos, strength);
                } else {
                    cascades.put(pos, strength);
                }
            } else {
                cascades.remove(pos);
            }
        } else {
            cascades.remove(pos);
        }
    }

    public static void spawnBubble(class_2394 particle, class_1937 world, class_2338 pos) {
        double x = (double)pos.method_10263() + 0.25 + world.field_9229.method_43058() * 0.5;
        double y = (double)pos.method_10264() + 0.25 + world.field_9229.method_43058() * 0.5;
        double z = (double)pos.method_10260() + 0.25 + world.field_9229.method_43058() * 0.5;
        world.method_8406(particle, x, y, z, 0.0, 0.0, 0.0);
    }

    public static void spawnFirefly(class_1937 world, class_2338 pos, class_5819 random) {
        if (random.method_43058() > (double)fireflyFrequency) {
            return;
        }
        class_1959 biome = (class_1959)world.method_23753(pos).comp_349();
        float downfall = ((AccessorBiome)biome).getWeather().comp_846();
        if ((!world.method_8419() || Main.CONFIG.fireflySettings.canSpawnInRain()) && random.method_43048(30 - (int)(10.0f * downfall)) == 0) {
            long time = world.method_8532();
            float temp = biome.method_8712();
            if (time >= (long)Main.CONFIG.fireflySettings.startTime() && time <= (long)Main.CONFIG.fireflySettings.endTime() && temp >= Main.CONFIG.fireflySettings.minTemp() && temp <= Main.CONFIG.fireflySettings.maxTemp()) {
                world.method_8406((class_2394)Particles.FIREFLY, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f), 0.0, 0.0, 0.0);
            }
        }
    }

    public static void spawnDoubleBubbles(class_2394 particle, class_1937 world, class_2338 pos, class_2680 state) {
        class_2745 chestType = (class_2745)state.method_11654((class_2769)class_2741.field_12506);
        boolean xLen = false;
        boolean zLen = false;
        int xOffset = 0;
        int zOffset = 0;
        switch ((class_2350)state.method_11654((class_2769)class_2741.field_12481)) {
            case field_11043: {
                xLen = true;
                if (chestType != class_2745.field_12571) break;
                xOffset = -1;
                break;
            }
            case field_11035: {
                xLen = true;
                if (chestType != class_2745.field_12574) break;
                xOffset = -1;
                break;
            }
            case field_11034: {
                zLen = true;
                if (chestType != class_2745.field_12571) break;
                zOffset = -1;
                break;
            }
            case field_11039: {
                zLen = true;
                if (chestType != class_2745.field_12574) break;
                zOffset = -1;
            }
        }
        for (int i = 0; i < 2; ++i) {
            double x = (double)pos.method_10263() + 0.25 + world.field_9229.method_43058() * (0.5 + (double)xLen) + (double)xOffset;
            double y = (double)pos.method_10264() + 0.25 + world.field_9229.method_43058() * 0.5;
            double z = (double)pos.method_10260() + 0.25 + world.field_9229.method_43058() * (0.5 + (double)zLen) + (double)zOffset;
            world.method_8406(particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnChestBubbles(class_2394 particle, class_1937 world, class_2338 pos) {
        for (int i = 0; i < 10; ++i) {
            Main.spawnBubble(particle, world, pos);
        }
    }

    public static void spawnDoubleChestBubbles(class_2394 particle, class_1937 world, class_2338 pos, class_2680 state) {
        class_2745 chestType = (class_2745)state.method_11654((class_2769)class_2741.field_12506);
        boolean xLen = false;
        boolean zLen = false;
        int xOffset = 0;
        int zOffset = 0;
        switch ((class_2350)state.method_11654((class_2769)class_2741.field_12481)) {
            case field_11043: {
                xLen = true;
                if (chestType != class_2745.field_12571) break;
                xOffset = -1;
                break;
            }
            case field_11035: {
                xLen = true;
                if (chestType != class_2745.field_12574) break;
                xOffset = -1;
                break;
            }
            case field_11034: {
                zLen = true;
                if (chestType != class_2745.field_12571) break;
                zOffset = -1;
                break;
            }
            case field_11039: {
                zLen = true;
                if (chestType != class_2745.field_12574) break;
                zOffset = -1;
            }
        }
        for (int i = 0; i < 20; ++i) {
            double x = (double)pos.method_10263() + 0.25 + world.field_9229.method_43058() * (0.5 + (double)xLen) + (double)xOffset;
            double y = (double)pos.method_10264() + 0.25 + world.field_9229.method_43058() * 0.5;
            double z = (double)pos.method_10260() + 0.25 + world.field_9229.method_43058() * (0.5 + (double)zLen) + (double)zOffset;
            world.method_8406(particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    static {
        cascades = new ConcurrentHashMap();
        fireflyFrequency = 1.0f;
        leavesData = new HashMap<class_2248, LeafData>();
    }

    public static class LeafData {
        private final class_2394 particle;
        private final BiFunction<class_1937, class_2338, Color> colorBiFunc;

        public LeafData(class_2394 particle, BiFunction<class_1937, class_2338, Color> colorBiFunc) {
            this.particle = particle;
            this.colorBiFunc = colorBiFunc;
        }

        public LeafData(class_2394 particle, Color color) {
            this(particle, (class_1937 world, class_2338 pos) -> color);
        }

        public LeafData(class_2394 particle) {
            this(particle, (class_1937 world, class_2338 pos) -> new Color(class_1163.method_4966((class_1920)world, (class_2338)pos)));
        }

        public class_2394 getParticle() {
            return this.particle;
        }

        public Color getColor(class_1937 world, class_2338 pos) {
            return this.colorBiFunc.apply(world, pos);
        }
    }
}

