/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.external.Vanilla;
import carpet.script.utils.Colors;
import carpet.script.value.BlockValue;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.class_11;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2096;
import net.minecraft.class_2265;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_266;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_274;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3542;
import net.minecraft.class_3620;
import net.minecraft.class_4115;
import net.minecraft.class_4142;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6670;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9;
import net.minecraft.class_9015;
import net.minecraft.server.MinecraftServer;

public class ValueConversions {
    private static final Int2ObjectMap<SlotParam> slotIdsToSlotParams = new Int2ObjectOpenHashMap<SlotParam>(){
        {
            int n;
            for (n = 0; n < 54; ++n) {
                this.put(n, new SlotParam(null, n));
            }
            for (n = 0; n < 27; ++n) {
                this.put(200 + n, new SlotParam("enderchest", n));
            }
            for (n = 0; n < 8; ++n) {
                this.put(300 + n, new SlotParam(null, n));
            }
            for (n = 0; n < 15; ++n) {
                this.put(500 + n, new SlotParam(null, n + 2));
            }
            this.put(98, new SlotParam("equipment", 0));
            this.put(99, new SlotParam("equipment", 5));
            for (n = 0; n < 4; ++n) {
                this.put(100 + n, new SlotParam("equipment", n + 1));
            }
            this.put(400, new SlotParam(null, 0));
            this.put(401, new SlotParam(null, 1));
        }
    };

    public static Value of(class_2338 pos) {
        return ListValue.of(new NumericValue(pos.method_10263()), new NumericValue(pos.method_10264()), new NumericValue(pos.method_10260()));
    }

    public static Value of(class_243 vec) {
        return ListValue.of(new NumericValue(vec.field_1352), new NumericValue(vec.field_1351), new NumericValue(vec.field_1350));
    }

    public static Value of(class_2265 cpos) {
        return ListValue.of(new NumericValue(cpos.comp_638()), new NumericValue(cpos.comp_639()));
    }

    public static Value of(class_3218 world) {
        return ValueConversions.of(world.method_27983().method_29177());
    }

    public static Value of(class_3620 color) {
        return ListValue.of(StringValue.of(Colors.mapColourName.get(color)), ValueConversions.ofRGB(color.field_16011));
    }

    public static <T extends Number> Value of(class_2096<T> range) {
        return ListValue.of(range.comp_1805().map(NumericValue::of).orElse(Value.NULL), range.comp_1806().map(NumericValue::of).orElse(Value.NULL));
    }

    public static Value of(class_1799 stack, class_5455 regs) {
        return stack == null || stack.method_7960() ? Value.NULL : ListValue.of(ValueConversions.of(stack.method_7909(), regs), new NumericValue(stack.method_7947()), NBTSerializableValue.fromStack(stack, regs));
    }

    public static Value of(class_1792 item, class_5455 regs) {
        return ValueConversions.of(regs.method_30530(class_7924.field_41197).method_10221((Object)item));
    }

    public static Value of(class_266 objective) {
        return ListValue.of(StringValue.of(objective.method_1113()), StringValue.of(objective.method_1116().method_1225()));
    }

    public static Value of(class_274 criteria) {
        return ListValue.of(StringValue.of(criteria.method_1225()), BooleanValue.of(criteria.method_1226()));
    }

    public static Value of(class_2394 particle, class_5455 regs) {
        String repr = class_2398.field_25125.encodeStart((DynamicOps)regs.method_57093((DynamicOps)class_2509.field_11560), (Object)particle).toString();
        return StringValue.of(repr.startsWith("minecraft:") ? repr.substring(10) : repr);
    }

    public static Value ofRGB(int value) {
        return new NumericValue(value * 256 + 255);
    }

    public static class_1937 dimFromValue(Value dimensionValue, MinecraftServer server) {
        String dimString;
        if (dimensionValue instanceof EntityValue) {
            return ((EntityValue)dimensionValue).getEntity().method_5770();
        }
        if (dimensionValue instanceof BlockValue) {
            BlockValue bv = (BlockValue)dimensionValue;
            if (bv.getWorld() != null) {
                return bv.getWorld();
            }
            throw new InternalExpressionException("dimension argument accepts only world-localized block arguments");
        }
        return switch (dimString = dimensionValue.getString().toLowerCase(Locale.ROOT)) {
            case "nether", "the_nether" -> server.method_3847(class_1937.field_25180);
            case "end", "the_end" -> server.method_3847(class_1937.field_25181);
            case "overworld", "over_world" -> server.method_3847(class_1937.field_25179);
            default -> {
                class_5321 dim = null;
                class_2960 id = class_2960.method_60654((String)dimString);
                for (class_5321 world : server.method_29435()) {
                    if (!id.equals((Object)world.method_29177())) continue;
                    dim = world;
                    break;
                }
                if (dim == null) {
                    throw new ThrowStatement(dimString, Throwables.UNKNOWN_DIMENSION);
                }
                yield server.method_3847(dim);
            }
        };
    }

    public static Value of(class_5321<?> dim) {
        return ValueConversions.of(dim.method_29177());
    }

    public static Value of(class_6862<?> tagKey) {
        return ValueConversions.of(tagKey.comp_327());
    }

    public static Value of(class_6885.class_6888<?> tagKey) {
        return ValueConversions.of(tagKey.method_40251().comp_327());
    }

    public static Value of(@Nullable class_2960 id) {
        if (id == null) {
            return Value.NULL;
        }
        return new StringValue(ValueConversions.simplify(id));
    }

    public static String simplify(class_2960 id) {
        if (id == null) {
            return "";
        }
        if (id.method_12836().equals("minecraft")) {
            return id.method_12832();
        }
        return id.toString();
    }

    public static Value of(class_4208 pos) {
        return ListValue.of(ValueConversions.of(pos.comp_2207()), ValueConversions.of(pos.comp_2208()));
    }

    public static Value fromPath(class_3218 world, class_11 path) {
        ArrayList<Value> nodes = new ArrayList<Value>();
        int len = path.method_38();
        for (int i = 0; i < len; ++i) {
            class_9 node = path.method_40(i);
            nodes.add(ListValue.of(new BlockValue(null, world, node.method_22879()), new StringValue(node.field_41.name().toLowerCase(Locale.ROOT)), new NumericValue(node.field_43), BooleanValue.of(node.field_42)));
        }
        return ListValue.wrap(nodes);
    }

    public static Value fromTimedMemory(class_1297 e, long expiry, Object v) {
        Value ret = ValueConversions.fromEntityMemory(e, v);
        return ret.isNull() || expiry == Long.MAX_VALUE ? ret : ListValue.of(ret, new NumericValue(expiry));
    }

    private static Value fromEntityMemory(class_1297 e, Object v) {
        if (v instanceof class_4208) {
            class_4208 pos = (class_4208)v;
            return ValueConversions.of(pos);
        }
        if (v instanceof class_1297) {
            class_1297 entity2 = (class_1297)v;
            return new EntityValue(entity2);
        }
        if (v instanceof class_2338) {
            class_2338 pos = (class_2338)v;
            return new BlockValue(null, (class_3218)e.method_5770(), pos);
        }
        if (v instanceof Number) {
            Number number = (Number)((Object)v);
            return new NumericValue(number.doubleValue());
        }
        if (v instanceof Boolean) {
            Boolean bool = (Boolean)((Object)v);
            return BooleanValue.of(bool);
        }
        if (v instanceof UUID) {
            UUID uuid = (UUID)((Object)v);
            return ValueConversions.ofUUID((class_3218)e.method_5770(), uuid);
        }
        if (v instanceof class_1282) {
            class_1282 source = (class_1282)v;
            return ListValue.of(new StringValue(source.method_5525()), source.method_5529() == null ? Value.NULL : new EntityValue(source.method_5529()));
        }
        if (v instanceof class_11) {
            class_11 path = (class_11)v;
            return ValueConversions.fromPath((class_3218)e.method_5770(), path);
        }
        if (v instanceof class_4115) {
            class_4115 tracker = (class_4115)v;
            return new BlockValue(null, (class_3218)e.method_5770(), tracker.method_18989());
        }
        if (v instanceof class_4142) {
            class_4142 target = (class_4142)v;
            return ListValue.of(new BlockValue(null, (class_3218)e.method_5770(), target.method_19094().method_18989()), new NumericValue(target.method_19095()), new NumericValue(target.method_19096()));
        }
        if (v instanceof class_6670) {
            class_6670 nvle = (class_6670)v;
            v = StreamSupport.stream(nvle.method_38978(entity -> true).spliterator(), false).toList();
        }
        if (v instanceof Set) {
            Set set = (Set)((Object)v);
            v = new ArrayList(set);
        }
        if (v instanceof List) {
            List l = v;
            if (l.isEmpty()) {
                return ListValue.of(new Value[0]);
            }
            Object el = l.get(0);
            if (el instanceof class_1297) {
                class_1297 entity3 = (class_1297)el;
                return ListValue.wrap(l.stream().map(o -> new EntityValue(entity3)));
            }
            if (el instanceof class_4208) {
                class_4208 pos = (class_4208)el;
                return ListValue.wrap(l.stream().map(o -> ValueConversions.of(pos)));
            }
        }
        return Value.NULL;
    }

    private static Value ofUUID(class_3218 entityWorld, UUID uuid) {
        class_1297 current = entityWorld.method_14190(uuid);
        return ListValue.of(current == null ? Value.NULL : new EntityValue(current), new StringValue(uuid.toString()));
    }

    public static Value of(class_238 box) {
        return ListValue.of(ListValue.fromTriple(box.field_1323, box.field_1322, box.field_1321), ListValue.fromTriple(box.field_1320, box.field_1325, box.field_1324));
    }

    public static Value of(class_3341 box) {
        return ListValue.of(ListValue.fromTriple(box.method_35415(), box.method_35416(), box.method_35417()), ListValue.fromTriple(box.method_35418(), box.method_35419(), box.method_35420()));
    }

    public static Value of(class_3449 structure, class_5455 regs) {
        if (structure == null || structure == class_3449.field_16713) {
            return Value.NULL;
        }
        class_3341 boundingBox = structure.method_14969();
        if (boundingBox.method_35418() < boundingBox.method_35415() || boundingBox.method_35419() < boundingBox.method_35416() || boundingBox.method_35420() < boundingBox.method_35417()) {
            return Value.NULL;
        }
        HashMap<Value, Value> ret = new HashMap<Value, Value>();
        ret.put(new StringValue("box"), ValueConversions.of(boundingBox));
        ArrayList<Value> pieces = new ArrayList<Value>();
        for (class_3443 piece : structure.method_14963()) {
            class_3341 box = piece.method_14935();
            if (box.method_35418() < box.method_35415() || box.method_35419() < box.method_35416() || box.method_35420() < box.method_35417()) continue;
            pieces.add(ListValue.of(NBTSerializableValue.nameFromRegistryId(regs.method_30530(class_7924.field_41227).method_10221((Object)piece.method_16653())), piece.method_14934() == null ? Value.NULL : new StringValue(piece.method_14934().method_10151()), ListValue.fromTriple(box.method_35415(), box.method_35416(), box.method_35417()), ListValue.fromTriple(box.method_35418(), box.method_35419(), box.method_35420())));
        }
        ret.put(new StringValue("pieces"), ListValue.wrap(pieces));
        return MapValue.wrap(ret);
    }

    public static Value of(class_9015 scoreHolder) {
        return FormattedTextValue.of(scoreHolder.method_55423());
    }

    public static Value fromProperty(class_2680 state, class_2769<?> p) {
        Comparable object = state.method_11654(p);
        if (object instanceof Boolean || object instanceof Number) {
            return StringValue.of(object.toString());
        }
        if (object instanceof class_3542) {
            class_3542 stringRepresentable = (class_3542)object;
            return StringValue.of(stringRepresentable.method_15434());
        }
        throw new InternalExpressionException("Unknown property type: " + p.method_11899());
    }

    public static Value ofVanillaSlotResult(int itemSlot) {
        SlotParam ret = (SlotParam)slotIdsToSlotParams.get(itemSlot);
        return ret == null ? ListValue.of(Value.NULL, new NumericValue(itemSlot)) : ret.build();
    }

    public static Value ofBlockPredicate(class_5455 registryAccess, Predicate<class_2694> blockPredicate) {
        Vanilla.BlockPredicatePayload payload = Vanilla.BlockPredicatePayload.of(blockPredicate);
        class_2378 blocks = registryAccess.method_30530(class_7924.field_41254);
        return ListValue.of(payload.state() == null ? Value.NULL : ValueConversions.of(blocks.method_10221((Object)payload.state().method_26204())), payload.tagKey() == null ? Value.NULL : ValueConversions.of(((class_6885.class_6888)blocks.method_46733(payload.tagKey()).get()).method_40251()), MapValue.wrap(payload.properties()), payload.tag() == null ? Value.NULL : new NBTSerializableValue((class_2520)payload.tag()));
    }

    public static class_1799 getItemStackFromValue(Value value, boolean withCount, class_5455 regs) {
        String name;
        if (value.isNull()) {
            return class_1799.field_8037;
        }
        int count = 1;
        class_2487 nbtTag = null;
        if (value instanceof ListValue) {
            Value nbtValue;
            ListValue list = (ListValue)value;
            if (list.length() != 3) {
                throw new ThrowStatement("item definition from list of size " + list.length(), Throwables.UNKNOWN_ITEM);
            }
            List<Value> items = list.getItems();
            name = items.get(0).getString();
            if (withCount) {
                count = NumericValue.asNumber(items.get(1)).getInt();
            }
            if (!(nbtValue = items.get(2)).isNull()) {
                nbtTag = ((NBTSerializableValue)NBTSerializableValue.fromValue(nbtValue)).getCompoundTag();
            }
        } else {
            name = value.getString();
        }
        class_1799 itemInput = NBTSerializableValue.parseItem(name, nbtTag, regs);
        itemInput.method_7939(count);
        return itemInput;
    }

    public static Value guess(class_3218 serverWorld, Object o) {
        if (o == null) {
            return Value.NULL;
        }
        if (o instanceof List) {
            List list = (List)o;
            return ListValue.wrap(list.stream().map(oo -> ValueConversions.guess(serverWorld, oo)));
        }
        if (o instanceof class_2338) {
            class_2338 pos = (class_2338)o;
            return new BlockValue(null, serverWorld, pos);
        }
        if (o instanceof class_1297) {
            class_1297 e = (class_1297)o;
            return EntityValue.of(e);
        }
        if (o instanceof class_243) {
            class_243 vec3 = (class_243)o;
            return ValueConversions.of(vec3);
        }
        if (o instanceof class_2382) {
            class_2382 vec3i = (class_2382)o;
            return ValueConversions.of(new class_2338(vec3i));
        }
        if (o instanceof class_238) {
            class_238 aabb = (class_238)o;
            return ValueConversions.of(aabb);
        }
        if (o instanceof class_3341) {
            class_3341 bb = (class_3341)o;
            return ValueConversions.of(bb);
        }
        if (o instanceof class_1799) {
            class_1799 itemStack = (class_1799)o;
            return ValueConversions.of(itemStack, serverWorld.method_30349());
        }
        if (o instanceof Boolean) {
            Boolean bool = (Boolean)o;
            return BooleanValue.of(bool);
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            return NumericValue.of(number);
        }
        if (o instanceof class_2960) {
            class_2960 resourceLocation = (class_2960)o;
            return ValueConversions.of(resourceLocation);
        }
        return StringValue.of(o.toString());
    }

    record SlotParam(String type, int id) {
        public ListValue build() {
            return ListValue.of(StringValue.of(this.type), new NumericValue(this.id));
        }
    }
}

