/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.annotation;

import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4208;
import net.minecraft.class_5455;
import org.apache.commons.lang3.ClassUtils;

public final class OutputConverter<T> {
    private static final Map<Class<?>, OutputConverter<?>> byResult = new HashMap();
    private static final OutputConverter<Value> VALUE = new OutputConverter<Value>((v, regs) -> v);
    private final BiFunction<T, class_5455, Value> converter;

    private OutputConverter(BiFunction<T, class_5455, Value> converter) {
        this.converter = converter;
    }

    public static <T> OutputConverter<T> get(Class<T> returnType) {
        if (Value.class.isAssignableFrom(returnType)) {
            return VALUE;
        }
        returnType = ClassUtils.primitiveToWrapper(returnType);
        return Objects.requireNonNull(byResult.get(returnType), "Unregistered output type: " + String.valueOf(returnType) + ". Register in OutputConverter");
    }

    public Value convert(@Nullable T input, class_5455 regs) {
        return input == null ? Value.NULL : this.converter.apply(input, regs);
    }

    public static <T> void register(Class<T> inputType, BiFunction<T, class_5455, Value> converter) {
        OutputConverter<T> instance = new OutputConverter<T>(converter);
        if (byResult.containsKey(inputType)) {
            throw new IllegalArgumentException(String.valueOf(inputType) + " already has a registered OutputConverter");
        }
        byResult.put(inputType, instance);
    }

    public static <T> void register(Class<T> inputType, Function<T, Value> converter) {
        OutputConverter.register(inputType, (T v, class_5455 regs) -> (Value)converter.apply(v));
    }

    @Deprecated
    public static <T> void registerToValue(Class<T> inputType, BiFunction<T, class_5455, Value> converter) {
        OutputConverter.register(inputType, converter);
    }

    @Deprecated
    public static <T> void registerToValue(Class<T> inputType, Function<T, Value> converter) {
        OutputConverter.register(inputType, (T v, class_5455 regs) -> (Value)converter.apply(v));
    }

    static {
        OutputConverter.register(Void.TYPE, (T v) -> Value.NULL);
        OutputConverter.register(Boolean.class, BooleanValue::of);
        OutputConverter.register(Integer.class, (T v, class_5455 r) -> new NumericValue(v.intValue()));
        OutputConverter.register(Double.class, NumericValue::of);
        OutputConverter.register(Float.class, NumericValue::of);
        OutputConverter.register(Long.class, (T v, class_5455 r) -> new NumericValue((long)v));
        OutputConverter.register(String.class, StringValue::new);
        OutputConverter.register(class_1297.class, EntityValue::new);
        OutputConverter.register(class_2561.class, FormattedTextValue::new);
        OutputConverter.register(class_2520.class, NBTSerializableValue::new);
        OutputConverter.register(class_2338.class, (T v, class_5455 r) -> ValueConversions.of(v));
        OutputConverter.register(class_243.class, (T v, class_5455 r) -> ValueConversions.of(v));
        OutputConverter.register(class_1799.class, (T v, class_5455 r) -> ValueConversions.of(v, r));
        OutputConverter.register(class_2960.class, (T v, class_5455 r) -> ValueConversions.of(v));
        OutputConverter.register(class_4208.class, (T v, class_5455 r) -> ValueConversions.of(v));
    }
}

