/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jse;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OsLib;
import org.luaj.vm2.lib.jse.JseProcess;

public class JseOsLib
extends OsLib {
    public static final int EXEC_IOEXCEPTION = 1;
    public static final int EXEC_INTERRUPTED = -2;
    public static final int EXEC_ERROR = -3;

    @Override
    protected String getenv(String varname) {
        String s2 = System.getenv(varname);
        return s2 != null ? s2 : System.getProperty(varname);
    }

    @Override
    protected Varargs execute(String command) {
        int exitValue;
        try {
            exitValue = new JseProcess(command, null, (OutputStream)this.globals.STDOUT, (OutputStream)this.globals.STDERR).waitFor();
        }
        catch (IOException ioe) {
            exitValue = 1;
        }
        catch (InterruptedException e) {
            exitValue = -2;
        }
        catch (Throwable t2) {
            exitValue = -3;
        }
        if (exitValue == 0) {
            return JseOsLib.varargsOf(TRUE, JseOsLib.valueOf("exit"), ZERO);
        }
        return JseOsLib.varargsOf(NIL, JseOsLib.valueOf("signal"), JseOsLib.valueOf(exitValue));
    }

    @Override
    protected void remove(String filename) throws IOException {
        File f = new File(filename);
        if (!f.exists()) {
            throw new IOException("No such file or directory");
        }
        if (!f.delete()) {
            throw new IOException("Failed to delete");
        }
    }

    @Override
    protected void rename(String oldname, String newname) throws IOException {
        File f = new File(oldname);
        if (!f.exists()) {
            throw new IOException("No such file or directory");
        }
        if (!f.renameTo(new File(newname))) {
            throw new IOException("Failed to rename");
        }
    }

    @Override
    protected String tmpname() {
        try {
            File f = File.createTempFile(".luaj", "tmp");
            return f.getAbsolutePath();
        }
        catch (IOException ioe) {
            return super.tmpname();
        }
    }
}

