/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.geantyref;

import io.leangen.geantyref.AnnotatedTypeImpl;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.WildcardType;
import java.util.Arrays;

class AnnotatedWildcardTypeImpl
extends AnnotatedTypeImpl
implements AnnotatedWildcardType {
    private AnnotatedType[] lowerBounds;
    private AnnotatedType[] upperBounds;

    AnnotatedWildcardTypeImpl(WildcardType type2, Annotation[] annotations, AnnotatedType[] lowerBounds, AnnotatedType[] upperBounds) {
        super(type2, annotations);
        if (lowerBounds == null || lowerBounds.length == 0) {
            lowerBounds = new AnnotatedType[]{};
        }
        if (upperBounds == null || upperBounds.length == 0) {
            upperBounds = new AnnotatedType[]{GenericTypeReflector.annotate(Object.class)};
        }
        AnnotatedWildcardTypeImpl.validateBounds(type2, lowerBounds, upperBounds);
        this.lowerBounds = lowerBounds;
        this.upperBounds = upperBounds;
    }

    @Override
    public AnnotatedType[] getAnnotatedLowerBounds() {
        return this.lowerBounds;
    }

    @Override
    public AnnotatedType[] getAnnotatedUpperBounds() {
        return this.upperBounds;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof AnnotatedWildcardType) || !super.equals(other)) {
            return false;
        }
        return GenericTypeReflector.typeArraysEqual(this.lowerBounds, ((AnnotatedWildcardType)other).getAnnotatedLowerBounds()) && GenericTypeReflector.typeArraysEqual(this.upperBounds, ((AnnotatedWildcardType)other).getAnnotatedUpperBounds());
    }

    @Override
    public int hashCode() {
        return 127 * super.hashCode() ^ GenericTypeReflector.hashCode(this.lowerBounds) + GenericTypeReflector.hashCode(this.upperBounds);
    }

    @Override
    public String toString() {
        if (this.lowerBounds.length > 0) {
            return this.annotationsString() + "? super " + this.typesString(this.lowerBounds);
        }
        if (this.upperBounds.length == 0 || this.upperBounds[0].getType() == Object.class) {
            return this.annotationsString() + "?";
        }
        return this.annotationsString() + "? extends " + this.typesString(this.upperBounds);
    }

    private static void validateBounds(WildcardType type2, AnnotatedType[] lowerBounds, AnnotatedType[] upperBounds) {
        int i;
        if (type2.getLowerBounds().length != lowerBounds.length) {
            throw new IllegalArgumentException("Incompatible lower bounds " + Arrays.toString(lowerBounds) + " for type " + type2.toString());
        }
        if (type2.getUpperBounds().length != upperBounds.length) {
            throw new IllegalArgumentException("Incompatible upper bounds " + Arrays.toString(upperBounds) + " for type " + type2.toString());
        }
        for (i = 0; i < type2.getLowerBounds().length; ++i) {
            if (GenericTypeReflector.erase(type2.getLowerBounds()[i]) == GenericTypeReflector.erase(lowerBounds[i].getType())) continue;
            throw new IllegalArgumentException("Bound " + lowerBounds[i].getType() + " incompatible with " + type2.getLowerBounds()[i] + " in type " + type2.toString());
        }
        for (i = 0; i < type2.getUpperBounds().length; ++i) {
            if (GenericTypeReflector.erase(type2.getUpperBounds()[i]) == GenericTypeReflector.erase(upperBounds[i].getType())) continue;
            throw new IllegalArgumentException("Bound " + upperBounds[i].getType() + " incompatible with " + type2.getUpperBounds()[i] + " in type " + type2.toString());
        }
    }
}

