/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_modification;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.Restrictions;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.VersionUtils;
import com.moulberry.axiom.clipboard.Placement;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionHistoryElement;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.hooks.ServerLevelExt;
import com.moulberry.axiom.packets.AxiomServerboundRequestChunkData;
import com.moulberry.axiom.packets.AxiomServerboundRequestEntityData;
import com.moulberry.axiom.packets.AxiomServerboundSetBuffer;
import com.moulberry.axiom.packets.SupportedProtocol;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.tools.modelling.ModellingTool;
import com.moulberry.axiom.utils.StringUtils;
import com.moulberry.axiom.world_modification.BiomeBuffer;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.ChunkDataConsumer;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import com.moulberry.axiom.world_modification.DummyBuffer;
import com.moulberry.axiom.world_modification.EntityDataConsumer;
import com.moulberry.axiom.world_modification.HistoryBuffer;
import com.moulberry.axiom.world_modification.HistoryEntry;
import com.moulberry.axiom.world_modification.HistoryIO;
import com.moulberry.axiom.world_modification.UndoRedoTracer;
import com.moulberry.axiom.world_modification.undo.ModellingAdditionalUndoOperation;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7477;
import net.minecraft.class_7924;
import net.minecraft.class_8212;

public class Dispatcher {
    private static final long DATA_REQUEST_TIMEOUT_MILLIS = 60000L;
    private static final HistoryBuffer<SelectionHistoryElement> activeSelectionHistory = new HistoryBuffer();
    private static HistoryBuffer<BlockOrBiomeBuffer> history = new HistoryBuffer();
    private static int activeSelectionHistoryStart = 0;
    private static final Long2ObjectMap<ChunkDataConsumer> chunkDataCallbacks = new Long2ObjectOpenHashMap();
    private static final Long2LongOpenHashMap chunkDataTime = new Long2LongOpenHashMap();
    private static final Long2ObjectMap<PendingChunkData> pendingChunkData = new Long2ObjectOpenHashMap();
    private static final Long2ObjectMap<EntityDataConsumer> entityDataCallbacks = new Long2ObjectOpenHashMap();
    private static final Long2LongOpenHashMap entityDataTime = new Long2LongOpenHashMap();
    private static final Long2ObjectMap<PendingEntityData> pendingEntityData = new Long2ObjectOpenHashMap();
    private static final List<UndoRedoTracer> tracers = new ArrayList<UndoRedoTracer>();
    private static boolean shouldRemovePlacementOnStep;
    public static String historyIdentifier;

    public static void clearHistory() {
        historyIdentifier = null;
        tracers.clear();
        history.clear();
        chunkDataCallbacks.clear();
        pendingChunkData.clear();
        activeSelectionHistory.clear();
        activeSelectionHistoryStart = 0;
        shouldRemovePlacementOnStep = false;
    }

    private static Path getHistoryPath() {
        return Axiom.getInstance().getConfigDirectory().resolve("history").resolve(StringUtils.sanitizePath(historyIdentifier));
    }

    public static void tryLoadHistory() {
        if (historyIdentifier != null) {
            Path path = Dispatcher.getHistoryPath();
            history = HistoryIO.loadHistory(path);
        }
    }

    public static void addTracer(UndoRedoTracer tracer) {
        tracers.add(tracer);
    }

    public static void tick() {
        for (int i = 0; i < tracers.size(); ++i) {
            UndoRedoTracer tracer = tracers.get(i);
            if (!tracer.tick()) continue;
            tracers.remove(i);
            --i;
        }
        if (!chunkDataTime.isEmpty()) {
            long currentTime = System.currentTimeMillis();
            LongArraySet removeWaitingChunks = new LongArraySet();
            for (Long2LongMap.Entry entry : chunkDataTime.long2LongEntrySet()) {
                long id = entry.getLongKey();
                if (!chunkDataCallbacks.containsKey(id)) {
                    removeWaitingChunks.add(id);
                    continue;
                }
                long time = entry.getLongValue();
                if (currentTime <= time) continue;
                removeWaitingChunks.add(id);
            }
            ObjectIterator objectIterator = removeWaitingChunks.iterator();
            while (objectIterator.hasNext()) {
                long id = (Long)objectIterator.next();
                pendingChunkData.remove(id);
                chunkDataCallbacks.remove(id);
                chunkDataTime.remove(id);
            }
            LongArraySet removeWaitingEntities = new LongArraySet();
            for (Long2LongMap.Entry entry : entityDataTime.long2LongEntrySet()) {
                long id = entry.getLongKey();
                if (!entityDataCallbacks.containsKey(id)) {
                    removeWaitingEntities.add(id);
                    continue;
                }
                long time = entry.getLongValue();
                if (currentTime <= time) continue;
                removeWaitingEntities.add(id);
            }
            ObjectIterator objectIterator2 = removeWaitingEntities.iterator();
            while (objectIterator2.hasNext()) {
                long id = (Long)objectIterator2.next();
                pendingEntityData.remove(id);
                entityDataCallbacks.remove(id);
                entityDataTime.remove(id);
            }
        }
    }

    public static void requestChunkData(LongSet blockEntities, LongSet chunkSections, boolean sendBlockEntitiesInChunks, ChunkDataConsumer callback) {
        if (!ClientEvents.serverSupportsProtocol(SupportedProtocol.REQUEST_CHUNK)) {
            callback.accept((Long2ObjectMap<CompressedBlockEntity>)new Long2ObjectOpenHashMap(), (Long2ObjectMap<class_2841<class_2680>>)new Long2ObjectOpenHashMap());
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            long id;
            while (chunkDataCallbacks.containsKey(id = ThreadLocalRandom.current().nextLong())) {
            }
            new AxiomServerboundRequestChunkData(id, (class_5321<class_1937>)level.method_27983(), blockEntities, chunkSections, sendBlockEntitiesInChunks).send();
            chunkDataCallbacks.put(id, (Object)callback);
            chunkDataTime.put(id, System.currentTimeMillis() + 60000L);
        }
    }

    public static void finishRequestChunkData(long id, boolean finished, Long2ObjectMap<CompressedBlockEntity> compressedBlockEntityMap, Long2ObjectMap<class_2841<class_2680>> chunkSections) {
        if (finished) {
            PendingChunkData pending = (PendingChunkData)pendingChunkData.remove(id);
            ChunkDataConsumer callback = (ChunkDataConsumer)chunkDataCallbacks.remove(id);
            chunkDataTime.remove(id);
            if (callback == null) {
                return;
            }
            if (pending != null) {
                pending.compressedBlockEntityMap.putAll(compressedBlockEntityMap);
                pending.chunkSections.putAll(chunkSections);
                callback.accept(pending.compressedBlockEntityMap, pending.chunkSections);
            } else {
                callback.accept(compressedBlockEntityMap, chunkSections);
            }
        } else if (pendingChunkData.containsKey(id)) {
            PendingChunkData pending = (PendingChunkData)pendingChunkData.get(id);
            pending.compressedBlockEntityMap.putAll(compressedBlockEntityMap);
            pending.chunkSections.putAll(chunkSections);
            chunkDataTime.put(id, System.currentTimeMillis() + 60000L);
        } else {
            pendingChunkData.put(id, (Object)new PendingChunkData(compressedBlockEntityMap, chunkSections));
            chunkDataTime.put(id, System.currentTimeMillis() + 60000L);
        }
    }

    public static void requestEntityData(List<UUID> entities, EntityDataConsumer callback) {
        if (!ClientEvents.serverSupportsProtocol(SupportedProtocol.REQUEST_ENTITY)) {
            callback.accept(new HashMap<UUID, class_2487>());
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            long id;
            while (entityDataCallbacks.containsKey(id = ThreadLocalRandom.current().nextLong())) {
            }
            new AxiomServerboundRequestEntityData(id, entities).send();
            entityDataCallbacks.put(id, (Object)callback);
            entityDataTime.put(id, System.currentTimeMillis() + 60000L);
        }
    }

    public static void finishRequestEntityData(long id, boolean finished, Map<UUID, class_2487> entityData) {
        if (finished) {
            PendingEntityData pending = (PendingEntityData)pendingEntityData.remove(id);
            EntityDataConsumer callback = (EntityDataConsumer)entityDataCallbacks.remove(id);
            entityDataTime.remove(id);
            if (callback == null) {
                return;
            }
            if (pending != null) {
                pending.entityData.putAll(entityData);
                callback.accept(pending.entityData);
            } else {
                callback.accept(entityData);
            }
        } else if (pendingEntityData.containsKey(id)) {
            PendingEntityData pending = (PendingEntityData)pendingEntityData.get(id);
            pending.entityData.putAll(entityData);
            entityDataTime.put(id, System.currentTimeMillis() + 60000L);
        } else {
            pendingEntityData.put(id, (Object)new PendingEntityData(new HashMap<UUID, class_2487>(entityData)));
            entityDataTime.put(id, System.currentTimeMillis() + 60000L);
        }
    }

    public static void clear() {
        if (historyIdentifier != null) {
            Path path = Dispatcher.getHistoryPath();
            HistoryIO.clear(path);
        }
        history.clear();
        Dispatcher.clearActiveSelectionHistory();
    }

    public static void push(HistoryEntry<BlockOrBiomeBuffer> entry, class_2487 sourceInfo) {
        BlockOrBiomeBuffer blockOrBiomeBuffer;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        if (ClientEvents.c == 0) {
            String c = new String(new byte[]{104, 116, 116, 112, 115, 58, 47, 47, 97, 120, 105, 111, 109, 46, 109, 111, 117, 108, 98, 101, 114, 114, 121, 46, 99, 111, 109, 47, 97, 112, 105, 47, 109, 99, 97, 117, 116, 104, 47, 104, 97, 115, 95, 99, 111, 109, 109, 101, 114, 99, 105, 97, 108, 95, 108, 105, 99, 101, 110, 115, 101, 63, 117, 117, 105, 100, 61});
            ClientEvents.c = c.intern() == c ? 18000 : -1;
        }
        if (Restrictions.rateLimiter != null && (blockOrBiomeBuffer = entry.forwards()) instanceof BlockBuffer) {
            int sortChunkZ;
            int sortChunkY;
            int sortChunkX;
            BlockBuffer blockBuffer = (BlockBuffer)blockOrBiomeBuffer;
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                sortChunkX = player.method_31477() >> 4;
                sortChunkY = player.method_31478() >> 4;
                sortChunkZ = player.method_31479() >> 4;
            } else {
                sortChunkX = 0;
                sortChunkY = 0;
                sortChunkZ = 0;
            }
            LongArrayList positions = new LongArrayList((LongCollection)blockBuffer.keySet());
            positions.sort((k1, k2) -> {
                int posX = class_2338.method_10061((long)k1);
                int posY = class_2338.method_10071((long)k1);
                int posZ = class_2338.method_10083((long)k1);
                long v1 = Math.abs(posX - sortChunkX) + Math.abs(posY - sortChunkY) + Math.abs(posZ - sortChunkZ);
                posX = class_2338.method_10061((long)k2);
                posY = class_2338.method_10071((long)k2);
                posZ = class_2338.method_10083((long)k2);
                long v2 = Math.abs(posX - sortChunkX) + Math.abs(posY - sortChunkY) + Math.abs(posZ - sortChunkZ);
                return Long.compare(v1, v2);
            });
            LongIterator longIterator = positions.longIterator();
            while (longIterator.hasNext() && Restrictions.rateLimiter.tryAcquire()) {
                longIterator.nextLong();
            }
            if (longIterator.hasNext()) {
                LongSet forwardKeys = blockBuffer.keySet();
                LongSet backwardKeys = ((BlockBuffer)entry.backwards()).keySet();
                while (longIterator.hasNext()) {
                    long pos = longIterator.nextLong();
                    forwardKeys.remove(pos);
                    backwardKeys.remove(pos);
                }
                blockBuffer.resetCachedLast();
                ((BlockBuffer)entry.backwards()).resetCachedLast();
                player.method_7353((class_2561)class_2561.method_43470((String)("[Axiom] Exceeded server rate-limit of " + (int)Restrictions.rateLimiter.getRate() + " sections per second")).method_27692(class_124.field_1061), false);
            }
        }
        int oldSize = history.getSize();
        history.push(entry);
        if (historyIdentifier != null) {
            Path path = Dispatcher.getHistoryPath();
            HistoryIO.pushEntry(path, entry, history.getPosition(), oldSize);
        }
        shouldRemovePlacementOnStep = entry.hasModifier(HistoryEntry.MODIFIER_CUT);
        Dispatcher.apply(entry.forwards(), false, sourceInfo);
        Dispatcher.clearActiveSelectionHistory();
    }

    public static void pushActiveSelection(HistoryEntry<SelectionHistoryElement> entry) {
        if (activeSelectionHistory.getSize() == 0) {
            activeSelectionHistoryStart = history.getPosition();
        }
        activeSelectionHistory.push(entry);
        Selection.setShouldRenderSelection(true);
    }

    public static void clearActiveSelectionHistory() {
        activeSelectionHistory.clear();
    }

    private static int getActiveSelectionHistoryStart() {
        if (activeSelectionHistoryStart >= history.getSize()) {
            activeSelectionHistoryStart = history.getSize() - 1;
        }
        return activeSelectionHistoryStart;
    }

    public static int getHistoryPosition() {
        int selectionPosition = activeSelectionHistory.getPosition();
        if (selectionPosition >= 0) {
            return Dispatcher.getActiveSelectionHistoryStart() + selectionPosition + 1;
        }
        return history.getPosition();
    }

    public static void setHistoryPosition(int position) {
        block5: {
            int delta;
            block4: {
                delta = position - Dispatcher.getHistoryPosition();
                if (delta >= 0) break block4;
                if (Placement.INSTANCE.isPlacing() && !ToolManager.isToolActive()) {
                    Placement.INSTANCE.stopPlacement();
                }
                for (int i = 0; i < -delta; ++i) {
                    Dispatcher.undo(false, false, false);
                }
                break block5;
            }
            if (delta <= 0) break block5;
            if (Placement.INSTANCE.isPlacing() && !ToolManager.isToolActive()) {
                Placement.INSTANCE.stopPlacement();
            }
            for (int i = 0; i < delta; ++i) {
                Dispatcher.redo(false, false);
            }
        }
    }

    public static long getHistoryBytes() {
        return history.getSizeInBytes();
    }

    public static int getHistoryDataCount() {
        return activeSelectionHistory.getSize() + history.getSize();
    }

    public static HistoryData getHistoryData(int index) {
        if (index < 0) {
            return null;
        }
        int activeStart = Dispatcher.getActiveSelectionHistoryStart();
        if (index > activeStart) {
            int selectionIndex = index - activeStart - 1;
            if (selectionIndex >= activeSelectionHistory.getSize()) {
                index -= activeSelectionHistory.getSize();
            } else {
                return new HistoryData(activeSelectionHistory.getHistoryEntry(selectionIndex), selectionIndex, true);
            }
        }
        if (index >= history.getSize()) {
            return null;
        }
        return new HistoryData(history.getHistoryEntry(index), index, false);
    }

    public static void renderTracers(class_4587 matrices, class_4184 camera, float partialTick) {
        for (UndoRedoTracer tracer : tracers) {
            tracer.render(matrices, camera, partialTick);
        }
    }

    public static UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case UNDO: {
                Dispatcher.undo(true, true, !EditorUI.isActive());
                return UserAction.ActionResult.USED_STOP;
            }
            case REDO: {
                Dispatcher.redo(true, !EditorUI.isActive());
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    private static void undo(boolean allowPlacement, boolean allowSelection, boolean fromIngame) {
        if (shouldRemovePlacementOnStep) {
            Placement.INSTANCE.stopPlacement();
            shouldRemovePlacementOnStep = false;
        } else if (Placement.INSTANCE.isPlacing() && !ToolManager.isToolActive()) {
            Placement.INSTANCE.stopPlacement();
            return;
        }
        HistoryEntry<SelectionHistoryElement> selectionEntry = activeSelectionHistory.undo(fromIngame ? HistoryEntry.MODIFIER_CAN_BE_UNDONE_INGAME : 0);
        if (selectionEntry != null) {
            selectionEntry.backwards().applyToSelection();
            return;
        }
        HistoryEntry<BlockOrBiomeBuffer> entry = history.undo(fromIngame ? HistoryEntry.MODIFIER_CAN_BE_UNDONE_INGAME : 0);
        if (entry != null) {
            BlockBuffer blockBuffer;
            BlockOrBiomeBuffer blockOrBiomeBuffer;
            if (activeSelectionHistory.getSize() > 0) {
                Selection.clearSelection();
            }
            if (historyIdentifier != null) {
                Path path = Dispatcher.getHistoryPath();
                HistoryIO.setPosition(path, history.getPosition(), history.getSize());
            }
            if (entry.backwards() instanceof DummyBuffer) {
                return;
            }
            tracers.add(new UndoRedoTracer(class_243.method_24953((class_2382)entry.origin()), 0xFF0000, true));
            Dispatcher.apply(entry.backwards(), allowSelection && entry.hasModifier(HistoryEntry.MODIFIER_SELECT_ON_BACKSTEP), null);
            if (entry.additionalUndoOperation() != null) {
                entry.additionalUndoOperation().perform();
            }
            if (allowPlacement && entry.hasModifier(HistoryEntry.MODIFIER_PASTE) && !Placement.INSTANCE.isPlacing() && (blockOrBiomeBuffer = entry.forwards()) instanceof BlockBuffer && (blockBuffer = (BlockBuffer)blockOrBiomeBuffer).getSectionCount() < 4096) {
                Placement.INSTANCE.startPlacement(entry.origin(), blockBuffer, entry.description());
                shouldRemovePlacementOnStep = true;
            }
            if (ToolManager.isToolActive()) {
                ToolManager.getCurrentTool().afterBlockBufferUndo();
            }
        }
    }

    private static void redo(boolean allowPlacement, boolean fromIngame) {
        if (shouldRemovePlacementOnStep) {
            Placement.INSTANCE.stopPlacement();
            shouldRemovePlacementOnStep = false;
        } else if (Placement.INSTANCE.isPlacing() && !ToolManager.isToolActive()) {
            Placement.INSTANCE.stopPlacement();
            return;
        }
        HistoryEntry<SelectionHistoryElement> selectionEntry = activeSelectionHistory.redo(fromIngame ? HistoryEntry.MODIFIER_CAN_BE_UNDONE_INGAME : 0);
        if (selectionEntry != null) {
            selectionEntry.forwards().applyToSelection();
            return;
        }
        HistoryEntry<BlockOrBiomeBuffer> entry = history.redo(fromIngame ? HistoryEntry.MODIFIER_CAN_BE_UNDONE_INGAME : 0);
        if (entry != null) {
            BlockBuffer blockBuffer;
            Object object;
            if (activeSelectionHistory.getSize() > 0) {
                Selection.clearSelection();
            }
            if (historyIdentifier != null) {
                Path path = Dispatcher.getHistoryPath();
                HistoryIO.setPosition(path, history.getPosition(), history.getSize());
            }
            if (entry.forwards() instanceof DummyBuffer) {
                return;
            }
            tracers.add(new UndoRedoTracer(class_243.method_24953((class_2382)entry.origin()), 65280, false));
            if (entry.additionalUndoOperation() instanceof ModellingAdditionalUndoOperation && ToolManager.isToolActive() && (object = ToolManager.getCurrentTool()) instanceof ModellingTool) {
                ModellingTool modellingTool = (ModellingTool)object;
                modellingTool.reset();
            }
            Dispatcher.apply(entry.forwards(), false, null);
            if (allowPlacement && entry.hasModifier(HistoryEntry.MODIFIER_CUT) && !Placement.INSTANCE.isPlacing() && (object = entry.backwards()) instanceof BlockBuffer && (blockBuffer = (BlockBuffer)object).getSectionCount() < 4096) {
                Placement.INSTANCE.startPlacement(entry.origin(), blockBuffer, entry.description());
                shouldRemovePlacementOnStep = true;
            }
            if (ToolManager.isToolActive()) {
                ToolManager.getCurrentTool().afterBlockBufferRedo();
            }
        }
    }

    public static void resetShouldRemovePlacementOnStep() {
        shouldRemovePlacementOnStep = false;
    }

    public static class_2487 simpleSourceInfo(String sourceName) {
        if (!Axiom.getInstance().serverConfig.setBufferSourceInfo()) {
            return null;
        }
        class_2487 sourceInfo = new class_2487();
        sourceInfo.method_10582("SourceName", sourceName);
        return sourceInfo;
    }

    private static void apply(BlockOrBiomeBuffer buffer, boolean select2, class_2487 sourceInfo) {
        if (buffer instanceof BlockBuffer) {
            BlockBuffer blockBuffer = (BlockBuffer)buffer;
            Dispatcher.applyBlockBuffer(blockBuffer, select2, sourceInfo);
        } else if (buffer instanceof BiomeBuffer) {
            BiomeBuffer biomeBuffer = (BiomeBuffer)buffer;
            Dispatcher.applyBiomeBuffer(biomeBuffer, sourceInfo);
        } else {
            throw new FaultyImplementationError();
        }
    }

    private static void applyBiomeBuffer(BiomeBuffer biomeBuffer, class_2487 sourceInfo) {
        if (class_310.method_1551().method_1496()) {
            class_5321 worldKey = class_310.method_1551().field_1687.method_27983();
            class_3218 world = class_310.method_1551().method_1576().method_3847(worldKey);
            Objects.requireNonNull(world);
            class_310.method_1551().method_1576().method_20493(() -> {
                try {
                    Dispatcher.applyBiomeBufferSingleplayer(biomeBuffer, world);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } else {
            class_5321 worldKey = class_310.method_1551().field_1687.method_27983();
            AxiomServerboundSetBuffer.sendMulti((class_5321<class_1937>)worldKey, biomeBuffer, sourceInfo);
        }
    }

    private static void applyBiomeBufferSingleplayer(BiomeBuffer buffer, class_3218 world) {
        HashSet changedChunks = new HashSet();
        int minSection = world.method_32891();
        int maxSection = world.method_31597();
        Optional registryOptional = world.method_30349().method_46759(class_7924.field_41236);
        if (registryOptional.isEmpty()) {
            return;
        }
        class_2378 registry = (class_2378)registryOptional.get();
        buffer.forEachEntry((x, y, z, biome) -> {
            int cy = y >> 2;
            if (cy < minSection || cy > maxSection) {
                return;
            }
            class_2818 chunk = (class_2818)world.method_8402(x >> 2, z >> 2, class_2806.field_12803, false);
            if (chunk == null) {
                return;
            }
            class_2826 section = chunk.method_38259(cy - minSection);
            class_2841 container = (class_2841)section.method_38294();
            Optional holder = registry.method_46746(biome);
            if (holder.isPresent()) {
                container.method_35321(x & 3, y & 3, z & 3, (Object)((class_6880)holder.get()));
                changedChunks.add(chunk);
            }
        });
        class_3898 chunkMap = world.method_14178().field_17254;
        HashMap<class_3222, List> map = new HashMap<class_3222, List>();
        for (class_2818 chunk : changedChunks) {
            chunk.method_65063();
            class_1923 chunkPos = chunk.method_12004();
            for (class_3222 serverPlayer2 : chunkMap.method_17210(chunkPos, false)) {
                map.computeIfAbsent(serverPlayer2, serverPlayer -> new ArrayList()).add(chunk);
            }
        }
        map.forEach((serverPlayer, list) -> serverPlayer.field_13987.method_14364((class_2596)class_8212.method_49685((List)list)));
    }

    public static void applyBlockBuffer(BlockBuffer buffer, boolean select2, class_2487 sourceInfo) {
        if (class_310.method_1551().method_1496()) {
            class_5321 worldKey = class_310.method_1551().field_1687.method_27983();
            class_3218 world = class_310.method_1551().method_1576().method_3847(worldKey);
            Objects.requireNonNull(world);
            ChunkedBooleanRegion selection = select2 ? new ChunkedBooleanRegion() : null;
            class_310.method_1551().method_1576().method_20493(() -> {
                try {
                    if (select2) {
                        Dispatcher.applyBlockBufferSingleplayer(buffer, world, selection);
                        class_310.method_1551().method_20493(() -> {
                            Selection.clearSelection();
                            if (selection.count() <= 0) {
                                selection.close();
                            } else {
                                Selection.set(selection);
                            }
                        });
                    } else {
                        Dispatcher.applyBlockBufferSingleplayer(buffer, world, null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } else {
            if (select2) {
                class_2680 emptyState = BlockBuffer.EMPTY_STATE;
                ChunkedBooleanRegion selection = new ChunkedBooleanRegion();
                for (Long2ObjectMap.Entry entry : buffer.entrySet()) {
                    int cx = class_2338.method_10061((long)entry.getLongKey()) * 16;
                    int cy = class_2338.method_10071((long)entry.getLongKey()) * 16;
                    int cz = class_2338.method_10083((long)entry.getLongKey()) * 16;
                    class_2841 container = (class_2841)entry.getValue();
                    for (int x = 0; x < 16; ++x) {
                        for (int y = 0; y < 16; ++y) {
                            for (int z = 0; z < 16; ++z) {
                                class_2680 blockState = (class_2680)container.method_12321(x, y, z);
                                if (blockState == emptyState) continue;
                                selection.add(cx + x, cy + y, cz + z);
                            }
                        }
                    }
                }
                Selection.clearSelection();
                Selection.set(selection);
            }
            class_5321 worldKey = class_310.method_1551().field_1687.method_27983();
            AxiomServerboundSetBuffer.sendMulti((class_5321<class_1937>)worldKey, buffer, sourceInfo);
        }
    }

    private static void applyBlockBufferSingleplayer(BlockBuffer buffer, class_3218 world, ChunkedBooleanRegion selection) {
        int sortChunkZ;
        int sortChunkY;
        int sortChunkX;
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        class_2680 emptyState = BlockBuffer.EMPTY_STATE;
        boolean hasStarlight = FabricLoader.getInstance().isModLoaded("starlight");
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            sortChunkX = player.method_31477() >> 4;
            sortChunkY = player.method_31478() >> 4;
            sortChunkZ = player.method_31479() >> 4;
        } else {
            sortChunkX = 0;
            sortChunkY = 0;
            sortChunkZ = 0;
        }
        ArrayList<Long2ObjectMap.Entry<class_2841<class_2680>>> entries = new ArrayList<Long2ObjectMap.Entry<class_2841<class_2680>>>((Collection<Long2ObjectMap.Entry<class_2841<class_2680>>>)buffer.entrySet());
        entries.sort(Comparator.comparingLong(entry -> {
            long pos = entry.getLongKey();
            int posX = class_2338.method_10061((long)pos);
            int posY = class_2338.method_10071((long)pos);
            int posZ = class_2338.method_10083((long)pos);
            return Math.abs(posX - sortChunkX) + Math.abs(posY - sortChunkY) + Math.abs(posZ - sortChunkZ);
        }));
        for (Long2ObjectMap.Entry entry2 : entries) {
            int cx = class_2338.method_10061((long)entry2.getLongKey());
            int cy = class_2338.method_10071((long)entry2.getLongKey());
            int cz = class_2338.method_10083((long)entry2.getLongKey());
            class_2841 container = (class_2841)entry2.getValue();
            if (cy < world.method_32891() || cy > world.method_31597()) continue;
            class_2818 chunk = world.method_8497(cx, cz);
            class_2826 section = chunk.method_38259(world.method_31603(cy));
            class_2841 sectionStates = section.method_12265();
            boolean hasOnlyAir = section.method_38292();
            class_2902 worldSurface = null;
            class_2902 oceanFloor = null;
            class_2902 motionBlocking = null;
            class_2902 motionBlockingNoLeaves = null;
            for (Map.Entry heightmap : chunk.method_12011()) {
                switch ((class_2902.class_2903)heightmap.getKey()) {
                    case field_13202: {
                        worldSurface = (class_2902)heightmap.getValue();
                        break;
                    }
                    case field_13200: {
                        oceanFloor = (class_2902)heightmap.getValue();
                        break;
                    }
                    case field_13197: {
                        motionBlocking = (class_2902)heightmap.getValue();
                        break;
                    }
                    case field_13203: {
                        motionBlockingNoLeaves = (class_2902)heightmap.getValue();
                        break;
                    }
                }
            }
            short[] lightUpdates = hasStarlight ? null : ((ServerLevelExt)world).axiom$getPendingLightUpdates(cx, cy, cz);
            boolean sectionChanged = false;
            boolean relightStarlight = false;
            boolean containerMaybeHasPoi = container.method_19526(class_7477::method_46397);
            boolean sectionMaybeHasPoi = section.method_19523(class_7477::method_46397);
            Short2ObjectMap<CompressedBlockEntity> blockEntityChunkMap = buffer.getBlockEntityChunkMap(entry2.getLongKey());
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        class_2680 blockState = (class_2680)container.method_12321(x, y, z);
                        if (blockState == emptyState) continue;
                        int bx = cx * 16 + x;
                        int by = cy * 16 + y;
                        int bz = cz * 16 + z;
                        if (selection != null) {
                            selection.add(bx, by, bz);
                        }
                        if (hasOnlyAir && blockState.method_26215()) continue;
                        class_2248 block = blockState.method_26204();
                        class_2680 old = section.method_12256(x, y, z, blockState, true);
                        if (blockState != old) {
                            Optional oldPoi;
                            sectionChanged = true;
                            blockPos.method_10103(bx, by, bz);
                            motionBlocking.method_12597(x, by, z, blockState);
                            motionBlockingNoLeaves.method_12597(x, by, z, blockState);
                            oceanFloor.method_12597(x, by, z, blockState);
                            worldSurface.method_12597(x, by, z, blockState);
                            if (VersionUtils.hasDifferentLightProperties((class_1922)chunk, (class_2338)blockPos, old, blockState)) {
                                if (hasStarlight) {
                                    relightStarlight = true;
                                } else {
                                    chunk.method_12018().method_51536((class_1922)chunk, x, by, z);
                                    int n = y + z * 16;
                                    lightUpdates[n] = (short)(lightUpdates[n] | 1 << x);
                                }
                            }
                            Optional newPoi = containerMaybeHasPoi ? class_7477.method_43989((class_2680)blockState) : Optional.empty();
                            Optional optional = oldPoi = sectionMaybeHasPoi ? class_7477.method_43989((class_2680)old) : Optional.empty();
                            if (!Objects.equals(oldPoi, newPoi)) {
                                if (oldPoi.isPresent()) {
                                    world.method_19494().method_19112((class_2338)blockPos);
                                }
                                if (newPoi.isPresent()) {
                                    world.method_19494().method_19115((class_2338)blockPos, (class_6880)newPoi.get());
                                }
                            }
                        }
                        if (blockState.method_31709()) {
                            int key;
                            CompressedBlockEntity savedBlockEntity;
                            blockPos.method_10103(bx, by, bz);
                            class_2586 blockEntity = chunk.method_12201((class_2338)blockPos, class_2818.class_2819.field_12859);
                            if (blockEntity == null) {
                                blockEntity = ((class_2343)block).method_10123((class_2338)blockPos, blockState);
                                if (blockEntity != null) {
                                    chunk.method_12216(blockEntity);
                                }
                            } else if (blockEntity.method_11017().method_20526(blockState)) {
                                blockEntity.method_31664(blockState);
                                chunk.method_31723(blockEntity);
                            } else {
                                chunk.method_12041((class_2338)blockPos);
                                blockEntity = ((class_2343)block).method_10123((class_2338)blockPos, blockState);
                                if (blockEntity != null) {
                                    chunk.method_12216(blockEntity);
                                }
                            }
                            if (blockEntity == null || blockEntityChunkMap == null || (savedBlockEntity = (CompressedBlockEntity)blockEntityChunkMap.get((short)(key = x | y << 4 | z << 8))) == null) continue;
                            blockEntity.method_58690(savedBlockEntity.decompress(), (class_7225.class_7874)world.method_30349());
                            sectionChanged = true;
                            continue;
                        }
                        if (!old.method_31709()) continue;
                        chunk.method_12041((class_2338)blockPos);
                    }
                }
            }
            boolean nowHasOnlyAir = section.method_38292();
            if (hasOnlyAir != nowHasOnlyAir) {
                world.method_14178().method_17293().method_15551(class_4076.method_18676((int)cx, (int)cy, (int)cz), nowHasOnlyAir);
                world.method_14178().method_62872(cx, cy, cz, nowHasOnlyAir);
            }
            if (sectionChanged) {
                ((ServerLevelExt)world).axiom$markChunkDirty(cx, cz);
                chunk.method_65063();
            }
            if (!relightStarlight) continue;
            ((ServerLevelExt)world).axiom$relightChunkStarlight(cx, cz);
        }
    }

    static {
        historyIdentifier = null;
    }

    private record PendingChunkData(Long2ObjectMap<CompressedBlockEntity> compressedBlockEntityMap, Long2ObjectMap<class_2841<class_2680>> chunkSections) {
    }

    private record PendingEntityData(Map<UUID, class_2487> entityData) {
    }

    public record HistoryData(HistoryEntry<?> entry, int position, boolean isActiveSelection) {
        public String getIndexIdentifier() {
            if (this.isActiveSelection) {
                if (this.position == 0) {
                    return "a";
                }
                StringBuilder identifier = new StringBuilder();
                for (int position = this.position; position > 0; position /= 26) {
                    int modulo = position % 26;
                    identifier.insert(0, (char)(97 + modulo));
                }
                return identifier.toString();
            }
            return "" + this.position;
        }
    }
}

