/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.core_rendering.AxiomGpuTexture;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import net.minecraft.class_9958;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class RenderHelper {
    private static class_9958 previousFogParameters = null;

    public static void tryApplyModelViewMatrix() {
    }

    public static void setupShader(class_5944 shaderInstance, Matrix4f modelViewMatrix, Matrix4f projectionMatrix) {
        class_1041 window = class_310.method_1551().method_22683();
        RenderHelper.setupShader(shaderInstance, modelViewMatrix, projectionMatrix, window.method_4489(), window.method_4506());
    }

    public static void setupShader(class_5944 shaderInstance, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float screenWidth, float screenHeight) {
        RenderSystem.assertOnRenderThread();
        for (int i = 0; i < 12; ++i) {
            AxiomGpuTexture j = new AxiomGpuTexture(RenderSystem.getShaderTexture((int)i));
            shaderInstance.method_62899("Sampler" + i, j.glId());
        }
        if (shaderInstance.field_29470 != null) {
            shaderInstance.field_29470.method_1250(modelViewMatrix);
        }
        if (shaderInstance.field_29471 != null) {
            shaderInstance.field_29471.method_1250(projectionMatrix);
        }
        if (shaderInstance.field_29474 != null) {
            shaderInstance.field_29474.method_1253(RenderSystem.getShaderColor());
        }
        if (shaderInstance.field_42231 != null) {
            shaderInstance.field_42231.method_1251(RenderSystem.getShaderGlintAlpha());
        }
        class_9958 fogParameters = RenderSystem.getShaderFog();
        if (shaderInstance.field_29477 != null) {
            shaderInstance.field_29477.method_1251(fogParameters.comp_3009());
        }
        if (shaderInstance.field_29478 != null) {
            shaderInstance.field_29478.method_1251(fogParameters.comp_3010());
        }
        if (shaderInstance.field_29479 != null) {
            shaderInstance.field_29479.method_1254(fogParameters.comp_3012(), fogParameters.comp_3013(), fogParameters.comp_3014(), fogParameters.comp_3015());
        }
        if (shaderInstance.field_36373 != null) {
            shaderInstance.field_36373.method_35649(fogParameters.comp_3011().method_40036());
        }
        if (shaderInstance.field_29472 != null) {
            shaderInstance.field_29472.method_1250(RenderSystem.getTextureMatrix());
        }
        if (shaderInstance.field_29481 != null) {
            shaderInstance.field_29481.method_1251(RenderSystem.getShaderGameTime());
        }
        if (shaderInstance.field_29473 != null) {
            shaderInstance.field_29473.method_1255(screenWidth, screenHeight);
        }
        if (shaderInstance.field_29480 != null) {
            shaderInstance.field_29480.method_1251(RenderSystem.getShaderLineWidth());
        }
        RenderSystem.setupShaderLights((class_5944)shaderInstance);
        shaderInstance.method_34586();
    }

    public static void finishShader(class_5944 shaderInstance) {
        shaderInstance.method_34585();
    }

    public static void pushDisableFog() {
        if (previousFogParameters != null && FabricLoader.getInstance().isDevelopmentEnvironment()) {
            throw new IllegalStateException("Fog disable was pushed twice");
        }
        previousFogParameters = RenderSystem.getShaderFog();
        RenderSystem.setShaderFog((class_9958)class_9958.field_53065);
    }

    public static void popDisableFog() {
        if (previousFogParameters == null) {
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                throw new IllegalStateException("Fog disable was popped without being pushed");
            }
            return;
        }
        RenderSystem.setShaderFog((class_9958)previousFogParameters);
        previousFogParameters = null;
    }

    public static void pushModelViewMatrix(Matrix4f matrix4f) {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.set((Matrix4fc)matrix4f);
        RenderHelper.tryApplyModelViewMatrix();
    }

    public static void pushModelViewStackWithIdentity() {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.identity();
        RenderHelper.tryApplyModelViewMatrix();
    }

    public static void popModelViewStack() {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.popMatrix();
        RenderHelper.tryApplyModelViewMatrix();
    }
}

