/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.weld;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.ConcurrentLevelPredicateSet;
import com.moulberry.axiom.collections.Position2FloatMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BrushWidget;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.pather.async.AsyncToolPathProvider;
import com.moulberry.axiom.pather.async.AsyncToolPatherUnique;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.GaussianBlurTable;
import com.moulberry.axiom.utils.RegionHelper;
import imgui.ImGui;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4970;
import net.minecraft.class_638;
import org.joml.Matrix4f;

public class MeltTool
implements Tool {
    private boolean usingTool = false;
    private final Position2FloatMap weights = new Position2FloatMap();
    protected GaussianBlurTable blurTable = null;
    protected ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
    protected final ChunkedBooleanRegion removeRegion = new ChunkedBooleanRegion();
    protected ConcurrentLevelPredicateSet blocksMotionPredicateSet = null;
    protected final List<Future<Position2FloatMap>> futures = new ArrayList<Future<Position2FloatMap>>();
    private AsyncToolPathProvider pathProvider = null;
    private PositionSet inputSet = new PositionSet();
    private final BrushWidget brushWidget = new BrushWidget();
    private final float[] blurStddev = new float[]{2.0f};
    protected final float[] threshold = new float[]{0.1f};
    private final PresetWidget presetWidget = new PresetWidget(this, "melt");
    private static final class_2680 AIR = class_2246.field_10124.method_9564();

    @Override
    public void reset() {
        if (this.usingTool) {
            ChunkRenderOverrider.INSTANCE.release("Melt Tool");
            this.usingTool = false;
        }
        for (Future<Position2FloatMap> future : this.futures) {
            future.cancel(true);
        }
        this.futures.clear();
        this.blurTable = null;
        this.weights.clear();
        this.chunkedBlockRegion = null;
        this.removeRegion.clear();
        if (this.pathProvider != null) {
            this.pathProvider.close();
            this.pathProvider = null;
        }
        this.blocksMotionPredicateSet = null;
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                this.reset();
                this.blurTable = new GaussianBlurTable(this.blurStddev[0], 0.01f);
                if (this.blurTable.isSingleValued()) {
                    this.blurTable = null;
                    return UserAction.ActionResult.USED_STOP;
                }
                this.usingTool = true;
                ChunkRenderOverrider.INSTANCE.acquire("Melt Tool");
                this.chunkedBlockRegion = new ChunkedBlockRegion();
                this.blocksMotionPredicateSet = new ConcurrentLevelPredicateSet((class_1937)class_310.method_1551().field_1687, class_4970.class_4971::method_51366);
                this.pathProvider = new AsyncToolPathProvider(new AsyncToolPatherUnique(this.brushWidget.getBrushShape(), (x, y, z) -> this.inputSet.add(x, y, z)));
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                if (!this.usingTool) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (!this.usingTool) {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                Selection.render(camera, time, matrices, projection, 7);
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.brushWidget.renderPreview(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrices, projection, time, 3);
        } else if (Tool.cancelUsing()) {
            this.reset();
        } else if (!Tool.isMouseDown(1)) {
            float threshold = this.threshold[0];
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                this.reset();
                return;
            }
            this.pathProvider.finish();
            this.addInputsToTool();
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            for (Future<Position2FloatMap> future : this.futures) {
                try {
                    Position2FloatMap map = future.get();
                    if (map == null) continue;
                    map.forEachEntry((x, y, z, v) -> {
                        float newValue = this.weights.add(x, y, z, v);
                        if (newValue >= threshold && newValue - v < threshold && !level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z)).method_26215()) {
                            this.chunkedBlockRegion.addBlock(x, y, z, AIR);
                        }
                    });
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            class_2487 sourceInfo = Tool.getSourceInfo(this);
            String countString = NumberFormat.getInstance().format(this.chunkedBlockRegion.count());
            String historyDescription = AxiomI18n.get("axiom.history_description.melted", countString);
            RegionHelper.pushBlockRegionChange(this.chunkedBlockRegion, historyDescription, sourceInfo);
            this.reset();
        } else {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            if (this.futures.size() > 0) {
                Iterator<Future<Position2FloatMap>> iterator = this.futures.iterator();
                float threshold = this.threshold[0];
                while (iterator.hasNext()) {
                    Future<Position2FloatMap> future = iterator.next();
                    if (!future.isDone()) continue;
                    try {
                        Position2FloatMap map = future.get();
                        if (map != null) {
                            map.forEachEntry((x, y, z, v) -> {
                                float newValue = this.weights.add(x, y, z, v);
                                if (newValue >= threshold && newValue - v < threshold && !level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z)).method_26215()) {
                                    this.chunkedBlockRegion.addBlock(x, y, z, AIR);
                                    ChunkRenderOverrider.INSTANCE.setBlock(x, y, z, AIR);
                                    this.removeRegion.add(x, y, z);
                                }
                            });
                        }
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                    iterator.remove();
                }
            }
            this.updateTool();
            float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
            this.chunkedBlockRegion.render(camera, class_243.field_1353, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
            this.removeRegion.render(camera, class_243.field_1353, matrices, projection, time, 8);
        }
    }

    private void updateTool() {
        this.pathProvider.update();
        this.addInputsToTool();
    }

    private void addInputsToTool() {
        if (!this.inputSet.isEmpty()) {
            PositionSet input = this.inputSet;
            this.inputSet = new PositionSet();
            Future future = Tool.sharedPoolThreadExecutor.submit(() -> this.updateToolTask(input, new ConcurrentLevelPredicateSet(this.blocksMotionPredicateSet), this.blurTable));
            this.futures.add(future);
        }
    }

    protected Position2FloatMap updateToolTask(PositionSet input, ConcurrentLevelPredicateSet blocksMotionPredicateSet, GaussianBlurTable blurTable) {
        float[] table = blurTable.getTable();
        int radius = table.length / 2;
        if (radius == 0) {
            throw new FaultyImplementationError();
        }
        MaskElement maskElement = MaskManager.getDestMask();
        MaskContext maskContext = new MaskContext((class_1937)class_310.method_1551().field_1687);
        Position2FloatMap smoothedX = new Position2FloatMap();
        input.forEach((x, y, z) -> {
            if (!blocksMotionPredicateSet.contains(x, y, z)) {
                for (int i = -radius; i <= radius; ++i) {
                    smoothedX.add(x + i, y, z, table[i + radius]);
                }
            }
        });
        Position2FloatMap smoothedZ = new Position2FloatMap();
        smoothedX.forEachEntry((x, y, z, v) -> {
            for (int i = -radius; i <= radius; ++i) {
                smoothedZ.add(x, y, z + i, v * table[i + radius]);
            }
        });
        Position2FloatMap output = new Position2FloatMap();
        smoothedZ.forEachEntry((x, y, z, v) -> {
            for (int i = -radius; i <= radius; ++i) {
                maskContext.reset();
                if (!maskElement.test(maskContext, x, y + i, z)) continue;
                output.add(x, y + i, z, v * table[i + radius]);
            }
        });
        return output;
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
        boolean changed = this.brushWidget.displayImgui();
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.smoothing_options"));
        changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.weld.strength"), this.blurStddev, 0.75f, 10.0f, "%.2f", 32);
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.presets"));
        this.presetWidget.displayImgui(changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.weld.threshold"), this.threshold, 0.01f, 1.0f, "%.2f", 32));
    }

    @Override
    public String listenForEsc() {
        if (!this.usingTool) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.cancel");
    }

    @Override
    public boolean initiateAdjustment() {
        return this.brushWidget.initiateAdjustment();
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        return this.brushWidget.renderAdjustment(mouseX, mouseY, mouseDelta);
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.melt");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        tag.method_10582("SourceName", "Melt Tool");
        if (includeSettings) {
            class_2487 settings = new class_2487();
            this.writeSettings(settings);
            tag.method_10566("SourceSettings", (class_2520)settings);
        }
    }

    @Override
    public void writeSettings(class_2487 tag) {
        this.brushWidget.writeSettings(tag);
        tag.method_10548("SmoothStrength", this.blurStddev[0]);
        tag.method_10548("SmoothThreshold", this.threshold[0]);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.brushWidget.loadSettings(tag);
        this.blurStddev[0] = VersionUtilsNbt.helperCompoundTagGetFloatOr(tag, "SmoothStrength", 2.0f);
        this.threshold[0] = VersionUtilsNbt.helperCompoundTagGetFloatOr(tag, "SmoothThreshold", 0.1f);
    }

    @Override
    public boolean showToolSmoothing() {
        return true;
    }

    @Override
    public char iconChar() {
        return '\ue90c';
    }

    @Override
    public String keybindId() {
        return "melt";
    }

    @Override
    public int defaultKeybind() {
        return 75;
    }
}

