/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.VersionUtilsClient;
import com.moulberry.axiom.core_rendering.AxiomGpuTexture;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.StringProperty;
import com.moulberry.axiom.displayentity.DisplayEntityObject;
import com.moulberry.axiom.displayentity.ItemList;
import com.moulberry.axiom.editor.BlockList;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.render.BlockRenderCache;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.utils.ColourUtils;
import com.moulberry.axiom.utils.IntWrapper;
import com.moulberry.axiom.utils.ItemStackDataHelper;
import com.moulberry.axiom.utils.StringUtils;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1661;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4590;
import net.minecraft.class_465;
import net.minecraft.class_5676;
import net.minecraft.class_746;
import net.minecraft.class_7529;
import net.minecraft.class_8016;
import net.minecraft.class_8104;
import net.minecraft.class_811;
import net.minecraft.class_8113;
import net.minecraft.class_8130;
import org.apache.commons.lang3.text.WordUtils;
import org.joml.Matrix4f;

public class CreateDisplayEntityScreen
extends class_437 {
    private static final class_2960 SCROLLER_SPRITE = class_2960.method_60654((String)"container/creative_inventory/scroller");
    private static final class_2960 SCROLLER_DISABLED_SPRITE = class_2960.method_60654((String)"container/creative_inventory/scroller_disabled");
    private static final class_2960[] UNSELECTED_TOP_TABS = new class_2960[]{class_2960.method_60654((String)"container/creative_inventory/tab_top_unselected_1"), class_2960.method_60654((String)"container/creative_inventory/tab_top_unselected_2"), class_2960.method_60654((String)"container/creative_inventory/tab_top_unselected_3")};
    private static final class_2960[] SELECTED_TOP_TABS = new class_2960[]{class_2960.method_60654((String)"container/creative_inventory/tab_top_selected_1"), class_2960.method_60654((String)"container/creative_inventory/tab_top_selected_2"), class_2960.method_60654((String)"container/creative_inventory/tab_top_selected_3")};
    private static final class_2960 BACKGROUND = class_2960.method_60654((String)"axiom:background");
    private static final class_2960 SELECT_ITEM = class_2960.method_60654((String)"axiom:select_item");
    private static final class_2960 SELECT_BLOCK = class_2960.method_60654((String)"axiom:select_block");
    private static final class_2960 FILTER_OFF = class_2960.method_60654((String)"axiom:filter_off");
    private static final class_2960 SLOT = class_2960.method_60654((String)"axiom:slot");
    private static final int SCREEN_TYPE_ITEM = 0;
    private static final int SCREEN_TYPE_BLOCK = 1;
    private static final int SCREEN_TYPE_TEXT = 2;
    private static final int SCREEN_TYPE_SELECT_ITEM = 3;
    private static final int SCREEN_TYPE_SELECT_BLOCK = 4;
    private static final int SCREEN_TYPE_ADDITIONAL = 5;
    private int lastScreenType = 0;
    private int screenType = 0;
    private static final int HOVERED_ITEM_SLOT = 0;
    private static final int HOVERED_FILTER_CUSTOMMODELDATA_ITEMS = 1;
    private static final int HOVERED_SCROLLER = 2;
    private static final int HOVERED_ITEM_DISPLAY_TAB = 3;
    private static final int HOVERED_BLOCK_DISPLAY_TAB = 4;
    private static final int HOVERED_TEXT_DISPLAY_TAB = 5;
    private static final int HOVERED_BLOCK_SLOT = 6;
    private int hovered = -1;
    private class_342 searchBox = null;
    private float scrollOffset = 0.0f;
    private boolean scrolling = false;
    private boolean onlyCustomItems = false;
    private int leftPos;
    private int topPos;
    private int menuWidth;
    private int menuHeight;
    private class_1799 item = new class_1799((class_1935)class_1802.field_20391);
    private class_811 itemDisplayContext = class_811.field_4315;
    private CustomBlockState blockState = (CustomBlockState)class_2246.field_10340.method_9564();
    private class_8113.class_8123.class_8124 textAlignment = class_8113.class_8123.class_8124.field_42450;
    private String jsonText = "";
    private boolean defaultBackground = false;
    private int backgroundColour = 0x40000000;
    private int lineWidth = 200;
    private boolean seeThrough = false;
    private boolean shadow = false;
    private int textOpacity = 255;
    private class_8113.class_8114 billboardConstraints = class_8113.class_8114.field_42406;
    private class_4590 defaultItemDisplayTransformation = null;
    private class_8104 defaultItemDisplayBrightness = null;
    private boolean overrideBrightness = false;
    private int overrideBrightnessBlock = 0;
    private int overrideBrightnessSky = 0;
    private int glowColourOverride = -1;
    private float displayEntityHeight = 0.0f;
    private float displayEntityWidth = 0.0f;
    private int interpolationDuration = 0;
    private int teleportDuration = 0;
    private float shadowRadius = 0.0f;
    private float shadowStrength = 1.0f;
    private float viewRange = 1.0f;
    private boolean canSwitchType;
    private Consumer<DisplayEntityObject> callback;
    private boolean callbackOnClose;
    private static final class_811[] REORDERED_ITEM_DISPLAY_CONTEXT = new class_811[]{class_811.field_4315, class_811.field_4316, class_811.field_4317, class_811.field_4318, class_811.field_4319, class_811.field_4323, class_811.field_4320, class_811.field_4321, class_811.field_4322};
    private static final class_1799[] TAB_ITEM_STACKS = new class_1799[]{new class_1799((class_1935)class_1802.field_8143), new class_1799((class_1935)class_1802.field_20391), new class_1799((class_1935)class_1802.field_8674)};

    public CreateDisplayEntityScreen(DisplayEntityObject editing, Consumer<DisplayEntityObject> callback, boolean callbackOnClose) {
        super((class_2561)class_2561.method_43470((String)"Create Display Entity"));
        this.callbackOnClose = callbackOnClose;
        if (editing == null) {
            this.canSwitchType = true;
        } else {
            DisplayEntityObject.GenericDisplayEntityData genericData = editing.genericDisplayEntityData();
            this.billboardConstraints = genericData.billboardConstraints();
            this.overrideBrightness = genericData.overrideBrightness();
            this.overrideBrightnessBlock = genericData.overrideBrightnessBlock();
            this.overrideBrightnessSky = genericData.overrideBrightnessSky();
            this.glowColourOverride = genericData.glowColorOverride();
            this.displayEntityHeight = genericData.height();
            this.displayEntityWidth = genericData.width();
            this.interpolationDuration = genericData.interpolationDuration();
            this.teleportDuration = genericData.teleportDuration();
            this.shadowRadius = genericData.shadowRadius();
            this.shadowStrength = genericData.shadowStrength();
            this.viewRange = genericData.viewRange();
            if (editing instanceof DisplayEntityObject.DisplayEntityItemObject) {
                DisplayEntityObject.DisplayEntityItemObject displayEntityItemObject = (DisplayEntityObject.DisplayEntityItemObject)editing;
                this.canSwitchType = false;
                this.lastScreenType = 0;
                this.screenType = 0;
                this.item = displayEntityItemObject.itemStack().method_7972();
                this.itemDisplayContext = displayEntityItemObject.itemDisplayContext();
            } else if (editing instanceof DisplayEntityObject.DisplayEntityBlockObject) {
                DisplayEntityObject.DisplayEntityBlockObject displayEntityBlockObject = (DisplayEntityObject.DisplayEntityBlockObject)editing;
                this.canSwitchType = false;
                this.lastScreenType = 1;
                this.screenType = 1;
                this.blockState = (CustomBlockState)displayEntityBlockObject.blockState();
            } else if (editing instanceof DisplayEntityObject.DisplayEntityTextObject) {
                DisplayEntityObject.DisplayEntityTextObject displayEntityTextObject = (DisplayEntityObject.DisplayEntityTextObject)editing;
                this.canSwitchType = false;
                this.lastScreenType = 2;
                this.screenType = 2;
                this.textAlignment = displayEntityTextObject.alignment();
                this.jsonText = displayEntityTextObject.text();
                this.defaultBackground = displayEntityTextObject.defaultBackground();
                this.backgroundColour = displayEntityTextObject.background();
                this.lineWidth = displayEntityTextObject.lineWidth();
                this.seeThrough = displayEntityTextObject.seeThrough();
                this.shadow = displayEntityTextObject.shadow();
                this.textOpacity = displayEntityTextObject.textOpacity();
            } else {
                throw new FaultyImplementationError();
            }
        }
        this.callback = callback;
    }

    protected void method_25426() {
        super.method_25426();
        this.searchBox = null;
        this.method_37067();
        switch (this.screenType) {
            default: {
                this.initItem();
                break;
            }
            case 1: {
                this.initBlock();
                break;
            }
            case 2: {
                this.initText();
                break;
            }
            case 3: {
                this.initSelectItem();
                break;
            }
            case 4: {
                this.initSelectBlock();
                break;
            }
            case 5: {
                this.initAdditional();
            }
        }
    }

    private void initItem() {
        boolean hasDyeOptions = ItemStackDataHelper.canBeDyed(this.item);
        this.menuWidth = 195;
        this.menuHeight = 124;
        if (hasDyeOptions) {
            this.menuHeight += 32;
            this.menuHeight += (class_1767.values().length + 3) / 4 * 22;
        }
        this.leftPos = (this.field_22789 - this.menuWidth) / 2;
        this.topPos = (this.field_22790 - this.menuHeight) / 2;
        int y = this.topPos + 36;
        this.method_37063((class_364)class_5676.method_32606(CreateDisplayEntityScreen::toComponent).method_32624((Object[])REORDERED_ITEM_DISPLAY_CONTEXT).method_32619((Object)this.itemDisplayContext).method_32617(this.leftPos + 8, y, 179, 20, (class_2561)class_2561.method_43470((String)"Item Display"), (button, value) -> {
            this.itemDisplayContext = value;
        }));
        if (hasDyeOptions) {
            this.method_37063((class_364)new BasicStringWidget(this.leftPos + 9, (y += 22) + 1, 0, 0, (class_2561)class_2561.method_43470((String)"Dye Color").method_27696(class_2583.field_24360.method_36139(0x404040)), this.field_22793));
            class_342 colourEditBox = new class_342(this.field_22793, this.leftPos + 8, y += 10, 179, 20, (class_2561)class_2561.method_43470((String)"Dye Color"));
            colourEditBox.method_1852(String.format("%06x", ItemStackDataHelper.getDyeColor(this.item) & 0xFFFFFF));
            colourEditBox.method_1863(string -> {
                try {
                    int newDyedColour = (int)(Long.parseLong(string, 16) & 0xFFFFFFL);
                    ItemStackDataHelper.setDyeColor(this.item, newDyedColour);
                    colourEditBox.method_1868(-1);
                }
                catch (Exception e) {
                    colourEditBox.method_1868(-65536);
                }
            });
            this.method_37063((class_364)colourEditBox);
            int index = 0;
            for (class_1767 dyeColor : class_1767.values()) {
                int xIndex = index % 4;
                if (xIndex == 0) {
                    y += 22;
                }
                int x = this.leftPos + 8 + 45 * xIndex;
                String name = dyeColor.method_7792().replace("_", " ");
                name = WordUtils.capitalizeFully((String)name);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)name), a -> {
                    int rgb = dyeColor.method_7787();
                    colourEditBox.method_1852(String.format("%06x", rgb & 0xFFFFFF));
                    colourEditBox.method_1868(-1);
                    ItemStackDataHelper.setDyeColor(this.item, rgb);
                }).method_46434(x, y, 43, 20).method_46431());
                ++index;
            }
        }
        this.initGenericEnd(y, 179);
    }

    private void initBlock() {
        this.menuWidth = 195;
        this.menuHeight = 102 + this.blockState.getProperties().size() * 22;
        this.leftPos = (this.field_22789 - this.menuWidth) / 2;
        this.topPos = (this.field_22790 - this.menuHeight) / 2;
        int y = this.topPos + 14;
        for (final class_2769<?> property : this.blockState.getProperties()) {
            y += 22;
            Object propertyValue = this.blockState.getProperty(property);
            final String propertyName = StringUtils.convertSnakeToWords(property.method_11899());
            if (property instanceof class_2754) {
                class_2754 enumProperty = (class_2754)property;
                List values = enumProperty.method_11898();
                this.method_37063((class_364)class_5676.method_32606(CreateDisplayEntityScreen::enumToComponent).method_32624(values.toArray(new Object[0])).method_32619(propertyValue).method_32617(this.leftPos + 8, y, 179, 20, (class_2561)class_2561.method_43470((String)propertyName), (button, value) -> {
                    this.blockState = this.blockState.setPropertyUnsafe(property, (Comparable)value);
                }));
                continue;
            }
            if (property instanceof StringProperty) {
                StringProperty stringProperty = (StringProperty)property;
                List<String> values = stringProperty.method_11898();
                this.method_37063((class_364)class_5676.method_32606(CreateDisplayEntityScreen::stringToComponent).method_32624((Object[])values.toArray(new String[0])).method_32619((Object)((String)propertyValue)).method_32617(this.leftPos + 8, y, 179, 20, (class_2561)class_2561.method_43470((String)propertyName), (button, value) -> {
                    this.blockState = this.blockState.setPropertyUnsafe(property, (Comparable<?>)((Object)value));
                }));
                continue;
            }
            if (property instanceof class_2758) {
                class_2758 integerProperty = (class_2758)property;
                final int min2 = integerProperty.field_37655;
                final int max2 = integerProperty.field_37656;
                final IntWrapper current = new IntWrapper((Integer)propertyValue);
                this.method_37063((class_364)new class_357(this.leftPos + 8, y, 179, 20, (class_2561)class_2561.method_43470((String)(propertyName + ": " + current.value)), (float)(current.value - min2) / (float)(max2 - min2)){

                    protected void method_25346() {
                        this.method_25355((class_2561)class_2561.method_43470((String)(propertyName + ": " + current.value)));
                    }

                    protected void method_25344() {
                        current.value = (int)(this.field_22753 * (double)(max2 - min2) + (double)min2);
                        CreateDisplayEntityScreen.this.blockState = CreateDisplayEntityScreen.this.blockState.setPropertyUnsafe(property, Integer.valueOf(current.value));
                    }
                });
                continue;
            }
            if (!(property instanceof class_2746)) continue;
            this.method_37063((class_364)class_5676.method_32606(CreateDisplayEntityScreen::booleanToComponent).method_32624((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}).method_32619((Object)((Boolean)propertyValue)).method_32617(this.leftPos + 8, y, 179, 20, (class_2561)class_2561.method_43470((String)propertyName), (button, value) -> {
                this.blockState = this.blockState.setPropertyUnsafe(property, (Comparable<?>)value);
            }));
        }
        this.initGenericEnd(y, 179);
    }

    private void initText() {
        this.menuWidth = 320;
        this.menuHeight = 198;
        this.leftPos = (this.field_22789 - this.menuWidth) / 2;
        this.topPos = (this.field_22790 - this.menuHeight) / 2;
        int itemWidth = 150;
        class_7529 textEditBox = new class_7529(this.field_22793, this.leftPos + 8, this.topPos + 19, itemWidth, 110, (class_2561)class_2561.method_43470((String)"Text"), (class_2561)class_2561.method_43470((String)"Text"));
        textEditBox.method_44400(this.jsonText);
        textEditBox.method_44401(string -> {
            this.jsonText = string;
        });
        this.method_37063((class_364)textEditBox);
        int x = this.leftPos + 8 + 160 - 6;
        int y = this.topPos + 19;
        this.method_37063((class_364)new BasicStringWidget(x + 1, y + 1, 0, 0, (class_2561)class_2561.method_43470((String)"Background Color").method_27696(class_2583.field_24360.method_36139(0x404040)), this.field_22793));
        this.method_37063((class_364)class_5676.method_32613((boolean)this.defaultBackground).method_32617(x, y += 10, itemWidth, 20, (class_2561)class_2561.method_43470((String)"Default Background"), (button, bool) -> {
            this.defaultBackground = bool;
            this.method_25426();
        }));
        if (!this.defaultBackground) {
            class_342 backgroundColourEditBox = new class_342(this.field_22793, x, y += 20, itemWidth, 20, (class_2561)class_2561.method_43470((String)"Background Color"));
            backgroundColourEditBox.method_1852(ColourUtils.formatHex(this.backgroundColour));
            backgroundColourEditBox.method_1863(string -> {
                try {
                    this.backgroundColour = (int)Long.parseLong(string, 16);
                    backgroundColourEditBox.method_1868(-1);
                }
                catch (Exception e) {
                    this.backgroundColour = 0x40000000;
                    backgroundColourEditBox.method_1868(-65536);
                }
            });
            this.method_37063((class_364)backgroundColourEditBox);
        }
        this.method_37063((class_364)new BasicStringWidget(x + 1, (y += 22) + 1, 0, 0, (class_2561)class_2561.method_43470((String)"Line Width").method_27696(class_2583.field_24360.method_36139(0x404040)), this.field_22793));
        class_342 lineWidthEditBox = new class_342(this.field_22793, x, y += 10, itemWidth, 20, (class_2561)class_2561.method_43470((String)"Line Width"));
        lineWidthEditBox.method_1852(Long.toString((long)this.lineWidth & 0xFFFFFFFFL));
        lineWidthEditBox.method_1863(string -> {
            try {
                this.lineWidth = (int)Long.parseLong(string);
                lineWidthEditBox.method_1868(-1);
            }
            catch (Exception e) {
                this.lineWidth = 200;
                lineWidthEditBox.method_1868(-65536);
            }
        });
        this.method_37063((class_364)lineWidthEditBox);
        class_5676 alignmentButton = class_5676.method_32606(CreateDisplayEntityScreen::toComponent).method_32624((Object[])class_8113.class_8123.class_8124.values()).method_32619((Object)this.textAlignment).method_32617(x, y += 22, itemWidth, 20, (class_2561)class_2561.method_43470((String)"Alignment"), (button, value) -> {
            this.textAlignment = value;
        });
        this.method_37063((class_364)alignmentButton);
        this.method_37063((class_364)class_5676.method_32613((boolean)this.seeThrough).method_32617(x, y += 22, itemWidth, 20, (class_2561)class_2561.method_43470((String)"See Through"), (button, bool) -> {
            this.seeThrough = bool;
        }));
        this.method_37063((class_364)class_5676.method_32613((boolean)this.shadow).method_32617(x, y += 22, itemWidth, 20, (class_2561)class_2561.method_43470((String)"Shadow"), (button, bool) -> {
            this.shadow = bool;
        }));
        this.method_37063((class_364)new class_357(x, y += 22, itemWidth, 20, (class_2561)class_2561.method_43470((String)("Text Opacity: " + this.textOpacity)), (float)this.textOpacity / 255.0f){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43470((String)("Text Opacity: " + CreateDisplayEntityScreen.this.textOpacity)));
            }

            protected void method_25344() {
                CreateDisplayEntityScreen.this.textOpacity = class_3532.method_15340((int)((int)(this.field_22753 * 255.0)), (int)0, (int)255);
            }
        });
        this.initGenericEnd(y -= 60, itemWidth);
    }

    private void initGenericEnd(int y, int width) {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Additional Settings"), button -> {
            this.lastScreenType = this.screenType;
            this.screenType = 5;
            this.method_25426();
        }).method_46434(this.leftPos + 8, y += 30, width, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), button -> class_310.method_1551().method_1507(null)).method_46434(this.leftPos + 8, y += 30, (width - 1) / 2, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), button -> {
            class_310.method_1551().method_1507(null);
            this.callback.accept(this.createDisplayEntityObject());
        }).method_46434(this.leftPos + 8 + (width + 1) / 2, y, (width - 1) / 2, 20).method_46431());
    }

    private DisplayEntityObject createDisplayEntityObject() {
        DisplayEntityObject.GenericDisplayEntityData genericDisplayEntityData = new DisplayEntityObject.GenericDisplayEntityData(this.displayEntityWidth, this.displayEntityHeight, this.interpolationDuration, this.teleportDuration, this.glowColourOverride, this.billboardConstraints, this.overrideBrightness, this.overrideBrightnessBlock, this.overrideBrightnessSky, this.shadowRadius, this.shadowStrength, this.viewRange);
        if (this.screenType == 0) {
            return new DisplayEntityObject.DisplayEntityItemObject(this.item, this.itemDisplayContext, genericDisplayEntityData, this.defaultItemDisplayTransformation, this.defaultItemDisplayBrightness);
        }
        if (this.screenType == 1) {
            return new DisplayEntityObject.DisplayEntityBlockObject(this.blockState.getVanillaState(), genericDisplayEntityData);
        }
        if (this.screenType == 2) {
            return new DisplayEntityObject.DisplayEntityTextObject(this.jsonText, this.defaultBackground, this.backgroundColour, this.lineWidth, this.textAlignment, this.seeThrough, this.shadow, this.textOpacity, genericDisplayEntityData);
        }
        return null;
    }

    private void initSelectItem() {
        this.menuWidth = 195;
        this.menuHeight = 151;
        this.leftPos = (this.field_22789 - this.menuWidth) / 2;
        this.topPos = (this.field_22790 - this.menuHeight) / 2;
        ItemList.INSTANCE.search("", this.onlyCustomItems);
        Objects.requireNonNull(this.field_22793);
        this.searchBox = new class_342(this.field_22793, this.leftPos + 82, this.topPos + 6, 80, 9, (class_2561)class_2561.method_43471((String)"itemGroup.search"));
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(false);
        this.searchBox.method_1868(0xFFFFFF);
        this.searchBox.method_1862(true);
        this.searchBox.method_1856(false);
        this.searchBox.method_25365(true);
        this.method_25429((class_364)this.searchBox);
    }

    private void initSelectBlock() {
        this.menuWidth = 195;
        this.menuHeight = 136;
        this.leftPos = (this.field_22789 - this.menuWidth) / 2;
        this.topPos = (this.field_22790 - this.menuHeight) / 2;
        EditorUI.getBlockList().search("");
        Objects.requireNonNull(this.field_22793);
        this.searchBox = new class_342(this.field_22793, this.leftPos + 87, this.topPos + 6, 75, 9, (class_2561)class_2561.method_43471((String)"itemGroup.search"));
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(false);
        this.searchBox.method_1868(0xFFFFFF);
        this.searchBox.method_1862(true);
        this.searchBox.method_1856(false);
        this.searchBox.method_25365(true);
        this.method_25429((class_364)this.searchBox);
    }

    public boolean method_25400(char c, int i) {
        if (this.searchBox != null) {
            String string = this.searchBox.method_1882();
            if (this.searchBox.method_25400(c, i)) {
                if (!Objects.equals(string, this.searchBox.method_1882())) {
                    if (this.screenType == 3) {
                        ItemList.INSTANCE.search(this.searchBox.method_1882(), this.onlyCustomItems);
                    } else {
                        EditorUI.getBlockList().search(this.searchBox.method_1882());
                    }
                }
                return true;
            }
        }
        return super.method_25400(c, i);
    }

    public boolean method_25404(int i, int j, int k) {
        if (this.searchBox != null) {
            String string = this.searchBox.method_1882();
            if (this.searchBox.method_25404(i, j, k)) {
                if (!Objects.equals(string, this.searchBox.method_1882())) {
                    if (this.screenType == 3) {
                        ItemList.INSTANCE.search(this.searchBox.method_1882(), this.onlyCustomItems);
                    } else {
                        EditorUI.getBlockList().search(this.searchBox.method_1882());
                    }
                }
                return true;
            }
            if (this.searchBox.method_25370() && this.searchBox.method_1885() && i != 256) {
                return true;
            }
        }
        return super.method_25404(i, j, k);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.screenType == 3) {
            int rows = (int)Math.ceil((float)ItemList.INSTANCE.getItems().size() / 9.0f) - 5;
            this.scrollOffset = class_3532.method_15363((float)(this.scrollOffset - (float)(scrollY / (double)rows)), (float)0.0f, (float)1.0f);
        } else if (this.screenType == 4) {
            int rows = (int)Math.ceil((float)EditorUI.getBlockList().getBlocks().size() / 9.0f) - 5;
            this.scrollOffset = class_3532.method_15363((float)(this.scrollOffset - (float)(scrollY / (double)rows)), (float)0.0f, (float)1.0f);
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    private void initAdditional() {
        this.menuWidth = 320;
        this.menuHeight = 194;
        this.leftPos = (this.field_22789 - this.menuWidth) / 2;
        this.topPos = (this.field_22790 - this.menuHeight) / 2;
        int itemWidth = 150;
        int x = this.leftPos + 8;
        int y = this.topPos + 6;
        this.method_37063((class_364)new BasicStringWidget(x + 1, y + 1, 0, 0, (class_2561)class_2561.method_43470((String)"Culling Width").method_27696(class_2583.field_24360.method_36139(0x404040)), this.field_22793));
        class_342 widthEditBox = new class_342(this.field_22793, x, y += 10, itemWidth, 20, (class_2561)class_2561.method_43470((String)"Culling Width"));
        widthEditBox.method_1852(String.format(Locale.ROOT, "%.2f", Float.valueOf(this.displayEntityWidth)));
        widthEditBox.method_1863(string -> {
            try {
                this.displayEntityWidth = Float.parseFloat(string);
                widthEditBox.method_1868(-1);
            }
            catch (Exception e) {
                this.displayEntityWidth = 0.0f;
                widthEditBox.method_1868(-65536);
            }
        });
        this.method_37063((class_364)widthEditBox);
        this.method_37063((class_364)new BasicStringWidget(x + 1, (y += 22) + 1, 0, 0, (class_2561)class_2561.method_43470((String)"Culling Height").method_27696(class_2583.field_24360.method_36139(0x404040)), this.field_22793));
        class_342 heightEditBox = new class_342(this.field_22793, x, y += 10, itemWidth, 20, (class_2561)class_2561.method_43470((String)"Culling Height"));
        heightEditBox.method_1852(String.format(Locale.ROOT, "%.2f", Float.valueOf(this.displayEntityHeight)));
        heightEditBox.method_1863(string -> {
            try {
                this.displayEntityHeight = Float.parseFloat(string);
                heightEditBox.method_1868(-1);
            }
            catch (Exception e) {
                this.displayEntityHeight = 0.0f;
                heightEditBox.method_1868(-65536);
            }
        });
        this.method_37063((class_364)heightEditBox);
        this.method_37063((class_364)new BasicStringWidget(x + 1, (y += 22) + 1, 0, 0, (class_2561)class_2561.method_43470((String)"Interpolation Ticks").method_27696(class_2583.field_24360.method_36139(0x404040)), this.field_22793));
        class_342 interpolationDurationEditBox = new class_342(this.field_22793, x, y += 10, itemWidth, 20, (class_2561)class_2561.method_43470((String)"Interpolation Ticks"));
        interpolationDurationEditBox.method_1852(Long.toString((long)this.interpolationDuration & 0xFFFFFFFFL));
        interpolationDurationEditBox.method_1863(string -> {
            try {
                this.interpolationDuration = (int)Long.parseLong(string);
                interpolationDurationEditBox.method_1868(-1);
            }
            catch (Exception e) {
                this.interpolationDuration = 0;
                interpolationDurationEditBox.method_1868(-65536);
            }
        });
        this.method_37063((class_364)interpolationDurationEditBox);
        this.method_37063((class_364)new BasicStringWidget(x + 1, (y += 22) + 1, 0, 0, (class_2561)class_2561.method_43470((String)"Teleport Ticks").method_27696(class_2583.field_24360.method_36139(0x404040)), this.field_22793));
        class_342 teleportDurationEditBox = new class_342(this.field_22793, x, y += 10, itemWidth, 20, (class_2561)class_2561.method_43470((String)"Teleport Ticks"));
        teleportDurationEditBox.method_1852(Long.toString((long)this.teleportDuration & 0xFFFFFFFFL));
        teleportDurationEditBox.method_1863(string -> {
            try {
                this.teleportDuration = (int)Long.parseLong(string);
                teleportDurationEditBox.method_1868(-1);
            }
            catch (Exception e) {
                this.teleportDuration = 0;
                teleportDurationEditBox.method_1868(-65536);
            }
        });
        this.method_37063((class_364)teleportDurationEditBox);
        this.method_37063((class_364)new BasicStringWidget(x + 1, (y += 22) + 1, 0, 0, (class_2561)class_2561.method_43470((String)"Glow Color Override").method_27696(class_2583.field_24360.method_36139(0x404040)), this.field_22793));
        class_342 glowColorOverrideEditBox = new class_342(this.field_22793, x, y += 10, itemWidth, 20, (class_2561)class_2561.method_43470((String)"Glow Color Override"));
        glowColorOverrideEditBox.method_1852(ColourUtils.formatHex(this.glowColourOverride));
        glowColorOverrideEditBox.method_1863(string -> {
            try {
                this.glowColourOverride = (int)Long.parseLong(string, 16);
                glowColorOverrideEditBox.method_1868(-1);
            }
            catch (Exception e) {
                this.glowColourOverride = 0;
                glowColorOverrideEditBox.method_1868(-65536);
            }
        });
        this.method_37063((class_364)glowColorOverrideEditBox);
        x = this.leftPos + 8 + 160 - 6;
        y = this.topPos + 8;
        class_5676 billboardButton = class_5676.method_32606(CreateDisplayEntityScreen::toComponent).method_32624((Object[])class_8113.class_8114.values()).method_32619((Object)this.billboardConstraints).method_32617(x, y, itemWidth, 20, (class_2561)class_2561.method_43470((String)"Billboard"), (button, value) -> {
            this.billboardConstraints = value;
        });
        this.method_37063((class_364)billboardButton);
        this.method_37063((class_364)class_5676.method_32613((boolean)this.overrideBrightness).method_32617(x, y += 22, itemWidth, 20, (class_2561)class_2561.method_43470((String)"Override Brightness"), (button, bool) -> {
            this.overrideBrightness = bool;
            this.method_25426();
        }));
        if (this.overrideBrightness) {
            this.method_37063((class_364)new class_357(x, y += 19, itemWidth, 20, (class_2561)class_2561.method_43470((String)("Block Brightness: " + this.overrideBrightnessBlock)), (float)this.overrideBrightnessBlock / 15.0f){

                protected void method_25346() {
                    this.method_25355((class_2561)class_2561.method_43470((String)("Block Brightness: " + CreateDisplayEntityScreen.this.overrideBrightnessBlock)));
                }

                protected void method_25344() {
                    CreateDisplayEntityScreen.this.overrideBrightnessBlock = class_3532.method_15340((int)((int)(this.field_22753 * 15.0)), (int)0, (int)15);
                }
            });
            this.method_37063((class_364)new class_357(x, y += 19, itemWidth, 20, (class_2561)class_2561.method_43470((String)("Sky Brightness: " + this.overrideBrightnessSky)), (float)this.overrideBrightnessSky / 15.0f){

                protected void method_25346() {
                    this.method_25355((class_2561)class_2561.method_43470((String)("Sky Brightness: " + CreateDisplayEntityScreen.this.overrideBrightnessSky)));
                }

                protected void method_25344() {
                    CreateDisplayEntityScreen.this.overrideBrightnessSky = class_3532.method_15340((int)((int)(this.field_22753 * 15.0)), (int)0, (int)15);
                }
            });
        }
        this.method_37063((class_364)new BasicStringWidget(x + 1, (y += 22) + 1, 0, 0, (class_2561)class_2561.method_43470((String)"Shadow Radius").method_27696(class_2583.field_24360.method_36139(0x404040)), this.field_22793));
        class_342 shadowRadiusEditBox = new class_342(this.field_22793, x, y += 10, itemWidth, 20, (class_2561)class_2561.method_43470((String)"Shadow Radius"));
        shadowRadiusEditBox.method_1852(String.format(Locale.ROOT, "%.2f", Float.valueOf(this.shadowRadius)));
        shadowRadiusEditBox.method_1863(string -> {
            try {
                this.shadowRadius = Float.parseFloat(string);
                shadowRadiusEditBox.method_1868(-1);
            }
            catch (Exception e) {
                this.shadowRadius = 0.0f;
                shadowRadiusEditBox.method_1868(-65536);
            }
        });
        this.method_37063((class_364)shadowRadiusEditBox);
        this.method_37063((class_364)new class_357(x, y += 22, itemWidth, 20, (class_2561)class_2561.method_43470((String)("Shadow Strength: " + String.format("%.2f", Float.valueOf(this.shadowStrength)))), this.shadowStrength / 2.0f){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43470((String)("Shadow Strength: " + String.format("%.2f", Float.valueOf(CreateDisplayEntityScreen.this.shadowStrength)))));
            }

            protected void method_25344() {
                CreateDisplayEntityScreen.this.shadowStrength = (float)this.field_22753 * 2.0f;
            }
        });
        this.method_37063((class_364)new class_357(x, y += 22, itemWidth, 20, (class_2561)class_2561.method_43470((String)("View Range: " + String.format("%.2f", Float.valueOf(this.viewRange)))), this.viewRange / 2.0f){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43470((String)("View Range: " + String.format("%.2f", Float.valueOf(CreateDisplayEntityScreen.this.viewRange)))));
            }

            protected void method_25344() {
                CreateDisplayEntityScreen.this.viewRange = (float)this.field_22753 * 2.0f;
            }
        });
        y += 22;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), button -> {
            this.screenType = this.lastScreenType;
            this.method_25426();
        }).method_46434(this.leftPos + 8, this.topPos + this.menuHeight - 28, this.menuWidth - 16, 20).method_46431());
    }

    private static class_2561 booleanToComponent(Boolean bool) {
        return class_2561.method_43470((String)bool.toString().toUpperCase(Locale.ROOT));
    }

    private static class_2561 stringToComponent(String string) {
        return class_2561.method_43470((String)string.toUpperCase(Locale.ROOT));
    }

    private static class_2561 enumToComponent(Object object) {
        return CreateDisplayEntityScreen.toComponent((class_3542)object);
    }

    public static class_2561 toComponent(class_3542 stringRepresentable) {
        return class_2561.method_43470((String)stringRepresentable.method_15434().toUpperCase(Locale.ROOT));
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        if (this.canSwitchType && (this.screenType == 0 || this.screenType == 1 || this.screenType == 2)) {
            for (int i = 0; i < 3; ++i) {
                if (i == this.screenType) continue;
                class_2960 resourceLocation = UNSELECTED_TOP_TABS[i];
                guiGraphics.method_52706(VersionUtilsClient.renderTypeGuiTextured(), resourceLocation, this.leftPos + 27 * i, this.topPos - 28, 26, 32);
            }
        }
        if (this.screenType == 3) {
            guiGraphics.method_52706(VersionUtilsClient.renderTypeGuiTextured(), SELECT_ITEM, this.leftPos, this.topPos, this.menuWidth, this.menuHeight);
        } else if (this.screenType == 4) {
            guiGraphics.method_52706(VersionUtilsClient.renderTypeGuiTextured(), SELECT_BLOCK, this.leftPos, this.topPos, this.menuWidth, this.menuHeight);
        } else {
            guiGraphics.method_52706(VersionUtilsClient.renderTypeGuiTextured(), BACKGROUND, this.leftPos, this.topPos, this.menuWidth, this.menuHeight);
        }
    }

    public void method_25419() {
        switch (this.screenType) {
            case 3: {
                this.screenType = 0;
                this.method_25426();
                break;
            }
            case 4: {
                this.screenType = 1;
                this.method_25426();
                break;
            }
            case 5: {
                this.screenType = this.lastScreenType;
                this.method_25426();
                break;
            }
            default: {
                super.method_25419();
                if (!this.callbackOnClose) break;
                this.callback.accept(this.createDisplayEntityObject());
            }
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        block28: {
            int y;
            block29: {
                block27: {
                    super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                    this.updateHovered(mouseX, mouseY);
                    if (this.searchBox != null) {
                        this.searchBox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                    }
                    if (this.canSwitchType && (this.screenType == 0 || this.screenType == 1 || this.screenType == 2)) {
                        for (int i = 0; i < 3; ++i) {
                            if (i == this.screenType) {
                                class_2960 resourceLocation = SELECTED_TOP_TABS[this.screenType];
                                guiGraphics.method_52706(VersionUtilsClient.renderTypeGuiTextured(), resourceLocation, this.leftPos + 27 * this.screenType, this.topPos - 28, 26, 32);
                            }
                            guiGraphics.method_51427(TAB_ITEM_STACKS[i], this.leftPos + 27 * i + 5, this.topPos - 28 + 8);
                        }
                        if (this.hovered == 3) {
                            guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)"Item Display"), mouseX, mouseY);
                        } else if (this.hovered == 4) {
                            guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)"Block Display"), mouseX, mouseY);
                        } else if (this.hovered == 5) {
                            guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)"Text Display"), mouseX, mouseY);
                        }
                    }
                    y = this.topPos + 6;
                    if (this.screenType != 0) break block27;
                    guiGraphics.method_51433(this.field_22793, "Item Display", this.leftPos + 8, y, 0x404040, false);
                    guiGraphics.method_52706(VersionUtilsClient.renderTypeGuiTextured(), SLOT, this.leftPos + 8, y += 11, 18, 18);
                    guiGraphics.method_51433(this.field_22793, "Item", this.leftPos + 28, y + 5, 0x404040, false);
                    guiGraphics.method_51427(this.item, this.leftPos + 9, y + 1);
                    if (this.hovered != 0) break block28;
                    int x = this.leftPos + 9;
                    guiGraphics.method_51740(class_1921.method_51785(), x, y + 1, x + 16, y + 1 + 16, -2130706433, -2130706433, 0);
                    break block28;
                }
                if (this.screenType != 1) break block29;
                guiGraphics.method_51433(this.field_22793, "Block Display", this.leftPos + 8, y, 0x404040, false);
                guiGraphics.method_52706(VersionUtilsClient.renderTypeGuiTextured(), SLOT, this.leftPos + 8, y += 11, 18, 18);
                guiGraphics.method_51433(this.field_22793, "Block", this.leftPos + 28, y + 5, 0x404040, false);
                double size = 16.0 * class_310.method_1551().method_22683().method_4495();
                AxiomGpuTexture img = BlockRenderCache.requestTexture(this.blockState, (int)Math.ceil(size), (int)Math.ceil(size), true);
                if (img != null) {
                    int left = this.leftPos + 9;
                    int top = y + 1;
                    RenderSystem.setShaderTexture((int)0, (int)img.glId());
                    Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
                    VertexConsumerProvider provider = VertexConsumerProvider.shared();
                    class_287 bufferBuilder = provider.begin(class_293.class_5596.field_27382, class_290.field_1585);
                    bufferBuilder.method_22918(matrix4f, (float)left, (float)top, 0.0f).method_22913(0.0f, 1.0f);
                    bufferBuilder.method_22918(matrix4f, (float)left, (float)(top + 16), 0.0f).method_22913(0.0f, 0.0f);
                    bufferBuilder.method_22918(matrix4f, (float)(left + 16), (float)(top + 16), 0.0f).method_22913(1.0f, 0.0f);
                    bufferBuilder.method_22918(matrix4f, (float)(left + 16), (float)top, 0.0f).method_22913(1.0f, 1.0f);
                    AxiomRenderPipelines.POSITION_TEX.render(provider.build());
                }
                if (this.hovered != 6) break block28;
                int x = this.leftPos + 9;
                guiGraphics.method_51740(class_1921.method_51785(), x, y + 1, x + 16, y + 1 + 16, -2130706433, -2130706433, 0);
                break block28;
            }
            if (this.screenType == 2) {
                guiGraphics.method_51433(this.field_22793, "Text Display", this.leftPos + 8, y, 0x404040, false);
                y += 11;
            } else if (this.screenType == 3) {
                int top;
                int left;
                class_1799 itemStack;
                guiGraphics.method_51433(this.field_22793, "Search Items", this.leftPos + 8, y, 0x404040, false);
                List<ItemList.Entry> items = ItemList.INSTANCE.getItems();
                int rows = (int)Math.ceil((float)items.size() / 9.0f) - 5;
                if (rows <= 0) {
                    this.scrollOffset = 0.0f;
                }
                class_2960 resourceLocation = rows > 0 ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE;
                guiGraphics.method_52706(VersionUtilsClient.renderTypeGuiTextured(), resourceLocation, this.leftPos + 175, this.topPos + 33 + (int)(95.0f * this.scrollOffset), 12, 15);
                y += 12;
                if (!this.onlyCustomItems) {
                    guiGraphics.method_52706(VersionUtilsClient.renderTypeGuiTextured(), FILTER_OFF, this.leftPos + 10, y, 13, 12);
                }
                guiGraphics.method_51433(this.field_22793, "Filter CustomModelData items", this.leftPos + 28, y += 2, 0x404040, false);
                int rowOffset = Math.round(this.scrollOffset * (float)rows);
                if (rowOffset < 0) {
                    rowOffset = 0;
                }
                for (int gridX = 0; gridX < 9; ++gridX) {
                    int index;
                    for (int gridY = 0; gridY < 5 && (index = gridX + gridY * 9 + rowOffset * 9) < items.size(); ++gridY) {
                        itemStack = items.get(index).itemStack();
                        left = this.leftPos + 9 + gridX * 18;
                        top = this.topPos + 33 + gridY * 18;
                        guiGraphics.method_51427(itemStack, left, top);
                        if (mouseX < left - 1 || mouseX >= left + 17 || mouseY < top - 1 || mouseY >= top + 17) continue;
                        guiGraphics.method_51740(class_1921.method_51785(), left, top, left + 16, top + 16, -2130706433, -2130706433, 0);
                        guiGraphics.method_64038(this.field_22793, class_465.method_25408((class_310)this.field_22787, (class_1799)itemStack), itemStack.method_32347(), mouseX, mouseY);
                    }
                }
                class_746 player = class_310.method_1551().field_1724;
                class_1661 inventory = player.method_31548();
                for (int invX = 0; invX < 9; ++invX) {
                    itemStack = inventory.method_5438(invX);
                    if (itemStack.method_7960()) continue;
                    left = this.leftPos + 9 + invX * 18;
                    top = this.topPos + 127;
                    guiGraphics.method_51427(itemStack, left, top);
                    if (mouseX < left - 1 || mouseX >= left + 17 || mouseY < top - 1 || mouseY >= top + 17) continue;
                    guiGraphics.method_64038(this.field_22793, class_465.method_25408((class_310)this.field_22787, (class_1799)itemStack), itemStack.method_32347(), mouseX, mouseY);
                }
            } else if (this.screenType == 4) {
                int top;
                int left;
                guiGraphics.method_51433(this.field_22793, "Search Blocks", this.leftPos + 8, y, 0x404040, false);
                List<BlockList.Entry> blocks = EditorUI.getBlockList().getBlocks();
                int rows = (int)Math.ceil((float)blocks.size() / 9.0f) - 5;
                if (rows <= 0) {
                    this.scrollOffset = 0.0f;
                }
                class_2960 resourceLocation = rows > 0 ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE;
                guiGraphics.method_52706(VersionUtilsClient.renderTypeGuiTextured(), resourceLocation, this.leftPos + 175, this.topPos + 18 + (int)(95.0f * this.scrollOffset), 12, 15);
                int rowOffset = Math.round(this.scrollOffset * (float)rows);
                if (rowOffset < 0) {
                    rowOffset = 0;
                }
                for (int gridX = 0; gridX < 9; ++gridX) {
                    int index;
                    for (int gridY = 0; gridY < 5 && (index = gridX + gridY * 9 + rowOffset * 9) < blocks.size(); ++gridY) {
                        CustomBlockState customBlockState = blocks.get(index).state();
                        left = this.leftPos + 9 + gridX * 18;
                        top = this.topPos + 18 + gridY * 18;
                        double size = 16.0 * class_310.method_1551().method_22683().method_4495();
                        AxiomGpuTexture img = BlockRenderCache.requestTexture(customBlockState, (int)Math.ceil(size), (int)Math.ceil(size), false);
                        if (img != null) {
                            RenderSystem.setShaderTexture((int)0, (int)img.glId());
                            Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
                            VertexConsumerProvider provider = VertexConsumerProvider.shared();
                            class_287 bufferBuilder = provider.begin(class_293.class_5596.field_27382, class_290.field_1585);
                            bufferBuilder.method_22918(matrix4f, (float)left, (float)top, 0.0f).method_22913(0.0f, 1.0f);
                            bufferBuilder.method_22918(matrix4f, (float)left, (float)(top + 16), 0.0f).method_22913(0.0f, 0.0f);
                            bufferBuilder.method_22918(matrix4f, (float)(left + 16), (float)(top + 16), 0.0f).method_22913(1.0f, 0.0f);
                            bufferBuilder.method_22918(matrix4f, (float)(left + 16), (float)top, 0.0f).method_22913(1.0f, 1.0f);
                            AxiomRenderPipelines.POSITION_TEX.render(provider.build());
                        }
                        if (mouseX < left - 1 || mouseX >= left + 17 || mouseY < top - 1 || mouseY >= top + 17) continue;
                        guiGraphics.method_51740(class_1921.method_51785(), left, top, left + 16, top + 16, -2130706433, -2130706433, 0);
                        guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)customBlockState.getCustomBlock().axiom$translationKey()), mouseX, mouseY);
                    }
                }
                class_746 player = class_310.method_1551().field_1724;
                class_1661 inventory = player.method_31548();
                for (int invX = 0; invX < 9; ++invX) {
                    class_1799 itemStack = inventory.method_5438(invX);
                    if (itemStack.method_7960()) continue;
                    left = this.leftPos + 9 + invX * 18;
                    top = this.topPos + 112;
                    guiGraphics.method_51427(itemStack, left, top);
                    if (mouseX < left - 1 || mouseX >= left + 17 || mouseY < top - 1 || mouseY >= top + 17) continue;
                    guiGraphics.method_64038(this.field_22793, class_465.method_25408((class_310)this.field_22787, (class_1799)itemStack), itemStack.method_32347(), mouseX, mouseY);
                }
            }
        }
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrolling = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.scrolling) {
            int j = this.topPos + (this.screenType == 0 ? 33 : 18);
            int k = j + 112;
            this.scrollOffset = ((float)mouseY - (float)j - 7.5f) / ((float)(k - j) - 15.0f);
            this.scrollOffset = class_3532.method_15363((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dx, dy);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.screenType == 3) {
            gridLeft = this.leftPos + 9;
            int gridRight = gridLeft + 162;
            int gridTop = this.topPos + 33;
            int gridBottom = gridTop + 90;
            if (mouseX >= (double)gridLeft && mouseX < (double)gridRight) {
                int gridX = (int)((mouseX - (double)gridLeft) / (double)(gridRight - gridLeft) * 9.0);
                if (mouseY >= (double)gridTop && mouseY < (double)gridBottom) {
                    int index;
                    int gridY = (int)((mouseY - (double)gridTop) / (double)(gridBottom - gridTop) * 5.0);
                    List<ItemList.Entry> items = ItemList.INSTANCE.getItems();
                    int rows = (int)Math.ceil((float)items.size() / 9.0f) - 5;
                    int rowOffset = Math.round(this.scrollOffset * (float)rows);
                    if (rowOffset < 0) {
                        rowOffset = 0;
                    }
                    if ((index = gridX + gridY * 9 + rowOffset * 9) < items.size()) {
                        this.item = items.get(index).itemStack();
                        this.defaultItemDisplayTransformation = items.get(index).defaultItemDisplayTransformation();
                        this.defaultItemDisplayBrightness = items.get(index).defaultItemDisplayBrightness();
                        this.screenType = 0;
                        this.method_25426();
                        return true;
                    }
                } else if (mouseY >= (double)(this.topPos + 127) && mouseY < (double)(this.topPos + 127 + 18)) {
                    class_746 player = class_310.method_1551().field_1724;
                    class_1661 inventory = player.method_31548();
                    class_1799 itemStack = inventory.method_5438(gridX);
                    if (itemStack.method_7960()) {
                        return true;
                    }
                    this.item = itemStack;
                    this.screenType = 0;
                    this.method_25426();
                    return true;
                }
            }
        } else if (this.screenType == 4) {
            gridLeft = this.leftPos + 9;
            int gridRight = gridLeft + 162;
            int gridTop = this.topPos + 18;
            int gridBottom = gridTop + 90;
            if (mouseX >= (double)gridLeft && mouseX < (double)gridRight) {
                int gridX = (int)((mouseX - (double)gridLeft) / (double)(gridRight - gridLeft) * 9.0);
                if (mouseY >= (double)gridTop && mouseY < (double)gridBottom) {
                    int index;
                    int gridY = (int)((mouseY - (double)gridTop) / (double)(gridBottom - gridTop) * 5.0);
                    List<BlockList.Entry> blocks = EditorUI.getBlockList().getBlocks();
                    int rows = (int)Math.ceil((float)blocks.size() / 9.0f) - 5;
                    int rowOffset = Math.round(this.scrollOffset * (float)rows);
                    if (rowOffset < 0) {
                        rowOffset = 0;
                    }
                    if ((index = gridX + gridY * 9 + rowOffset * 9) < blocks.size()) {
                        this.blockState = blocks.get(index).state();
                        this.screenType = 1;
                        this.method_25426();
                        return true;
                    }
                } else if (mouseY >= (double)(this.topPos + 112) && mouseY < (double)(this.topPos + 112 + 18)) {
                    class_746 player = class_310.method_1551().field_1724;
                    class_1661 inventory = player.method_31548();
                    class_1799 itemStack = inventory.method_5438(gridX);
                    if (itemStack.method_7960()) {
                        return true;
                    }
                    this.blockState = (CustomBlockState)class_2248.method_9503((class_1792)itemStack.method_7909()).method_9564();
                    this.screenType = 1;
                    this.method_25426();
                    return true;
                }
            }
        }
        this.updateHovered((int)mouseX, (int)mouseY);
        switch (this.hovered) {
            case 1: {
                this.onlyCustomItems = !this.onlyCustomItems;
                ItemList.INSTANCE.search(this.searchBox.method_1882(), this.onlyCustomItems);
                return true;
            }
            case 3: {
                if (this.screenType != 0) {
                    this.screenType = 0;
                    this.method_25426();
                    return true;
                }
                return false;
            }
            case 4: {
                if (this.screenType != 1) {
                    this.screenType = 1;
                    this.method_25426();
                    return true;
                }
                return false;
            }
            case 5: {
                if (this.screenType != 2) {
                    this.screenType = 2;
                    this.method_25426();
                    return true;
                }
                return false;
            }
            case 0: {
                this.screenType = 3;
                this.method_25426();
                return true;
            }
            case 6: {
                this.screenType = 4;
                this.method_25426();
                return true;
            }
            case 2: {
                this.scrolling = true;
                return true;
            }
        }
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        class_8016 componentPath = this.method_48218();
        if (componentPath != null) {
            componentPath.method_48195(false);
        }
        return false;
    }

    private void updateHovered(int mouseX, int mouseY) {
        this.hovered = -1;
        if (this.canSwitchType && (this.screenType == 0 || this.screenType == 1 || this.screenType == 2) && mouseY >= this.topPos - 28 && mouseY < this.topPos) {
            if (mouseX >= this.leftPos && mouseX <= this.leftPos + 26) {
                this.hovered = 3;
                return;
            }
            if (mouseX >= this.leftPos + 27 && mouseX <= this.leftPos + 26 + 27) {
                this.hovered = 4;
                return;
            }
            if (mouseX >= this.leftPos + 54 && mouseX <= this.leftPos + 26 + 54) {
                this.hovered = 5;
                return;
            }
        }
        if (this.screenType == 3) {
            if (mouseX >= this.leftPos + 10 && mouseX <= this.leftPos + 23 && mouseY >= this.topPos + 18 && mouseY <= this.topPos + 30) {
                this.hovered = 1;
                return;
            }
            List<ItemList.Entry> items = ItemList.INSTANCE.getItems();
            int rows = (int)Math.ceil((float)items.size() / 9.0f) - 5;
            if (rows > 0) {
                int scrollerY = this.topPos + 33 + (int)(95.0f * this.scrollOffset);
                if (mouseX >= this.leftPos + 175 && mouseX <= this.leftPos + 175 + 12 && mouseY >= scrollerY && mouseY <= scrollerY + 15) {
                    this.hovered = 2;
                }
            }
        } else if (this.screenType == 4) {
            List<BlockList.Entry> blocks = EditorUI.getBlockList().getBlocks();
            int rows = (int)Math.ceil((float)blocks.size() / 9.0f) - 5;
            if (rows > 0) {
                int scrollerY = this.topPos + 18 + (int)(95.0f * this.scrollOffset);
                if (mouseX >= this.leftPos + 175 && mouseX <= this.leftPos + 175 + 12 && mouseY >= scrollerY && mouseY <= scrollerY + 15) {
                    this.hovered = 2;
                }
            }
        } else if (this.screenType == 0) {
            if (mouseX >= this.leftPos + 8 && mouseX <= this.leftPos + 26 && mouseY >= this.topPos + 17 && mouseY <= this.topPos + 35) {
                this.hovered = 0;
            }
        } else if (this.screenType == 1 && mouseX >= this.leftPos + 8 && mouseX <= this.leftPos + 26 && mouseY >= this.topPos + 17 && mouseY <= this.topPos + 35) {
            this.hovered = 6;
        }
    }

    public static final class BasicStringWidget
    extends class_8130 {
        public BasicStringWidget(int i, int j, int k, int l, class_2561 component, class_327 font) {
            super(i, j, k, l, component, font);
        }

        protected void method_48579(class_332 guiGraphics, int i, int j, float f) {
            guiGraphics.method_51430(this.method_48977(), this.method_25369().method_30937(), this.method_46426(), this.method_46427(), this.method_48979(), false);
        }
    }
}

