/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.utils.IntWrapper;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import java.text.NumberFormat;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_638;

public class WaterlogOperation {
    private static final class_2680 WATER = class_2246.field_10382.method_9564();

    public static void waterlog() {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            WaterlogOperation.waterlogAABB(aabb);
        } else if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            WaterlogOperation.waterlogSet(set);
        }
    }

    private static void waterlogAABB(SelectionBuffer.AABB aabb) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        int changeCount = 0;
        int minX = aabb.min().method_10263();
        int minY = aabb.min().method_10264();
        int minZ = aabb.min().method_10260();
        int maxX = aabb.max().method_10263();
        int maxY = aabb.max().method_10264();
        int maxZ = aabb.max().method_10260();
        minY = Math.max(world.method_31607(), minY);
        maxY = Math.min(world.method_31600(), maxY);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 block;
                    class_2818 levelChunk;
                    mutableBlockPos.method_10103(x, y, z);
                    if (world.method_31606((class_2338)mutableBlockPos) || (levelChunk = (class_2818)world.method_8402(class_4076.method_18675((int)x), class_4076.method_18675((int)z), class_2806.field_12803, false)) == null || (block = levelChunk.method_8320((class_2338)mutableBlockPos)).method_26204() == class_2246.field_10243) continue;
                    if (block.method_26215() || !block.method_26227().method_15769()) {
                        setOperation.set(x, y, z, WATER);
                        previousBlocksForUndo.set(x, y, z, block);
                        ++changeCount;
                        continue;
                    }
                    if (!block.method_28498((class_2769)class_2741.field_12508)) continue;
                    setOperation.set(x, y, z, (class_2680)block.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)));
                    previousBlocksForUndo.set(x, y, z, block);
                    ++changeCount;
                }
            }
        }
        String countString = NumberFormat.getInstance().format(changeCount);
        String historyDescription = AxiomI18n.get("axiom.history_description.waterlogged_n", countString);
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, aabb.center(), historyDescription, 0), Dispatcher.simpleSourceInfo("Waterlog Operation"));
    }

    private static void waterlogSet(SelectionBuffer.Set set) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        IntWrapper changeCount = new IntWrapper();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        set.selectionRegion.forEach((x, y, z) -> {
            mutableBlockPos.method_10103(x, y, z);
            if (world.method_31606((class_2338)mutableBlockPos)) {
                return;
            }
            class_2818 levelChunk = (class_2818)world.method_8402(class_4076.method_18675((int)x), class_4076.method_18675((int)z), class_2806.field_12803, false);
            if (levelChunk == null) {
                return;
            }
            class_2680 block = levelChunk.method_8320((class_2338)mutableBlockPos);
            if (block.method_26204() == class_2246.field_10243) {
                return;
            }
            if (block.method_26215() || !block.method_26227().method_15769()) {
                setOperation.set(x, y, z, WATER);
                previousBlocksForUndo.set(x, y, z, block);
                ++changeCount.value;
            } else if (block.method_28498((class_2769)class_2741.field_12508)) {
                setOperation.set(x, y, z, (class_2680)block.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)));
                previousBlocksForUndo.set(x, y, z, block);
                ++changeCount.value;
            }
        });
        String countString = NumberFormat.getInstance().format(changeCount.value);
        String historyDescription = AxiomI18n.get("axiom.history_description.waterlogged_n", countString);
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, set.selectionRegion.getCenter(), historyDescription, 0), Dispatcher.simpleSourceInfo("Waterlog Operation"));
    }
}

