/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.widgets;

import com.moulberry.axiom.custom_blocks.CustomBlock;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.StringProperty;
import com.moulberry.axiom.editor.BlockList;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.utils.StringUtils;
import imgui.ImGui;
import imgui.ImGuiViewport;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3542;

public class BlockStateWidget {
    private CustomBlock block;
    private CustomBlockState blockState;
    private final Map<class_2769<?>, Comparable<?>> selectedProperties = new LinkedHashMap();
    private float maxLabelWidth = 0.0f;
    private float maxControlWidth = 0.0f;
    private final SelectBlockWidget selectBlockWidget = new SelectBlockWidget(false);

    public BlockStateWidget(class_2248 block) {
        this.switchBlock((CustomBlock)block);
    }

    public void setFilter(Predicate<CustomBlockState> filter) {
        this.selectBlockWidget.setFilter(filter);
    }

    public void renderBlockSwitcher(BlockList blockList, String id) {
        boolean clicked = ImGuiHelper.blockStateButton(this.blockState, ImGui.getID(id), (int)(52.0f * EditorUI.getUiScale()));
        CustomBlockState dragDropped = ImGuiHelper.blockStateDragDrop(this.blockState);
        if (dragDropped != null) {
            this.setBlockState(dragDropped);
        }
        if (clicked) {
            this.selectBlockWidget.open();
        }
        ImGuiViewport viewport = ImGui.getMainViewport();
        ImGui.setNextWindowPos(viewport.getCenterX(), viewport.getCenterY(), 8, 0.5f, 0.5f);
        this.selectBlockWidget.render(AxiomI18n.get("axiom.widget.select_block"), blockList);
        CustomBlockState selectedBlock = this.selectBlockWidget.getResultState();
        if (selectedBlock != null) {
            this.switchBlock(selectedBlock.getCustomBlock());
            this.setBlockState(selectedBlock);
        }
    }

    public float renderPropertySettings(String id, boolean compressed) {
        boolean propertiesChanged = false;
        float maxX = 0.0f;
        float start = ImGui.getCursorPosX();
        if (compressed && this.maxLabelWidth + ImGui.getStyle().getCellPaddingX() + this.maxControlWidth + 8.0f <= ImGui.getContentRegionAvailX()) {
            compressed = false;
        }
        this.maxLabelWidth = 0.0f;
        this.maxControlWidth = 0.0f;
        if (!compressed) {
            ImGui.setCursorPosY(ImGui.getCursorPosY() - ImGui.getStyle().getCellPaddingY());
        }
        if (compressed || ImGui.beginTable("##PropertyTable" + id, 2, 73728)) {
            for (Map.Entry<class_2769<?>, Comparable<?>> entry : this.selectedProperties.entrySet()) {
                class_2769<?> property = entry.getKey();
                Comparable<?> value = entry.getValue();
                String prettyName = StringUtils.convertSnakeToWords(property.method_11899());
                float offset = ImGui.getStyle().getFramePaddingY();
                if (!compressed) {
                    ImGui.tableNextColumn();
                }
                ImGui.setCursorPosY(ImGui.getCursorPosY() + offset);
                ImGui.text(prettyName);
                ImGui.sameLine(0.0f, 0.0f);
                this.maxLabelWidth = Math.max(ImGui.getCursorPosX() - start, this.maxLabelWidth);
                ImGui.dummy(0.0f, 0.0f);
                if (compressed) {
                    ImGui.sameLine();
                    ImGui.setCursorPosY(ImGui.getCursorPosY() - offset);
                } else {
                    ImGui.tableNextColumn();
                }
                float controlStart = ImGui.getCursorPosX();
                if (property instanceof class_2754) {
                    Enum enumVal;
                    class_2754 enumProperty = (class_2754)property;
                    String[] values = new String[enumProperty.method_11898().size()];
                    int currentIndex = -1;
                    Iterator iterator = enumProperty.method_11898().iterator();
                    for (int i = 0; i < values.length; ++i) {
                        enumVal = (Enum)iterator.next();
                        values[i] = StringUtils.convertSnakeToWords(((class_3542)enumVal).method_15434());
                        if (enumVal != value) continue;
                        currentIndex = i;
                    }
                    ImGui.setNextItemWidth(!compressed ? 128.0f : Math.min(ImGui.getContentRegionAvailX(), 128.0f));
                    array = new int[]{currentIndex};
                    ImGuiHelper.combo("##Combo" + prettyName, (int[])array, values);
                    if (array[0] != currentIndex) {
                        propertiesChanged = true;
                        iterator = enumProperty.method_11898().iterator();
                        enumVal = null;
                        for (int i = 0; i <= array[0]; ++i) {
                            enumVal = (Enum)iterator.next();
                        }
                        this.selectedProperties.put(property, (Comparable<?>)((Object)enumVal));
                    }
                } else if (property instanceof StringProperty) {
                    StringProperty stringProperty = (StringProperty)property;
                    String[] values = new String[stringProperty.method_11898().size()];
                    int currentIndex = -1;
                    int index = 0;
                    for (String stringValue : stringProperty.method_11898()) {
                        values[index] = StringUtils.convertSnakeToWords(stringValue);
                        if (stringValue == value) {
                            currentIndex = index;
                        }
                        ++index;
                    }
                    ImGui.setNextItemWidth(!compressed ? 128.0f : Math.min(ImGui.getContentRegionAvailX(), 128.0f));
                    array = new int[]{currentIndex};
                    ImGuiHelper.combo("##Combo" + prettyName, (int[])array, values);
                    if (array[0] != currentIndex) {
                        propertiesChanged = true;
                        Iterator<String> iterator = stringProperty.method_11898().iterator();
                        String stringVal = null;
                        for (int i = 0; i <= array[0]; ++i) {
                            stringVal = iterator.next();
                        }
                        this.selectedProperties.put(property, (Comparable<?>)((Object)stringVal));
                    }
                } else if (property instanceof class_2746) {
                    if (!compressed || ImGui.getContentRegionAvailX() >= 80.0f + ImGui.getStyle().getItemSpacingX()) {
                        if (((Boolean)value).booleanValue()) {
                            ImGui.beginDisabled();
                        }
                        if (ImGui.button(AxiomI18n.get("axiom.widget.true_block_property") + "##Bool" + prettyName)) {
                            propertiesChanged = true;
                            this.selectedProperties.put(property, Boolean.valueOf(true));
                        }
                        if (((Boolean)value).booleanValue()) {
                            ImGui.endDisabled();
                        }
                        ImGui.sameLine();
                        if (!((Boolean)value).booleanValue()) {
                            ImGui.beginDisabled();
                        }
                        if (ImGui.button(AxiomI18n.get("axiom.widget.false_block_property") + "##Bool" + prettyName)) {
                            propertiesChanged = true;
                            this.selectedProperties.put(property, Boolean.valueOf(false));
                        }
                        if (!((Boolean)value).booleanValue()) {
                            ImGui.endDisabled();
                        }
                    } else {
                        ImGui.setNextItemWidth(ImGui.getContentRegionAvailX());
                        int currentValue = (Boolean)value != false ? 0 : 1;
                        int[] array = new int[]{currentValue};
                        ImGuiHelper.combo("##BoolCombo" + prettyName, array, new String[]{AxiomI18n.get("axiom.widget.true_block_property"), AxiomI18n.get("axiom.widget.false_block_property")});
                        if (array[0] != currentValue) {
                            propertiesChanged = true;
                            if (array[0] == 0) {
                                this.selectedProperties.put(property, Boolean.valueOf(true));
                            } else {
                                this.selectedProperties.put(property, Boolean.valueOf(false));
                            }
                        }
                    }
                } else if (property instanceof class_2758) {
                    class_2758 integerProperty = (class_2758)property;
                    int[] array = new int[]{(Integer)value};
                    ImGui.setNextItemWidth(!compressed ? 128.0f : Math.min(ImGui.getContentRegionAvailX(), 128.0f));
                    ImGui.sliderInt("##Slider" + prettyName, array, integerProperty.field_37655, integerProperty.field_37656);
                    if (array[0] != (Integer)value && array[0] >= integerProperty.field_37655 && array[0] <= integerProperty.field_37656) {
                        propertiesChanged = true;
                        this.selectedProperties.put(property, Integer.valueOf(array[0]));
                    }
                } else {
                    ImGui.text(String.valueOf(property.getClass()));
                }
                ImGui.sameLine(0.0f, 0.0f);
                maxX = Math.max(ImGui.getCursorPosX(), maxX);
                this.maxControlWidth = Math.max(ImGui.getCursorPosX() - controlStart, this.maxControlWidth);
                ImGui.dummy(0.0f, 0.0f);
            }
            if (!compressed) {
                ImGui.endTable();
            }
        }
        if (propertiesChanged) {
            this.blockState = this.block.axiom$defaultCustomState();
            for (Map.Entry<class_2769<?>, Comparable<?>> entry : this.selectedProperties.entrySet()) {
                this.blockState = this.blockState.setPropertyUnsafe(entry.getKey(), entry.getValue());
            }
        }
        return maxX - start;
    }

    public boolean hasEditableProperties() {
        return !this.selectedProperties.isEmpty();
    }

    public CustomBlockState getBlockState() {
        return this.blockState;
    }

    public void setBlockState(CustomBlockState blockState) {
        if (this.blockState == blockState) {
            return;
        }
        this.blockState = blockState;
        this.block = this.blockState.getCustomBlock();
        this.selectedProperties.clear();
        for (class_2769<?> property : this.blockState.getProperties()) {
            this.selectedProperties.put(property, (Comparable<?>)this.blockState.getProperty(property));
        }
    }

    private void switchBlock(CustomBlock block) {
        this.blockState = block.axiom$defaultCustomState();
        if (this.block == null || this.block == block) {
            this.selectedProperties.clear();
            for (class_2769<?> class_27692 : this.blockState.getProperties()) {
                this.selectedProperties.put(class_27692, (Comparable<?>)this.blockState.getProperty(class_27692));
            }
        } else {
            this.selectedProperties.keySet().retainAll(this.blockState.getProperties());
            for (class_2769<?> class_27693 : this.blockState.getProperties()) {
                if (this.selectedProperties.containsKey(class_27693)) continue;
                this.selectedProperties.put(class_27693, (Comparable<?>)this.blockState.getProperty(class_27693));
            }
            for (Map.Entry entry : this.selectedProperties.entrySet()) {
                this.blockState = this.blockState.setPropertyUnsafe((class_2769)entry.getKey(), (Comparable)entry.getValue());
            }
        }
        this.block = block;
    }
}

