/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.clipboard_installation;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.blueprint.Blueprint;
import com.moulberry.axiom.blueprint.BlueprintIo;
import com.moulberry.axiom.clipboard.Clipboard;
import com.moulberry.axiom.editor.clipboard_installation.ClipboardInstallationTask;
import com.moulberry.axiom.utils.AsyncFileDialogs;
import com.moulberry.axiom.utils.StringUtils;
import imgui.ImGui;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class ClipboardInstallBlueprintTask
implements ClipboardInstallationTask {
    private final String name;
    private final String downloadUrl;
    private final String confirmationMessage;
    private boolean started = false;
    private boolean finished = false;
    private float progress = 0.0f;
    private Exception exception = null;

    public ClipboardInstallBlueprintTask(String name, String downloadUrl) {
        this.name = name;
        this.downloadUrl = downloadUrl;
        this.confirmationMessage = "Do you want to download and install the blueprint '" + this.name + "' from " + this.downloadUrl;
    }

    @Override
    public void renderConfirmationPopup() {
        ImGui.textWrapped(this.confirmationMessage);
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        new Thread(() -> {
            try {
                byte[] blueprintBytes = ClipboardInstallationTask.downloadWithProgress(new URL(this.downloadUrl), f -> {
                    this.progress = f.floatValue() * 0.9f;
                });
                Blueprint blueprint = BlueprintIo.readBlueprint(new ByteArrayInputStream(blueprintBytes));
                Clipboard.INSTANCE.setClipboard(blueprint);
                this.progress = 0.95f;
                Path blueprintDir = Axiom.getInstance().getBlueprintDirectory();
                String separator = blueprintDir.getFileSystem().getSeparator();
                String blueprintNameString = this.name.trim();
                Object snakeName = blueprintNameString.isEmpty() ? "unnamed.bp" : blueprintNameString.toLowerCase(Locale.ROOT).replace(' ', '_').replace(separator, "_") + ".bp";
                snakeName = StringUtils.sanitizePath((String)snakeName);
                ((CompletableFuture)AsyncFileDialogs.saveFileDialog(blueprintDir.toString(), (String)snakeName, "Blueprint Files", "bp").thenAccept(str -> {
                    if (str != null) {
                        Path path = Path.of(str, new String[0]);
                        try {
                            Files.write(path, blueprintBytes, new OpenOption[0]);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                })).get();
                this.finished = true;
            }
            catch (Exception e) {
                Axiom.LOGGER.error("Error while installing blueprint", e);
                this.exception = e;
            }
        }).start();
    }

    @Override
    public float progress() {
        return this.progress;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClipboardInstallBlueprintTask that = (ClipboardInstallBlueprintTask)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.downloadUrl, that.downloadUrl);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.downloadUrl);
        return result;
    }
}

