/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.moulberry.axiom.AxiomClient;
import com.moulberry.axiom.BuildConfig;
import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.ServerConfig;
import com.moulberry.axiom.block_maps.BlockColourMap;
import com.moulberry.axiom.blueprint.ServerBlueprintManager;
import com.moulberry.axiom.capabilities.BuildSymmetry;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.displayentity.ItemList;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.tutorial.TutorialManager;
import com.moulberry.axiom.hooks.ServerLevelExt;
import com.moulberry.axiom.marker.MarkerEntityManipulator;
import com.moulberry.axiom.packets.AxiomClientboundAckWorldProperties;
import com.moulberry.axiom.packets.AxiomClientboundAddServerHeightmap;
import com.moulberry.axiom.packets.AxiomClientboundAllowedGamemodes;
import com.moulberry.axiom.packets.AxiomClientboundAnnotationUpdate;
import com.moulberry.axiom.packets.AxiomClientboundCustomBlocks;
import com.moulberry.axiom.packets.AxiomClientboundEditorWarning;
import com.moulberry.axiom.packets.AxiomClientboundEnable;
import com.moulberry.axiom.packets.AxiomClientboundIgnoreDisplayEntities;
import com.moulberry.axiom.packets.AxiomClientboundMarkerData;
import com.moulberry.axiom.packets.AxiomClientboundMarkerNbtResponse;
import com.moulberry.axiom.packets.AxiomClientboundRegisterWorldProperties;
import com.moulberry.axiom.packets.AxiomClientboundResponseChunkData;
import com.moulberry.axiom.packets.AxiomClientboundResponseEntityData;
import com.moulberry.axiom.packets.AxiomClientboundRestrictions;
import com.moulberry.axiom.packets.AxiomClientboundSetWorldProperty;
import com.moulberry.axiom.packets.AxiomServerboundAnnotationUpdate;
import com.moulberry.axiom.packets.AxiomServerboundDeleteEntity;
import com.moulberry.axiom.packets.AxiomServerboundHello;
import com.moulberry.axiom.packets.AxiomServerboundManipulateEntity;
import com.moulberry.axiom.packets.AxiomServerboundMarkerNbtRequest;
import com.moulberry.axiom.packets.AxiomServerboundRequestChunkData;
import com.moulberry.axiom.packets.AxiomServerboundRequestEntityData;
import com.moulberry.axiom.packets.AxiomServerboundSetBlock;
import com.moulberry.axiom.packets.AxiomServerboundSetBuffer;
import com.moulberry.axiom.packets.AxiomServerboundSetFlySpeed;
import com.moulberry.axiom.packets.AxiomServerboundSetGameMode;
import com.moulberry.axiom.packets.AxiomServerboundSetTime;
import com.moulberry.axiom.packets.AxiomServerboundSetWorldProperty;
import com.moulberry.axiom.packets.AxiomServerboundSpawnEntity;
import com.moulberry.axiom.packets.AxiomServerboundTeleport;
import com.moulberry.axiom.packets.blueprint.AxiomClientboundBlueprintManifest;
import com.moulberry.axiom.packets.blueprint.AxiomClientboundResponseBlueprint;
import com.moulberry.axiom.packets.blueprint.AxiomServerboundRequestBlueprint;
import com.moulberry.axiom.packets.blueprint.AxiomServerboundUploadBlueprint;
import com.moulberry.axiom.render.BiomeOverlayRenderer;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.CollisionMeshOverlayRenderer;
import com.moulberry.axiom.render.ShaderManager;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.utils.DFUHelper;
import com.moulberry.axiom.utils.IrisApiWrapper;
import com.moulberry.axiom.utils.NvidiumApiWrapper;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_properties.AxiomGameRules;
import com.moulberry.axi\u03bfm.utils.Authorization;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Axiom
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger("axiom");
    private static Axiom INSTANCE;
    public ServerConfig serverConfig = null;
    private Path configDirectory;
    private Path blueprintDirectory;
    private boolean shouldInitializeServerBlueprints = false;
    private static boolean checkedForFabricPermissionAPI;
    private static Method permissionCheckMethod;

    public static Axiom getInstance() {
        return INSTANCE;
    }

    public Path getConfigDirectory() {
        return this.configDirectory;
    }

    public Path getBlueprintDirectory() {
        return this.blueprintDirectory;
    }

    public void onInitialize() {
        INSTANCE = this;
        LOGGER.info("Initializing " + Authorization.getUserAgent() + ". Build timestamp: " + BuildConfig.BUILD_TIME);
        AxiomGameRules.register();
        this.configDirectory = FabricLoader.getInstance().getConfigDir().resolve("axiom");
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            DFUHelper.checkContainerFormat();
            IrisApiWrapper.setupIfIrisInstalled();
            NvidiumApiWrapper.setupIfNvidiumInstalled();
            Path configPath = this.configDirectory.resolve("axiom.hocon");
            Path internalConfigPath = this.configDirectory.resolve(".axiominternal.hocon");
            ToolManager.initializeTools();
            Configuration.load(configPath, internalConfigPath);
            this.blueprintDirectory = this.configDirectory.resolve("blueprints");
            this.clearEmptyHistory();
            String customBlueprintPath = Configuration.blueprint.customPath.trim();
            if (!customBlueprintPath.isEmpty()) {
                Path path = Path.of(customBlueprintPath, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        this.blueprintDirectory = path;
                    } else {
                        LOGGER.error("Unable to set custom blueprint path, {} is not a directory", (Object)path);
                    }
                } else {
                    LOGGER.error("Unable to set custom blueprint path, folder {} does not exist", (Object)path);
                }
            }
            try {
                Files.createDirectories(this.blueprintDirectory, new FileAttribute[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Authorization.checkCommercial();
            ShaderManager.INSTANCE.register();
            ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)ShaderManager.INSTANCE);
            ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

                public class_2960 getFabricId() {
                    return class_2960.method_60654((String)"axiom:blocklist");
                }

                public void method_14491(class_3300 resourceManager) {
                    EditorUI.getBlockList().markNeedsReload();
                    ItemList.INSTANCE.markDirty();
                    BlockColourMap.invalidateCache();
                }
            });
            TutorialManager.initialize();
            ClientEvents.register();
        }
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            this.blueprintDirectory = this.configDirectory.resolve("blueprints");
            try {
                Files.createDirectories(this.blueprintDirectory, new FileAttribute[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.shouldInitializeServerBlueprints = true;
        }
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            ((ServerLevelExt)world).axiom$processTasks();
            if (this.shouldInitializeServerBlueprints) {
                this.shouldInitializeServerBlueprints = false;
                ServerBlueprintManager.initialize(this.blueprintDirectory);
            }
        });
        AxiomClientboundAckWorldProperties.register();
        AxiomClientboundSetWorldProperty.register();
        AxiomClientboundEnable.register();
        AxiomClientboundCustomBlocks.register();
        AxiomClientboundEditorWarning.register();
        AxiomClientboundAllowedGamemodes.register();
        AxiomClientboundIgnoreDisplayEntities.register();
        AxiomClientboundAnnotationUpdate.register();
        AxiomClientboundAddServerHeightmap.register();
        AxiomClientboundResponseChunkData.register();
        AxiomClientboundRegisterWorldProperties.register();
        AxiomClientboundRestrictions.register();
        AxiomClientboundMarkerData.register();
        AxiomClientboundMarkerNbtResponse.register();
        AxiomClientboundBlueprintManifest.register();
        AxiomClientboundResponseBlueprint.register();
        AxiomClientboundResponseEntityData.register();
        AxiomServerboundHello.register();
        AxiomServerboundAnnotationUpdate.register();
        AxiomServerboundSetTime.register();
        AxiomServerboundSetWorldProperty.register();
        AxiomServerboundSetGameMode.register();
        AxiomServerboundSetFlySpeed.register();
        AxiomServerboundTeleport.register();
        AxiomServerboundSetBlock.register();
        AxiomServerboundSetBuffer.register();
        AxiomServerboundRequestChunkData.register();
        AxiomServerboundManipulateEntity.register();
        AxiomServerboundSpawnEntity.register();
        AxiomServerboundDeleteEntity.register();
        AxiomServerboundMarkerNbtRequest.register();
        AxiomServerboundRequestBlueprint.register();
        AxiomServerboundUploadBlueprint.register();
        AxiomServerboundRequestEntityData.register();
    }

    private void clearEmptyHistory() {
        Path historyFolder = this.configDirectory.resolve("history");
        if (Files.exists(historyFolder, new LinkOption[0])) {
            try (DirectoryStream<Path> folders = Files.newDirectoryStream(historyFolder);){
                for (Path folder : folders) {
                    boolean isEmpty;
                    try (DirectoryStream<Path> children = Files.newDirectoryStream(folder);){
                        isEmpty = !children.iterator().hasNext();
                    }
                    if (!isEmpty) continue;
                    Files.delete(folder);
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to clear empty history folders", e);
            }
        }
    }

    public boolean hasPermission(class_1657 player) {
        if (player.method_64475(2)) {
            return true;
        }
        if (!checkedForFabricPermissionAPI) {
            checkedForFabricPermissionAPI = true;
            try {
                Class<?> clazz = Class.forName("me.lucko.fabric.api.permissions.v0.Permissions");
                permissionCheckMethod = clazz.getMethod("check", class_1297.class, String.class);
            }
            catch (Throwable clazz) {
                // empty catch block
            }
        }
        if (permissionCheckMethod != null) {
            try {
                return (Boolean)permissionCheckMethod.invoke(null, player, "axiom.*");
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                permissionCheckMethod = null;
            }
        }
        return false;
    }

    public void dimensionChanged(class_5321<class_1937> resourceKey) {
        ChunkRenderOverrider.INSTANCE.clear();
        BiomeOverlayRenderer.INSTANCE.clear();
        CollisionMeshOverlayRenderer.INSTANCE.clear();
        Dispatcher.clearHistory();
        BuildSymmetry.clear();
        MarkerEntityManipulator.clear();
        if (Authorization.hasCommercialLicense()) {
            AxiomClient.loadCommercialLicenseHistory(resourceKey);
        }
    }

    public static boolean isDebugEnvironment() {
        return true;
    }

    public static void dbg(String string) {
        LOGGER.info(string);
    }

    static {
        checkedForFabricPermissionAPI = false;
        permissionCheckMethod = null;
    }
}

