/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark.elements;

import dev.dediamondpro.resourcify.libs.minemark.LayoutData;
import dev.dediamondpro.resourcify.libs.minemark.LayoutStyle;
import dev.dediamondpro.resourcify.libs.minemark.elements.Inline;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import dev.dediamondpro.resourcify.libs.minemark.utils.MouseButton;
import java.io.Closeable;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public abstract class Element<S extends Style, R>
implements Closeable {
    @Nullable
    protected final Element<S, R> parent;
    protected final ArrayList<Element<S, R>> children = new ArrayList();
    protected final String qName;
    protected final Attributes attributes;
    protected final S style;
    protected LayoutStyle layoutStyle;
    protected boolean isInline = this instanceof Inline && ((Inline)((Object)this)).isInline();

    public Element(@NotNull S style, @NotNull LayoutStyle layoutStyle, @Nullable Element<S, R> parent, @NotNull String qName, @Nullable Attributes attributes) {
        this.style = style;
        this.layoutStyle = layoutStyle;
        if (parent != null) {
            parent.getChildren().add(this);
        }
        this.parent = parent;
        this.qName = qName;
        this.attributes = attributes;
    }

    @ApiStatus.OverrideOnly
    public void complete() {
    }

    @ApiStatus.OverrideOnly
    public void drawInternal(float xOffset, float yOffset, float mouseX, float mouseY, R renderData) {
        for (Element<S, R> child : this.children) {
            child.drawInternal(xOffset, yOffset, mouseX, mouseY, renderData);
        }
    }

    @ApiStatus.OverrideOnly
    public void beforeDrawInternal(float xOffset, float yOffset, float mouseX, float mouseY, R renderData) {
        for (Element<S, R> child : this.children) {
            child.beforeDrawInternal(xOffset, yOffset, mouseX, mouseY, renderData);
        }
    }

    @ApiStatus.OverrideOnly
    public void onMouseClickedInternal(MouseButton button, float mouseX, float mouseY) {
        for (Element<S, R> child : this.children) {
            child.onMouseClickedInternal(button, mouseX, mouseY);
        }
    }

    @ApiStatus.Internal
    public void generateLayoutInternal(LayoutData layoutData, R renderData) {
        if (!this.isInline && layoutData.isLineOccupied()) {
            layoutData.nextLine();
        }
        this.generateLayout(layoutData, renderData);
        if (!this.isInline && layoutData.isLineOccupied()) {
            layoutData.nextLine();
        }
    }

    protected abstract void generateLayout(LayoutData var1, R var2);

    public void regenerateLayout() {
        if (this.parent == null) {
            throw new IllegalStateException("No top level MineMarkElement found to regenerate layout with.");
        }
        this.parent.regenerateLayout();
    }

    @Override
    public void close() {
        for (Element<S, R> child : this.children) {
            child.close();
        }
    }

    @ApiStatus.Internal
    public String buildTree(int depth) {
        StringBuilder builder = new StringBuilder();
        builder.append(this);
        for (Element<S, R> child : this.children) {
            builder.append("\n");
            for (int i2 = 0; i2 < depth; ++i2) {
                builder.append("  ");
            }
            builder.append("+ ");
            builder.append(child.buildTree(depth + 1));
        }
        return builder.toString();
    }

    @Nullable
    public Element<S, R> getParent() {
        return this.parent;
    }

    @NotNull
    public ArrayList<Element<S, R>> getChildren() {
        return this.children;
    }

    public S getStyle() {
        return this.style;
    }

    public LayoutStyle getLayoutStyle() {
        return this.layoutStyle;
    }

    public String getQName() {
        return this.qName;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setInline(boolean inline) {
        this.isInline = inline;
    }
}

