/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle_override;

import games.enchanted.blockplaceparticles.config.ConfigHandler;
import games.enchanted.blockplaceparticles.registry.BlockOrTagLocation;
import games.enchanted.blockplaceparticles.registry.RegistryHelpers;
import games.enchanted.blockplaceparticles.registry.TagUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockParticleOverride {
    public static final int ORIGIN_BLOCK_PLACED = 1;
    public static final int ORIGIN_BLOCK_BROKEN = 2;
    public static final int ORIGIN_BLOCK_PARTICLE_OVERRIDDEN = 3;
    public static final int ORIGIN_ITEM_PARTICLE_OVERRIDDEN = 4;
    public static final int ORIGIN_BLOCK_BRUSHED = 5;
    public static final int ORIGIN_BLOCK_CRACK = 6;
    public static final int ORIGIN_FALLING_BLOCK_LANDED = 7;
    public static final int ORIGIN_FALLING_BLOCK_FALLING = 8;
    public static final int ORIGIN_BLOCK_INTERACTED_WITH = 9;
    public static final int ORIGIN_BLOCK_WALKED_THROUGH = 10;
    public static final BlockParticleOverride NONE = new BlockParticleOverride("none");
    public static final BlockParticleOverride VANILLA = new BlockParticleOverride("vanilla_particle", "vanilla_block_override", (blockState, level, blockPos, overrideOrigin) -> new class_2388(class_2398.field_11217, blockState), () -> null, val -> {}, List.of(), () -> ConfigHandler.block_enabled, val -> {
        ConfigHandler.block_enabled = val;
    }, true, () -> ConfigHandler.maxBlock_onPlace, val -> {
        ConfigHandler.maxBlock_onPlace = val;
    }, 2, () -> ConfigHandler.maxBlock_onBreak, val -> {
        ConfigHandler.maxBlock_onBreak = val;
    }, 4, 1.0f);
    private static final ArrayList<BlockParticleOverride> blockParticleOverrides = new ArrayList();
    private final String name;
    private final String groupName;
    @NotNull
    final ReplaceParticleFromOriginConsumer shouldReplaceParticleFromOrigin_getter;
    @NotNull
    final GetParticleOptionConsumer getParticleOption;
    @Nullable
    final Supplier<List<BlockOrTagLocation>> supportedBlockResourceLocations_getter;
    @Nullable
    final Consumer<List<BlockOrTagLocation>> supportedBlockResourceLocations_setter;
    @Nullable
    final List<BlockOrTagLocation> supportedBlockResourceLocations_default;
    final Supplier<Boolean> overrideEnabled_getter;
    final Consumer<Boolean> overrideEnabled_setter;
    final boolean overrideEnabled_default;
    final Supplier<Integer> maxParticlesOnPlace_getter;
    final Consumer<Integer> maxParticlesOnPlace_setter;
    final int maxParticlesOnPlace_default;
    final Supplier<Integer> maxParticlesOnBreak_getter;
    final Consumer<Integer> maxParticlesOnBreak_setter;
    final int maxParticlesOnBreak_default;
    final float particleVelocityMultiplier;

    BlockParticleOverride(String overrideName, String groupName, @NotNull GetParticleOptionConsumer getParticleOption, @NotNull Supplier<List<BlockOrTagLocation>> supportedBlockResourceLocations_getter, @NotNull Consumer<List<BlockOrTagLocation>> supportedBlockResourceLocations_setter, @NotNull List<BlockOrTagLocation> supportedBlockResourceLocations_default, Supplier<Boolean> overrideEnabled_getter, Consumer<Boolean> overrideEnabled_setter, boolean overrideEnabled_default, Supplier<Integer> maxParticlesOnPlace_getter, Consumer<Integer> maxParticlesOnPlace_setter, int maxParticlesOnPlace_default, Supplier<Integer> maxParticlesOnBreak_getter, Consumer<Integer> maxParticlesOnBreak_setter, int maxParticlesOnBreak_default, float particleVelocityMultiplier) {
        this.name = overrideName;
        this.groupName = groupName;
        this.shouldReplaceParticleFromOrigin_getter = overrideOrigin -> true;
        this.getParticleOption = getParticleOption;
        this.supportedBlockResourceLocations_getter = supportedBlockResourceLocations_getter;
        this.overrideEnabled_getter = overrideEnabled_getter;
        this.maxParticlesOnPlace_getter = maxParticlesOnPlace_getter;
        this.maxParticlesOnBreak_getter = maxParticlesOnBreak_getter;
        this.supportedBlockResourceLocations_setter = supportedBlockResourceLocations_setter;
        this.overrideEnabled_setter = overrideEnabled_setter;
        this.maxParticlesOnPlace_setter = maxParticlesOnPlace_setter;
        this.maxParticlesOnBreak_setter = maxParticlesOnBreak_setter;
        this.supportedBlockResourceLocations_default = supportedBlockResourceLocations_default;
        this.overrideEnabled_default = overrideEnabled_default;
        this.maxParticlesOnPlace_default = maxParticlesOnPlace_default;
        this.maxParticlesOnBreak_default = maxParticlesOnBreak_default;
        this.particleVelocityMultiplier = particleVelocityMultiplier;
    }

    BlockParticleOverride(String overrideName, String groupName, @NotNull ReplaceParticleFromOriginConsumer shouldReplaceParticleFromOrigin_getter, @NotNull GetParticleOptionConsumer getParticleOption, @NotNull Supplier<List<BlockOrTagLocation>> supportedBlockResourceLocations_getter, @NotNull Consumer<List<BlockOrTagLocation>> supportedBlockResourceLocations_setter, @NotNull List<BlockOrTagLocation> supportedBlockResourceLocations_default, Supplier<Boolean> overrideEnabled_getter, Consumer<Boolean> overrideEnabled_setter, boolean overrideEnabled_default, Supplier<Integer> maxParticlesOnPlace_getter, Consumer<Integer> maxParticlesOnPlace_setter, int maxParticlesOnPlace_default, Supplier<Integer> maxParticlesOnBreak_getter, Consumer<Integer> maxParticlesOnBreak_setter, int maxParticlesOnBreak_default, float particleVelocityMultiplier) {
        this.name = overrideName;
        this.groupName = groupName;
        this.shouldReplaceParticleFromOrigin_getter = shouldReplaceParticleFromOrigin_getter;
        this.getParticleOption = getParticleOption;
        this.supportedBlockResourceLocations_getter = supportedBlockResourceLocations_getter;
        this.overrideEnabled_getter = overrideEnabled_getter;
        this.maxParticlesOnPlace_getter = maxParticlesOnPlace_getter;
        this.maxParticlesOnBreak_getter = maxParticlesOnBreak_getter;
        this.supportedBlockResourceLocations_setter = supportedBlockResourceLocations_setter;
        this.overrideEnabled_setter = overrideEnabled_setter;
        this.maxParticlesOnPlace_setter = maxParticlesOnPlace_setter;
        this.maxParticlesOnBreak_setter = maxParticlesOnBreak_setter;
        this.supportedBlockResourceLocations_default = supportedBlockResourceLocations_default;
        this.overrideEnabled_default = overrideEnabled_default;
        this.maxParticlesOnPlace_default = maxParticlesOnPlace_default;
        this.maxParticlesOnBreak_default = maxParticlesOnBreak_default;
        this.particleVelocityMultiplier = particleVelocityMultiplier;
    }

    private BlockParticleOverride(String overrideName) {
        this.name = overrideName;
        this.groupName = overrideName;
        this.shouldReplaceParticleFromOrigin_getter = overrideOrigin -> true;
        this.getParticleOption = (state, level, pos, overrideOrigin) -> null;
        this.supportedBlockResourceLocations_getter = null;
        this.overrideEnabled_getter = null;
        this.maxParticlesOnPlace_getter = null;
        this.maxParticlesOnBreak_getter = null;
        this.supportedBlockResourceLocations_setter = null;
        this.overrideEnabled_setter = null;
        this.maxParticlesOnPlace_setter = null;
        this.maxParticlesOnBreak_setter = null;
        this.supportedBlockResourceLocations_default = null;
        this.overrideEnabled_default = true;
        this.maxParticlesOnPlace_default = 0;
        this.maxParticlesOnBreak_default = 0;
        this.particleVelocityMultiplier = 1.0f;
    }

    @Nullable
    public class_2394 getParticleOptionForState(class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) {
        return this.getParticleOption.consume(blockState, level, blockPos, overrideOrigin);
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    public static BlockParticleOverride getOverrideForBlockState(class_2680 blockState, int overrideOrigin) {
        class_2248 block = blockState.method_26204();
        if (blockState.method_26215()) {
            return NONE;
        }
        class_2960 blockResourceLocation = RegistryHelpers.getLocationFromBlock(block);
        BlockParticleOverride returnOverride = null;
        for (BlockParticleOverride override : blockParticleOverrides) {
            if (!BlockParticleOverride.doesOverrideContainBlock(override, blockResourceLocation) || !override.overrideEnabled_getter.get().booleanValue()) continue;
            returnOverride = override;
            break;
        }
        if (returnOverride != null && returnOverride.shouldReplaceParticleFromOrigin(overrideOrigin)) {
            return returnOverride;
        }
        if (BlockParticleOverride.VANILLA.overrideEnabled_getter.get().booleanValue()) {
            return VANILLA;
        }
        return NONE;
    }

    private static boolean doesOverrideContainBlock(BlockParticleOverride override, class_2960 blockResourceLocation) {
        if (override.supportedBlockResourceLocations_getter == null) {
            return false;
        }
        return TagUtil.doesListContainBlock(override.supportedBlockResourceLocations_getter.get(), blockResourceLocation);
    }

    public static int getParticleMultiplierForOverride(BlockParticleOverride override, boolean isBlockBeingPlaced) {
        if (override == NONE) {
            return 0;
        }
        return BlockParticleOverride.getAppropriateMultiplier(isBlockBeingPlaced, override.maxParticlesOnPlace_getter.get(), override.maxParticlesOnBreak_getter.get());
    }

    private static int getAppropriateMultiplier(boolean isBlockBeingPlaced, int blockPlaceMultiplier, int blockBreakMultiplier) {
        if (isBlockBeingPlaced) {
            return blockPlaceMultiplier;
        }
        return blockBreakMultiplier;
    }

    public static List<BlockParticleOverride> getBlockParticleOverrides() {
        return blockParticleOverrides.stream().toList();
    }

    public static void addBlockParticleOverride(BlockParticleOverride override) {
        if (override == NONE || override == VANILLA) {
            throw new IllegalArgumentException("Cannot call BlockParticleOverride#addBlockParticleOverride with BlockParticleOverride.NONE or BlockParticleOverride.BLOCK");
        }
        blockParticleOverrides.add(override);
    }

    public String getName() {
        return this.name;
    }

    public String getGroupName() {
        return this.groupName;
    }

    @Nullable
    public Supplier<List<BlockOrTagLocation>> getSupportedBlockResourceLocations_getter() {
        return this.supportedBlockResourceLocations_getter;
    }

    @Nullable
    public Consumer<List<BlockOrTagLocation>> getSupportedBlockResourceLocations_setter() {
        return this.supportedBlockResourceLocations_setter;
    }

    @Nullable
    public List<BlockOrTagLocation> getSupportedBlockResourceLocations_default() {
        return this.supportedBlockResourceLocations_default;
    }

    public Supplier<Integer> getMaxParticlesOnPlace_getter() {
        return this.maxParticlesOnPlace_getter;
    }

    public Consumer<Integer> getMaxParticlesOnPlace_setter() {
        return this.maxParticlesOnPlace_setter;
    }

    public int getMaxParticlesOnPlace_default() {
        return this.maxParticlesOnPlace_default;
    }

    public Supplier<Integer> getMaxParticlesOnBreak_getter() {
        return this.maxParticlesOnBreak_getter;
    }

    public Consumer<Integer> getMaxParticlesOnBreak_setter() {
        return this.maxParticlesOnBreak_setter;
    }

    public int getMaxParticlesOnBreak_default() {
        return this.maxParticlesOnBreak_default;
    }

    public Supplier<Boolean> getOverrideEnabled_getter() {
        return this.overrideEnabled_getter;
    }

    public Consumer<Boolean> getOverrideEnabled_setter() {
        return this.overrideEnabled_setter;
    }

    public boolean getOverrideEnabled_default() {
        return this.overrideEnabled_default;
    }

    public float getParticleVelocityMultiplier() {
        return this.particleVelocityMultiplier;
    }

    public boolean shouldReplaceParticleFromOrigin(int overrideOrigin) {
        return this.shouldReplaceParticleFromOrigin_getter.consume(overrideOrigin);
    }

    public static interface ReplaceParticleFromOriginConsumer {
        public boolean consume(int var1);
    }

    public static interface GetParticleOptionConsumer {
        public class_2394 consume(class_2680 var1, class_638 var2, class_2338 var3, int var4);
    }
}

