/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle.option;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import games.enchanted.blockplaceparticles.particle.ModParticleTypes;
import games.enchanted.blockplaceparticles.util.ColourUtil;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class TintedParticleOption
implements class_2394 {
    public static final int BRUSH_COLOUR = 13551062;
    public static final float BRUSH_VARIATION = 0.23f;
    public static final TintedParticleOption BRUSH_OPTION = new TintedParticleOption(ModParticleTypes.BRUSH_DUST, 13551062, 0.23f, true);
    public static final TintedParticleOption BRUSH_SPECK_OPTION = new TintedParticleOption(ModParticleTypes.BRUSH_DUST_SPECK, 13551062, 0.23f, true);
    public static final int ITEM_FRAME_COLOUR = 0xFFFCF7;
    public static final float ITEM_FRAME_VARIATION = 0.18f;
    public static final TintedParticleOption ITEM_FRAME_DUST_OPTION = new TintedParticleOption(ModParticleTypes.ITEM_FRAME_DUST, 0xFFFCF7, 0.18f, true);
    public static final TintedParticleOption ITEM_FRAME_DUST_SPECK_OPTION = new TintedParticleOption(ModParticleTypes.ITEM_FRAME_DUST_SPECK, 0xFFFCF7, 0.18f, true);
    public static final int GLOW_ITEM_FRAME_COLOUR = 16771535;
    public static final float GLOW_ITEM_FRAME_VARIATION = 0.18f;
    public static final TintedParticleOption GLOW_ITEM_FRAME_DUST_OPTION = new TintedParticleOption(ModParticleTypes.GLOW_ITEM_FRAME_DUST, 16771535, 0.18f, true);
    public static final TintedParticleOption GLOW_ITEM_FRAME_DUST_SPECK_OPTION = new TintedParticleOption(ModParticleTypes.GLOW_ITEM_FRAME_DUST_SPECK, 16771535, 0.18f, true);
    public static final int REDSTONE = 0xF70000;
    public static final int REDSTONE_UNPOWERED = 0x660000;
    public static final TintedParticleOption REDSTONE_DUST_OPTION = new TintedParticleOption(ModParticleTypes.REDSTONE_DUST, 0xF70000, 0.4f, true);
    public static final TintedParticleOption REDSTONE_DUST_UNPOWERED_OPTION = new TintedParticleOption(ModParticleTypes.REDSTONE_DUST, 0x660000, 0.2f, true);
    private final class_2396<TintedParticleOption> type;
    private final int color;
    private final float variationAmount;
    private boolean uniformVariation;

    public TintedParticleOption(class_2396<TintedParticleOption> type, int colour, float variationAmount) {
        this.type = type;
        this.color = colour;
        this.variationAmount = variationAmount;
        this.uniformVariation = false;
    }

    public TintedParticleOption(class_2396<TintedParticleOption> type, int colour, float variationAmount, boolean uniformVariation) {
        this(type, colour, variationAmount);
        this.uniformVariation = uniformVariation;
    }

    private static Codec<TintedParticleOption> createCodec(class_2396<TintedParticleOption> type) {
        return RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_54067.fieldOf("colour").forGetter(TintedParticleOption::getColor), (App)Codec.FLOAT.optionalFieldOf("variation_amount", (Object)Float.valueOf(0.06f)).forGetter(TintedParticleOption::getVariationAmount), (App)Codec.BOOL.optionalFieldOf("uniform_variation", (Object)false).forGetter(TintedParticleOption::getUniformVariation)).apply((Applicative)instance, (colour, variation, uniformVariation) -> new TintedParticleOption(type, (int)colour, variation.floatValue(), (boolean)uniformVariation)));
    }

    public static MapCodec<TintedParticleOption> codec(class_2396<TintedParticleOption> type) {
        return TintedParticleOption.createCodec(type).fieldOf("colour_options");
    }

    public static class_9139<? super class_9129, TintedParticleOption> streamCodec(class_2396<TintedParticleOption> type) {
        return class_9135.method_56368(TintedParticleOption.createCodec(type));
    }

    @NotNull
    public class_2396<TintedParticleOption> method_10295() {
        return this.type;
    }

    public int getColor() {
        return this.color;
    }

    public float getVariationAmount() {
        return this.variationAmount;
    }

    public boolean getUniformVariation() {
        return this.uniformVariation;
    }

    public int[] getRandomisedColour() {
        int[] rgb = ColourUtil.RGBint_to_RGB(this.getColor());
        float colourVariation = this.getVariationAmount();
        int[] randomRgb = this.getUniformVariation() ? ColourUtil.randomiseNegativeUniform(rgb, colourVariation) : ColourUtil.randomiseNegative(rgb, colourVariation);
        return randomRgb;
    }
}

